/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;

public class AttachConfigurationDetail {
    private String hostName;
    private String portNumber;
    private Vector agents;
    private Vector options;
    private ArrayList filters;
    private String project;
    private String monitor;
    private String profileFile;
    private ILaunch launch;
    private boolean switchPerspective;
    private boolean forceAgentConfClear;

    public AttachConfigurationDetail() {
    }

    public AttachConfigurationDetail(ILaunchConfiguration configuration, ILaunch launch) {
        try {
            IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
            IPreferenceStore tStore = CommonUITracePlugin.getDefault().getPreferenceStore();
            this.hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            this.portNumber = String.valueOf(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port")));
            this.project = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, tStore.getString("prj_name"));
            this.monitor = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, tStore.getString("mon_name"));
            this.launch = launch;
            this.profileFile = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false) ? configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null) : null;
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
    }

    public Vector getAgents() {
        return this.agents;
    }

    public void setAgents(Vector agents) {
        this.agents = agents;
    }

    public ArrayList getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList filters) {
        this.filters = filters;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public String getMonitor() {
        return this.monitor;
    }

    public void setMonitor(String monitor) {
        this.monitor = monitor;
    }

    public Vector getOptions() {
        return this.options;
    }

    public void setOptions(Vector options) {
        this.options = options;
    }

    public String getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    public String getProfileFile() {
        return this.profileFile;
    }

    public void setProfileFile(String profileFile) {
        this.profileFile = profileFile;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public boolean isSwitchPerspective() {
        return this.switchPerspective;
    }

    public void setSwitchPerspective(boolean switchPerspective) {
        this.switchPerspective = switchPerspective;
    }

    public boolean isForceAgentConfClear() {
        return this.forceAgentConfClear;
    }

    public void setForceAgentConfClear(boolean forceAgentConfClear) {
        this.forceAgentConfClear = forceAgentConfClear;
    }
}

