/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.tptp.platform.execution.client.core.IConsole;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.client.core.IProcess;

class IOProxy
implements IStreamsProxy,
IStreamMonitor,
DataProcessor,
IDataProcessor {
    private List _listeners = new ArrayList();
    private StringBuffer _buffer = new StringBuffer();
    private Console _console;
    private IConsole _newConsole;

    public IOProxy(Object process) {
        if (process instanceof Process) {
            this._console = ((Process)process).getConsole();
            this._console.setDataProcessor((DataProcessor)this);
        } else if (process instanceof IProcess) {
            this._newConsole = ((IProcess)process).getConsole();
            this._newConsole.setDataProcessor((IDataProcessor)this);
        }
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return null;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this;
    }

    public void write(String input) throws IOException {
        if (this._console != null) {
            this._console.write(input);
        } else if (this._newConsole != null) {
            this._newConsole.write(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IStreamListener listener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IStreamListener listener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    public String getContents() {
        return this._buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        try {
            String str = new String(buffer, 0, length, "UTF8");
            this._buffer.append(str);
            List list = this._listeners;
            synchronized (list) {
                Iterator i = this._listeners.iterator();
                while (i.hasNext()) {
                    ((IStreamListener)i.next()).streamAppended(str, (IStreamMonitor)this);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            UIPlugin.getDefault().log(e);
        }
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
        byte[] buf = new String(buffer).getBytes();
        this.incommingData(buf, buf.length, peer);
    }

    public void invalidDataType(byte[] arg0, int arg1, InetAddress arg2) {
    }

    public void waitingForData() {
    }

    public void incomingData(byte[] buffer, int length, InetAddress peer) {
        this.incommingData(buffer, length, peer);
    }

    public void incomingData(char[] buffer, int length, InetAddress peer) {
        this.incommingData(buffer, length, peer);
    }
}

