/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

public class PerftraceUtil {
    private static NumberFormat _decimalFormat = null;
    private static NumberFormat _percentFormat = null;
    private static ArrayList tmpList = new ArrayList();

    public static int getActiveInstances(EObject mofObject) {
        int inst;
        block14: {
            block15: {
                TRCProcess proces;
                inst = 0;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                inst = proces.getTotalInstances() - proces.getCollectedInstances();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        inst += proces.getTotalInstances() - proces.getCollectedInstances();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            inst += proces.getTotalInstances() - proces.getCollectedInstances();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                inst += proces.getTotalInstances() - proces.getCollectedInstances();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return inst;
    }

    public static long getActiveSize(EObject mofObject) {
        long size;
        block14: {
            block15: {
                TRCProcess proces;
                size = 0L;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                size = proces.getTotalSize() - proces.getCollectedSize();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        size += (long)(proces.getTotalSize() - proces.getCollectedSize());
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            size += (long)(proces.getTotalSize() - proces.getCollectedSize());
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                size += (long)(proces.getTotalSize() - proces.getCollectedSize());
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return size;
    }

    public static Object[] getAllClasses(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentClasses((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    PerftraceUtil.getAgentClasses((TRCAgentProxy)agents[idx], tmpList);
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        PerftraceUtil.getAgentClasses((TRCAgentProxy)agents[i], tmpList);
                        ++i;
                    }
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            PerftraceUtil.getAgentClasses((TRCAgentProxy)agents[i], tmpList);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllGc(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentGc((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    PerftraceUtil.getAgentGc((TRCAgentProxy)agents[idx], tmpList);
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        PerftraceUtil.getAgentGc((TRCAgentProxy)agents[i], tmpList);
                        ++i;
                    }
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            PerftraceUtil.getAgentGc((TRCAgentProxy)agents[i], tmpList);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllHeapDump(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentHeapDump((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    PerftraceUtil.getAgentHeapDump((TRCAgentProxy)agents[idx], tmpList);
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        PerftraceUtil.getAgentHeapDump((TRCAgentProxy)agents[i], tmpList);
                        ++i;
                    }
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            PerftraceUtil.getAgentHeapDump((TRCAgentProxy)agents[i], tmpList);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllPackages(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentPackages((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    PerftraceUtil.getAgentPackages((TRCAgentProxy)agents[idx], tmpList);
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        PerftraceUtil.getAgentPackages((TRCAgentProxy)agents[i], tmpList);
                        ++i;
                    }
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            PerftraceUtil.getAgentPackages((TRCAgentProxy)agents[i], tmpList);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllReferences(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentObjReferences((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    PerftraceUtil.getAgentObjReferences((TRCAgentProxy)agents[idx], tmpList);
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        PerftraceUtil.getAgentObjReferences((TRCAgentProxy)agents[i], tmpList);
                        ++i;
                    }
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            PerftraceUtil.getAgentObjReferences((TRCAgentProxy)agents[i], tmpList);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllThreads(EObject mofObject) {
        return PerftraceUtil.getAllThreads(mofObject, true);
    }

    public static Object[] getAllThreads(EObject mofObject, boolean withInvocations) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentThreads((TRCAgentProxy)mofObject, tmpList, withInvocations);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    PerftraceUtil.getAgentThreads((TRCAgentProxy)agents[idx], tmpList, withInvocations);
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        PerftraceUtil.getAgentThreads((TRCAgentProxy)agents[i], tmpList, withInvocations);
                        ++i;
                    }
                    ++idx;
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            PerftraceUtil.getAgentThreads((TRCAgentProxy)agents[i], tmpList, withInvocations);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static TRCClass getClass(TRCMethodInvocation invocation) {
        TRCTraceObject o = invocation.getOwningObject();
        if (o != null && o.getIsA() != invocation.getProcess().getClassClass()) {
            return o.getIsA();
        }
        return invocation.getMethod().getDefiningClass();
    }

    public static TRCClass getClass(TRCObject object) {
        TRCClass clas = object.getIsA();
        if (clas == object.getProcess().getClassClass()) {
            TRCPackage[] packages = (TRCPackage[])object.getProcess().getPackages().toArray();
            int i = 0;
            while (i < packages.length) {
                TRCClass[] classes = (TRCClass[])packages[i].getClasses().toArray();
                int j = 0;
                while (j < classes.length) {
                    Object[] objects = classes[j].getClassObjects().toArray();
                    int k = 0;
                    while (k < objects.length) {
                        if (objects[k] == object) {
                            return classes[j];
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return clas;
    }

    public static double getMaximumTime(EObject mofObject) {
        double time;
        block14: {
            block15: {
                TRCProcess proces;
                time = 0.0;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                time = proces.getLastEventTime();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    double tmp;
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null && (tmp = proces.getLastEventTime()) > time) {
                        time = tmp;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        double tmp;
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null && (tmp = proces.getLastEventTime()) > time) {
                            time = tmp;
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            double tmp;
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null && (tmp = proces.getLastEventTime()) > time) {
                                time = tmp;
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return time;
    }

    public static String getPackageName(TRCPackage pack, Object mofObject) {
        StringBuffer buff = new StringBuffer(pack.getName());
        if (buff.length() == 0) {
            buff.append(TraceMessages._17);
        }
        if (mofObject instanceof TRCAgentProxy || mofObject instanceof TRCProcessProxy) {
            return buff.toString();
        }
        return buff.append(" [").append(pack.getProcess().getPid()).append("]").toString();
    }

    public static TRCProcess getProcess(TRCAgent agent) {
        if (agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)agent.getProcess();
        }
        return null;
    }

    public static String getThreadName(TRCThread thread) {
        StringBuffer tmpBuffer = new StringBuffer(thread.getName());
        return tmpBuffer.append("[").append(thread.getProcess().getPid()).append("]").toString();
    }

    public static long getTime(double etime) {
        return (long)(etime * 1000000.0);
    }

    public static int getTotalCalls(EObject mofObject) {
        int calls;
        block14: {
            block15: {
                TRCProcess proces;
                calls = 0;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                calls = proces.getCalls();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        calls += proces.getCalls();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            calls += proces.getCalls();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                calls += proces.getCalls();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return calls;
    }

    public static int getTotalInstances(EObject mofObject) {
        int inst;
        block14: {
            block15: {
                TRCProcess proces;
                inst = 0;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                inst = proces.getTotalInstances();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        inst += proces.getTotalInstances();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            inst += proces.getTotalInstances();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                inst += proces.getTotalInstances();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return inst;
    }

    public static int getTotalCollectedInstances(EObject mofObject) {
        int inst;
        block14: {
            block15: {
                TRCProcess proces;
                inst = 0;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                inst = proces.getCollectedInstances();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        inst += proces.getCollectedInstances();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            inst += proces.getCollectedInstances();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                inst += proces.getCollectedInstances();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return inst;
    }

    public static long getTotalSize(EObject mofObject) {
        long size;
        block14: {
            block15: {
                TRCProcess proces;
                size = 0L;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                size = proces.getTotalSize();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        size += (long)proces.getTotalSize();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            size += (long)proces.getTotalSize();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                size += (long)proces.getTotalSize();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return size;
    }

    public static boolean collectInstanceInformation(TRCAgentProxy agent) {
        TRCConfiguration config;
        EList options;
        if (agent.getName().equals("J2EE Request Profiler")) {
            return true;
        }
        TRCCollectionMode type = agent.getCollectionMode();
        if (type == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || type == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || type == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) {
            return false;
        }
        Iterator configs = agent.getConfigurations().iterator();
        if (configs.hasNext() && (options = (config = (TRCConfiguration)configs.next()).getOptions()) != null) {
            for (TRCOption option : options) {
                if (!option.getKey().equals("TRACE_MODE") || !option.getValue().equals("noObjectCorrelation")) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean collectStatisticInfo(EObject mofObject) {
        if (mofObject != null) {
            int idx;
            if (mofObject instanceof TRCAgentProxy) {
                TRCAgentProxy agent = (TRCAgentProxy)mofObject;
                return agent.getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_FULL_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                idx = 0;
                while (idx < agents.length) {
                    boolean collectStatistic;
                    boolean bl = collectStatistic = ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_FULL_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
                    if (!collectStatistic) {
                        return false;
                    }
                    ++idx;
                }
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        boolean collectStatistic;
                        boolean bl = collectStatistic = ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                        if (!collectStatistic) {
                            return false;
                        }
                        ++i;
                    }
                    ++idx;
                }
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx2 = 0;
                    while (idx2 < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx2]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            boolean collectStatistic;
                            boolean bl = collectStatistic = ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                            if (!collectStatistic) {
                                return false;
                            }
                            ++i;
                        }
                        ++idx2;
                    }
                    ++k;
                }
            }
        }
        return true;
    }

    public static String formatAsPercentage(double d) {
        if (_percentFormat == null) {
            _percentFormat = NumberFormat.getPercentInstance();
            _percentFormat.setMaximumIntegerDigits(3);
            _percentFormat.setMaximumFractionDigits(2);
            _percentFormat.setMinimumFractionDigits(2);
        }
        return _percentFormat.format(d);
    }

    public static String formatTimeValue(double d) {
        return PerftraceUtil.formatTimeValue(d, true);
    }

    public static String formatTimeValueWithoutGrouping(double d) {
        return PerftraceUtil.formatTimeValue(d, false);
    }

    public static String formatTimeValue(double d, boolean groupingUsed) {
        if (_decimalFormat == null) {
            _decimalFormat = NumberFormat.getNumberInstance();
            _decimalFormat.setMaximumFractionDigits(6);
            _decimalFormat.setMinimumFractionDigits(6);
            _decimalFormat.setGroupingUsed(groupingUsed);
        }
        return _decimalFormat.format(d);
    }

    private static void getAgentClasses(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
        Object[] packages = PerftraceUtil.getProcess(agent.getAgent()).getPackages().toArray();
        int idx = 0;
        while (idx < packages.length) {
            list.addAll(((TRCPackage)packages[idx]).getClasses());
            ++idx;
        }
    }

    private static void getAgentGc(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
    }

    private static void getAgentHeapDump(TRCAgentProxy agent, ArrayList list) {
        TRCProcess proces = PerftraceUtil.getProcess(agent.getAgent());
        if (!agent.getType().equals("Profiler") || proces == null) {
            return;
        }
        list.addAll(proces.getHeapDumps());
    }

    private static void getAgentObjReferences(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
    }

    private static void getAgentPackages(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
        list.addAll(PerftraceUtil.getProcess(agent.getAgent()).getPackages());
    }

    private static void getAgentThreads(TRCAgentProxy agent, ArrayList list, boolean withInvocations) {
        TRCProcess proces = PerftraceUtil.getProcess(agent.getAgent());
        if (!agent.getType().equals("Profiler") || proces == null) {
            return;
        }
        Object[] threads = proces.getThreads().toArray();
        int idx = 0;
        while (idx < threads.length) {
            TRCThread thread = (TRCThread)threads[idx];
            if (thread.getInitialInvocations().size() > 0 || !withInvocations) {
                if (thread.getName() == null) {
                    thread.setName(String.valueOf(idx + 1));
                }
                list.add(thread);
            }
            ++idx;
        }
    }

    private static Object[] getObjectArray() {
        Object[] ret = tmpList.toArray();
        tmpList.clear();
        return ret;
    }

    public static double getMaximumCumulativeTime(EObject mofObject) {
        double time;
        block14: {
            block15: {
                TRCProcess proces;
                time = 0.0;
                if (mofObject == null) break block14;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block14;
                time = proces.getCumulativeTime();
                break block14;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    double tmp;
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null && (tmp = proces.getCumulativeTime()) > time) {
                        time = tmp;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        double tmp;
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null && (tmp = proces.getCumulativeTime()) > time) {
                            time = tmp;
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            double tmp;
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (proces = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null && (tmp = proces.getCumulativeTime()) > time) {
                                time = tmp;
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return time;
    }

    public static double getProcessPackageCumulativeTime(TRCProcess process) {
        double time = 0.0;
        Object[] packages = process.getPackages().toArray();
        int pkg = 0;
        while (pkg < packages.length) {
            if (packages[pkg] != null) {
                time += ((TRCPackage)packages[pkg]).getCumulativeTime();
            }
            ++pkg;
        }
        return time;
    }

    public static double getTotalPackagesCumulativeTime(EObject mofObject) {
        double result;
        block16: {
            block15: {
                TRCProcess proces;
                if (mofObject == null) {
                    return 0.0;
                }
                result = 0.0;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block16;
                result = PerftraceUtil.getProcessPackageCumulativeTime(proces);
                break block16;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess process;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        result += PerftraceUtil.getProcessPackageCumulativeTime(process);
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess process;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            result += PerftraceUtil.getProcessPackageCumulativeTime(process);
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess process;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                result += PerftraceUtil.getProcessPackageCumulativeTime(process);
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static double getTotalBaseTime(EObject mofObject) {
        double result;
        block16: {
            block15: {
                TRCProcess proces;
                if (mofObject == null) {
                    return 0.0;
                }
                result = 0.0;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block16;
                result = proces.getBaseTime();
                break block16;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess process;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        result += process.getBaseTime();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess process;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            result += process.getBaseTime();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess process;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                result += process.getBaseTime();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static double getTotalInheritedBaseTime(EObject mofObject) {
        double result;
        block16: {
            block15: {
                TRCProcess proces;
                if (mofObject == null) {
                    return 0.0;
                }
                result = 0.0;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block16;
                result = proces.getInheritedBaseTime();
                break block16;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess process;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        result += process.getInheritedBaseTime();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess process;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            result += process.getInheritedBaseTime();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess process;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                result += process.getInheritedBaseTime();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static double getTotalInheritedCumulativeTime(EObject mofObject) {
        double result;
        block16: {
            block15: {
                TRCProcess proces;
                if (mofObject == null) {
                    return 0.0;
                }
                result = 0.0;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block16;
                result = proces.getInheritedCumulativeTime();
                break block16;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess process;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        result += process.getInheritedCumulativeTime();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess process;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            result += process.getInheritedCumulativeTime();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess process;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                result += process.getInheritedCumulativeTime();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static double getTotalCumulativeTime(EObject mofObject) {
        double result;
        block16: {
            block15: {
                TRCProcess proces;
                if (mofObject == null) {
                    return 0.0;
                }
                result = 0.0;
                if (!(mofObject instanceof TRCAgentProxy)) break block15;
                if (((TRCAgentProxy)mofObject).getAgent() == null || (proces = PerftraceUtil.getProcess(((TRCAgentProxy)mofObject).getAgent())) == null) break block16;
                result = proces.getCumulativeTime();
                break block16;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    TRCProcess process;
                    if (((TRCAgentProxy)agents[idx]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[idx]).getAgent())) != null) {
                        result += process.getCumulativeTime();
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        TRCProcess process;
                        if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                            result += process.getCumulativeTime();
                        }
                        ++i;
                    }
                    ++idx;
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            TRCProcess process;
                            if (((TRCAgentProxy)agents[i]).getAgent() != null && (process = PerftraceUtil.getProcess(((TRCAgentProxy)agents[i]).getAgent())) != null) {
                                result += process.getCumulativeTime();
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static boolean hasMethodInvocationInfo(EObject object) {
        TRCAgentProxy agentProxy = PerftraceUtil.getAgentProxy(object);
        if (agentProxy == null) {
            return false;
        }
        TRCCollectionMode mode = agentProxy.getCollectionMode();
        return mode == TRCCollectionMode.EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL || mode == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL || PerftraceUtil.hasOptionSet(agentProxy, "CPU_TIME", Boolean.TRUE) && (mode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
    }

    public static boolean hasFullMethodInvocationInfo(EObject object) {
        TRCAgentProxy agentProxy = PerftraceUtil.getAgentProxy(object);
        if (agentProxy == null) {
            return false;
        }
        TRCCollectionMode mode = agentProxy.getCollectionMode();
        return mode == TRCCollectionMode.EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL || mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
    }

    public static boolean hasExecutionInfo(EObject object) {
        TRCAgentProxy agentProxy = PerftraceUtil.getAgentProxy(object);
        if (agentProxy == null) {
            return false;
        }
        TRCCollectionMode mode = agentProxy.getCollectionMode();
        return mode == TRCCollectionMode.EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL || mode == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
    }

    public static boolean hasHeapInfo(EObject object) {
        TRCAgentProxy agentProxy = PerftraceUtil.getAgentProxy(object);
        if (agentProxy == null) {
            return false;
        }
        TRCCollectionMode mode = agentProxy.getCollectionMode();
        return mode == TRCCollectionMode.HEAP_FULL_LITERAL || mode == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
    }

    private static boolean hasOptionSet(TRCAgentProxy agentProxy, String optionName, Object value) {
        EList configurations = agentProxy.getConfigurations();
        if (configurations == null) {
            return false;
        }
        for (TRCConfiguration config : configurations) {
            EList options = config.getOptions();
            for (TRCOption option : options) {
                if (!optionName.equals(option.getKey())) continue;
                return value.toString().equals(option.getValue().toString());
            }
        }
        return false;
    }

    private static TRCAgentProxy getAgentProxy(EObject object) {
        if (object instanceof TRCAgentProxy) {
            return (TRCAgentProxy)object;
        }
        if (object instanceof TRCProcessProxy) {
            return PerftraceUtil.getAgentProxy((TRCProcessProxy)object);
        }
        if (object instanceof TRCNode) {
            return PerftraceUtil.getAgentProxy((TRCNode)object);
        }
        if (object instanceof TRCMonitor) {
            return PerftraceUtil.getAgentProxy((TRCMonitor)object);
        }
        return null;
    }

    private static TRCAgentProxy getAgentProxy(TRCMonitor monitor) {
        Object[] nodes = monitor.getNodes().toArray();
        int i = 0;
        while (i < nodes.length) {
            TRCAgentProxy agentProxy = PerftraceUtil.getAgentProxy((TRCNode)nodes[i]);
            if (agentProxy != null) {
                return agentProxy;
            }
            ++i;
        }
        return null;
    }

    private static TRCAgentProxy getAgentProxy(TRCNode node) {
        Object[] processes = node.getProcessProxies().toArray();
        int i = 0;
        while (i < processes.length) {
            TRCAgentProxy agentProxy = PerftraceUtil.getAgentProxy((TRCProcessProxy)processes[i]);
            if (agentProxy != null) {
                return agentProxy;
            }
            ++i;
        }
        return null;
    }

    private static TRCAgentProxy getAgentProxy(TRCProcessProxy processProxy) {
        Object[] agents = processProxy.getAgentProxies().toArray();
        int i = 0;
        while (i < agents.length) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)agents[i];
            if (agentProxy.getAgent() != null) {
                return agentProxy;
            }
            ++i;
        }
        return null;
    }
}

