/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.trace.ui.internal.util.IOProxy;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;

public class ProcessAdapter
implements org.eclipse.debug.core.model.IProcess {
    private Map _attributes = new HashMap();
    private boolean _isAlive = false;
    private String _label;
    private Process _process;
    private IOProxy _proxy;
    private ILaunch _launch;
    protected int launchMode = 1;
    private IProcess _newProcess;

    public ProcessAdapter(Process process, ILaunch launch, boolean isAlive, int pLaunchMode) {
        this(process, launch, isAlive);
        this.launchMode = pLaunchMode;
    }

    public ProcessAdapter(Process process, ILaunch launch) {
        this(launch, process);
    }

    public ProcessAdapter(ILaunch launch, Object process) {
        DateFormat format = DateFormat.getDateTimeInstance((int)1, (int)2, (ULocale)ULocale.getDefault());
        if (process instanceof Process) {
            this._process = (Process)process;
            this._process.addProcessListener(new ProcessListener(){

                public void processLaunched(Process p) {
                    ProcessAdapter.this._isAlive = true;
                }

                public void processExited(Process p) {
                    ProcessAdapter.this._isAlive = false;
                }
            });
            this._label = String.valueOf(this._process.getExecutable()) + " (" + format.format(new Date(System.currentTimeMillis())) + ")";
        } else if (process instanceof IProcess) {
            this._newProcess = (IProcess)process;
            this._newProcess.addProcessListener(new IProcessListener(){

                public void processLaunched(IProcess arg0) {
                    ProcessAdapter.this._isAlive = true;
                }

                public void processExited(IProcess arg0) {
                    ProcessAdapter.this._isAlive = false;
                }
            });
            this._label = String.valueOf(this._newProcess.getExecutable()) + " (" + format.format(new Date(System.currentTimeMillis())) + ")";
        }
        this._launch = launch;
    }

    public ProcessAdapter(Process process, ILaunch launch, boolean isAlive) {
        this(process, launch);
        this._isAlive = isAlive;
    }

    public ProcessAdapter(Object process, ILaunch launch, boolean isAlive, int pLaunchMode) {
        this(launch, process);
        this._isAlive = isAlive;
        this.launchMode = pLaunchMode;
    }

    public Object getAdapter(Class adapter) {
        if (DataProcessor.class.equals((Object)adapter)) {
            return this._proxy;
        }
        return null;
    }

    public String getAttribute(String key) {
        return (String)this._attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this._attributes.put(key, value);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public String getLabel() {
        return this._label;
    }

    public ILaunch getLaunch() {
        return this._launch;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this._proxy == null) {
            this._proxy = new IOProxy(this._process == null ? this._newProcess : this._process);
        }
        return this._proxy;
    }

    public boolean canTerminate() {
        return this._isAlive && this.getLaunchMode() != 0;
    }

    public boolean isTerminated() {
        return !this._isAlive;
    }

    public void terminate() throws DebugException {
        if (this.canTerminate()) {
            try {
                if (this._process != null) {
                    this._process.kill(0L);
                } else if (this._newProcess != null) {
                    this._newProcess.kill();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._isAlive = false;
        }
    }

    public int getLaunchMode() {
        return this.launchMode;
    }

    public void setLaunchMode(int launchMode) {
        this.launchMode = launchMode;
    }
}

