/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingListContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingTypeElement;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.TableViewer;

public class ProfilingList
implements IBasicPropertyConstants {
    ArrayList types = new ArrayList();
    TableViewer fViewer;
    protected List listeners;

    public ProfilingList(TableViewer viewer) {
        this.fViewer = viewer;
    }

    public void add(ProfilingTypeElement element) {
        this.add(element, -1);
    }

    public void add(ProfilingTypeElement element, int index) {
        if (index < 0) {
            this.types.add(element);
        } else {
            this.types.add(index, element);
        }
    }

    public void addElementChangedListener(ProfilingListContentProvider newListener) {
        if (newListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public Object[] elements() {
        return this.types.toArray();
    }

    public void fireElementChanged(ProfilingTypeElement changedElement, String changedProperty) {
        if (this.listeners != null) {
            for (ProfilingListContentProvider l : this.listeners) {
                l.elementChanged(changedElement, changedProperty);
            }
        }
    }

    public Object getElementAt(int index) {
        return this.types.get(index);
    }

    public ArrayList getFilters() {
        return (ArrayList)this.types.clone();
    }

    public int getSize() {
        return this.types.size();
    }

    public void removeAll() {
        this.types.clear();
    }

    public void removeElements(int[] idx) {
        if (idx == null) {
            return;
        }
        Vector removeList = new Vector();
        int i = 0;
        while (i < idx.length) {
            if (idx[i] != -1) {
                Object element = this.types.get(idx[i]);
                removeList.add(element);
            }
            ++i;
        }
        this.types.removeAll(removeList);
    }

    public Object removeElementAt(int idx) {
        Object element = this.types.get(idx);
        if (element == null) {
            return null;
        }
        this.types.remove(element);
        return element;
    }

    public void removeElementChangedListener(ProfilingListContentProvider listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public Object[] uiElements() {
        return this.types.toArray();
    }
}

