/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TreeLabelProvider
extends LabelProvider {
    private Hashtable iconList = new Hashtable();

    public TreeLabelProvider(ImageDescriptor[] descList) {
        int i = 0;
        while (i < descList.length) {
            if (descList[i] != null && !this.iconList.containsKey(descList[i])) {
                this.iconList.put(descList[i], descList[i].createImage());
            }
            ++i;
        }
    }

    public String getText(Object element) {
        if (element instanceof IProfilingSetType) {
            return ((IProfilingSetType)element).getName();
        }
        if (element instanceof IProfilingSetTypeGroup) {
            return ((IProfilingSetTypeGroup)element).getName();
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        ImageDescriptor imageDesc = null;
        if (element instanceof IProfilingSetType) {
            imageDesc = ((IProfilingSetType)element).getImage();
        } else if (element instanceof IProfilingSetTypeGroup) {
            imageDesc = ((IProfilingSetTypeGroup)element).getIcon();
        }
        if (imageDesc == null) {
            return null;
        }
        return (Image)this.iconList.get(imageDesc);
    }

    public void dispose() {
        Iterator list = this.iconList.keySet().iterator();
        while (list.hasNext()) {
            ((Image)this.iconList.get(list.next())).dispose();
        }
        this.iconList.clear();
        this.iconList = null;
    }
}

