/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewMonitorWizardPage
extends WizardPage
implements ModifyListener {
    protected IResource fSelection;
    protected TraceLocationUI _locationUI;
    private TRCMonitor fMonitor;

    public NewMonitorWizardPage(String name, IResource selection) {
        super(name);
        this.setTitle(TraceMessages.CR_MT);
        this.setDescription(TraceMessages.CR_MTD);
        this.fSelection = selection;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        content.setLayoutData((Object)gd);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(content);
        this._locationUI.setEnabledBrowse(false);
        this._locationUI.setEnabledLocation(false);
        Composite group = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)GridUtil.createFill());
        this._locationUI.getLocation().addModifyListener((ModifyListener)this);
        this._locationUI.getMonitor().addModifyListener((ModifyListener)this);
        this._locationUI.getMonitor().setFocus();
        this.setControl((Control)content);
        this._locationUI.setMonitor("");
        if (this.fSelection != null) {
            this._locationUI.setLocation(this.fSelection.getFullPath().toOSString());
        }
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".nmwp0000");
    }

    public boolean finish() {
        String name = this._locationUI.getMonitor().getText().trim();
        String location = this._locationUI.getLocation().getText().trim();
        IContainer container = PDCoreUtil.createContainer((IPath)new Path(location));
        PDCoreUtil.createMonitor((IContainer)container, (String)name);
        return true;
    }

    public TRCMonitor getMonitor() {
        return this.fMonitor;
    }

    public void modifyText(ModifyEvent event) {
        String containerName = this._locationUI.getLocation().getText().trim();
        String fileName = this._locationUI.getMonitor().getText().trim();
        if (containerName.equals("") || containerName.equals("")) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (event.widget == this._locationUI.getMonitor()) {
            this.setErrorMessage(null);
            IWorkspace workbench = UIPlugin.getPluginWorkbench();
            Path path = new Path(containerName);
            IContainer container = null;
            IResource res = workbench.getRoot().findMember((IPath)path);
            if (res == null || !res.exists()) {
                this.setPageComplete(true);
                return;
            }
            if (!(res instanceof IContainer)) {
                this.setErrorMessage(NLS.bind((String)TraceMessages.CT_INV, (Object)containerName));
                this.setPageComplete(false);
                return;
            }
            container = (IContainer)res;
            if ((res = container.findMember(String.valueOf(fileName) + File.separator + "trcmxmi")) != null) {
                this.setErrorMessage(NLS.bind((String)TraceMessages.F_ALD_EX, (Object[])new Object[]{containerName, File.separator, fileName, "trcmxmi"}));
                this.setPageComplete(false);
                return;
            }
            ArrayList monitors = PDContentProvider.getMonitors((IContainer)container);
            int idx = 0;
            while (idx < monitors.size()) {
                TRCMonitor monitor = (TRCMonitor)monitors.get(idx);
                if (monitor != null && monitor.getName().equals(fileName)) {
                    this.setErrorMessage(NLS.bind((String)TraceMessages.F_ALD_EX, (Object[])new Object[]{containerName, File.separator, fileName, "trcmxmi"}));
                    this.setPageComplete(false);
                    return;
                }
                ++idx;
            }
            this.setPageComplete(true);
        }
    }
}

