/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class OpenProfAgentOptionsPage
extends WizardPage {
    private static final int MARGIN_SIZE = 20;

    public OpenProfAgentOptionsPage(String name) {
        super(name);
        this.setTitle(TraceMessages.OPTIONS_P);
        this.setDescription(TraceMessages.OPTIONS_D);
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        layout.numColumns = 1;
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 200;
        contents.setLayoutData((Object)data);
        Table table = new Table(contents, 67584);
        table.setLayoutData((Object)data);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn propertyColumn = new TableColumn(table, 0);
        propertyColumn.setText(TraceMessages.OPTIONS_TP);
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setText(TraceMessages.OPTIONS_V);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)tableLayout);
        ArrayList<TRCOption> list = new ArrayList<TRCOption>();
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        for (TRCConfiguration conf : agent.getConfigurations()) {
            for (TRCOption option : conf.getOptions()) {
                list.add(option);
            }
        }
        TRCOption[] options = new TRCOption[list.size()];
        list.toArray(options);
        Arrays.sort(options, new Comparator(){

            public int compare(Object a, Object b) {
                return ((TRCOption)a).getKey().compareTo(((TRCOption)b).getKey());
            }
        });
        TableItem collectionMode = new TableItem(table, 0);
        collectionMode.setText(0, TraceMessages.AGCOL_M);
        collectionMode.setText(1, agent.getCollectionMode().getName());
        int j = 0;
        while (j < options.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, options[j].getKey());
            item.setText(1, options[j].getValue());
            ++j;
        }
        this.setControl((Control)contents);
    }

    public boolean finish() {
        return true;
    }
}

