/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.NavigatorWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentFolderPage;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentOptionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class OpenProfAgentWizard
extends NavigatorWizard {
    protected TRCAgentProxy fAgent;
    protected OpenProfAgentPage fFilterPage;
    protected OpenProfAgentFolderPage fFolderPage;
    protected OpenProfAgentOptionsPage fPropertyPage;
    private boolean debug = UIPlugin.getDefault().getPreferenceStore().getBoolean("debug");

    public void addPages() {
        this.setWindowTitle(TraceMessages.PROP);
        this.fFolderPage = new OpenProfAgentFolderPage("folderPage", this.getViewer());
        this.fFilterPage = new OpenProfAgentPage("agentPage", this.getViewer());
        if (this.debug) {
            this.fPropertyPage = new OpenProfAgentOptionsPage("propertiesPage");
        }
        this.addPage((IWizardPage)this.fFolderPage);
        this.addPage((IWizardPage)this.fFilterPage);
        if (this.debug) {
            this.addPage((IWizardPage)this.fPropertyPage);
        }
    }

    public TRCAgentProxy getAgent() {
        return this.fAgent;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object obj;
        Iterator enum1;
        if (selection instanceof IStructuredSelection && (enum1 = selection.iterator()).hasNext() && (obj = enum1.next()) instanceof TRCAgentProxy) {
            this.fAgent = (TRCAgentProxy)obj;
        }
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor("agent_prop_wiz.gif"));
    }

    public boolean performFinish() {
        if (!(this.fFolderPage.getFile().equals("") || PDCoreUtil.isPathExists((String)this.fFolderPage.getFile()) || PDCoreUtil.createDirectoryMessage((String)this.fFolderPage.getFile(), (Shell)this.getShell()))) {
            return false;
        }
        this.fFilterPage.finish();
        this.fFolderPage.finish();
        if (this.debug) {
            this.fPropertyPage.finish();
        }
        return true;
    }

    public boolean isProfilingAgent() {
        if (this.fAgent != null) {
            return this.fAgent.getType().equals("Profiler") && !this.fAgent.getName().equals("J2EE Request Profiler");
        }
        return true;
    }
}

