/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.control.provider;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlProvider;

public class ControlProviderLoader {
    private IControlProvider controlProvider;
    private String type;

    private ControlProviderLoader(String type, IControlProvider controlProvider) {
        this.type = type;
        this.controlProvider = controlProvider;
    }

    public static ControlProviderLoader constructInstance(IConfigurationElement element) {
        String type = element.getAttribute("type");
        if (type == null) {
            return null;
        }
        IControlProvider controlProvider = null;
        try {
            controlProvider = (IControlProvider)element.createExecutableExtension("class");
            controlProvider.initialize(type);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return new ControlProviderLoader(type, controlProvider);
    }

    public String getType() {
        return this.type;
    }

    public IControlProvider getControlProvider() {
        return this.controlProvider;
    }
}

