/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.control.provider;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.internal.control.provider.ControlProviderLoader;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlProvider;

public class ControlProviderManager {
    public static final String ALL = "ALL";
    public static final String PROCESS_ENTITY = "process";
    public static final String AGENT_ENTITY = "agent";
    public static final String ANALYSIS_ENTITY = "analysis";
    public static final String TOOLBAR_ENTITY = "toolbar";
    public static final String INSERTED_ORDER = "ORDER";
    private static final String DEFAULT_AGENT_DECLARATION_ID = "org.eclipse.tptp.trace.ui.jvmpiAgent";
    public static final ArrayList SUPPORTED_ENTITIES = new ArrayList();
    private static ControlProviderManager instance;
    private Hashtable controllableEntities = new Hashtable();

    static {
        SUPPORTED_ENTITIES.add(PROCESS_ENTITY);
        SUPPORTED_ENTITIES.add(AGENT_ENTITY);
        SUPPORTED_ENTITIES.add(ANALYSIS_ENTITY);
        SUPPORTED_ENTITIES.add(TOOLBAR_ENTITY);
    }

    private ControlProviderManager() {
        this.initialize();
    }

    public static ControlProviderManager getInstance() {
        if (instance == null) {
            instance = new ControlProviderManager();
        }
        return instance;
    }

    private void initialize() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.trace.ui.controllableEntity");
        int i = 0;
        while (i < elements.length) {
            String agentDeclarationId;
            if ("control".equalsIgnoreCase(elements[i].getName()) && (agentDeclarationId = elements[i].getAttribute("associatedAgentId")) != null) {
                IConfigurationElement[] entities = elements[i].getChildren("entity");
                int j = 0;
                while (j < entities.length) {
                    ControlProviderLoader controllableEntity = ControlProviderLoader.constructInstance(entities[j]);
                    if (controllableEntity != null) {
                        Hashtable entitiesHash = (Hashtable)LauncherUtility.getHashtableEntry(this.controllableEntities, agentDeclarationId, Hashtable.class, true);
                        if (SUPPORTED_ENTITIES.contains(controllableEntity.getType())) {
                            Hashtable inputIdHash = (Hashtable)LauncherUtility.getHashtableEntry(entitiesHash, controllableEntity.getType(), Hashtable.class, true);
                            String inputId = entities[j].getAttribute("inputId");
                            if (inputId == null) {
                                inputId = ALL;
                            }
                            ArrayList controlProviders = (ArrayList)LauncherUtility.getHashtableEntry(inputIdHash, inputId, ArrayList.class, true);
                            controlProviders.add(controllableEntity);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public Hashtable getDefaultControlItemSet(String entity, StructuredSelection input) {
        return this.getControlItemSet(DEFAULT_AGENT_DECLARATION_ID, entity, input);
    }

    public Hashtable getControlItemSet(String agentDeclarationId, String entity, StructuredSelection input, String inputId) {
        Hashtable controlOptions = (Hashtable)this.controllableEntities.get(agentDeclarationId);
        Hashtable<String, Object> controlItemsSet = new Hashtable<String, Object>();
        ArrayList<String> orderQueue = new ArrayList<String>();
        controlItemsSet.put(INSERTED_ORDER, orderQueue);
        if (controlOptions == null) {
            return controlItemsSet;
        }
        Hashtable inputIdHash = (Hashtable)controlOptions.get(entity);
        if (inputIdHash == null) {
            return controlItemsSet;
        }
        ArrayList controlProviders = (ArrayList)inputIdHash.get(inputId);
        if (!inputId.equals(ALL)) {
            ArrayList allControlProviders;
            if (controlProviders == null) {
                controlProviders = new ArrayList();
            }
            if ((allControlProviders = (ArrayList)inputIdHash.get(ALL)) != null) {
                controlProviders.addAll(allControlProviders);
            }
        }
        if (controlProviders == null) {
            return controlItemsSet;
        }
        int i = 0;
        int controlProviderSize = controlProviders.size();
        while (i < controlProviderSize) {
            ControlProviderLoader currentControlProvider = (ControlProviderLoader)controlProviders.get(i);
            IControlProvider controlProvider = currentControlProvider.getControlProvider();
            controlProvider.setInput(input);
            IControlItem[] controlItems = controlProvider.createControlItems();
            int j = 0;
            while (j < controlItems.length) {
                String key = controlItems[j].getText();
                if (key == null) {
                    key = String.valueOf(orderQueue.size());
                }
                if (controlItemsSet.get(key) == null) {
                    controlItemsSet.put(key, controlItems[j]);
                    orderQueue.add(key);
                }
                ++j;
            }
            ++i;
        }
        return controlItemsSet;
    }

    public Hashtable getControlItemSet(String agentDeclarationId, String entity, StructuredSelection input) {
        return this.getControlItemSet(agentDeclarationId, entity, input, ALL);
    }
}

