/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.control.provider;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.ui.internal.control.provider.ControlProviderManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AgentDeclarationManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;

public class TraceControlItemManager {
    private static final byte CONTEXT_MENU = 0;
    private static final byte TOOLBAR = 1;
    private static INavigator navigator;
    private Tree profilingMonitorTree;

    public TraceControlItemManager(INavigator navigator) {
        TraceControlItemManager.navigator = navigator;
    }

    private IControlItem[] getContributedItems(byte containerType) {
        if (this.profilingMonitorTree == null) {
            this.profilingMonitorTree = ((PDProjectViewer)navigator.getViewer()).getTree();
        }
        TreeItem[] treeItemSelection = this.profilingMonitorTree.getSelection();
        Hashtable controlSubset = new Hashtable();
        int i = 0;
        while (i < treeItemSelection.length) {
            Hashtable currentSet = null;
            currentSet = this.getControlItemSet(containerType, treeItemSelection[i]);
            controlSubset = i == 0 ? currentSet : this.findMutualSubset(controlSubset, currentSet);
            ++i;
        }
        ArrayList orderedList = (ArrayList)controlSubset.get("ORDER");
        IControlItem[] controlItems = new IControlItem[]{};
        if (orderedList != null) {
            controlItems = new IControlItem[orderedList.size()];
            int i2 = 0;
            while (i2 < controlItems.length) {
                controlItems[i2] = (IControlItem)controlSubset.get(orderedList.get(i2));
                ++i2;
            }
        }
        return controlItems;
    }

    public IControlItem[] getContextMenuItems() {
        return this.getContributedItems((byte)0);
    }

    public IControlItem[] getToolbarItems() {
        return this.getContributedItems((byte)1);
    }

    private Hashtable findMutualSubset(Hashtable firstSet, Hashtable secondSet) {
        Hashtable<String, ArrayList<Object>> mutualSet = new Hashtable<String, ArrayList<Object>>();
        ArrayList orderQueue = new ArrayList();
        mutualSet.put("ORDER", orderQueue);
        if (firstSet == null || secondSet == null) {
            return mutualSet;
        }
        ArrayList orderedKeys = (ArrayList)firstSet.get("ORDER");
        if (orderedKeys != null) {
            int i = 0;
            int setSize = orderedKeys.size();
            while (i < setSize) {
                Object currentKey = orderedKeys.get(i);
                Object currentValue = secondSet.get(currentKey);
                if (currentValue != null && currentValue.equals(firstSet.get(currentKey))) {
                    mutualSet.put((String)currentKey, (ArrayList<Object>)currentValue);
                    orderQueue.add(currentKey);
                }
                ++i;
            }
        }
        return mutualSet;
    }

    private Hashtable getControlItemSet(byte containerType, TreeItem treeItem) {
        ProfileDetailItem navigatorItem;
        TRCAgentProxy agentProxy;
        String entityType;
        Object data = treeItem.getData();
        Hashtable controlItemsSet = new Hashtable();
        if (data instanceof TRCProcessProxy) {
            entityType = containerType == 0 ? "process" : "toolbar";
            EList agentList = ((TRCProcessProxy)data).getAgentProxies();
            int agentListCount = agentList.size();
            if (agentListCount <= 0) {
                return ControlProviderManager.getInstance().getDefaultControlItemSet(entityType, new StructuredSelection(data));
            }
            int i = 0;
            while (i < agentListCount) {
                agentProxy = (TRCAgentProxy)agentList.get(i);
                controlItemsSet = i == 0 ? this.getAgentControlItems(entityType, agentProxy, this.createInput(entityType, agentProxy)) : this.findMutualSubset(controlItemsSet, this.getAgentControlItems(entityType, agentProxy, this.createInput(entityType, agentProxy)));
                ++i;
            }
        }
        if (data instanceof TRCAgentProxy) {
            entityType = containerType == 0 ? "agent" : "toolbar";
            agentProxy = (TRCAgentProxy)data;
            controlItemsSet = this.getAgentControlItems(entityType, agentProxy, this.createInput(entityType, agentProxy));
        } else if (data instanceof ProfileDetailItem && (navigatorItem = (ProfileDetailItem)data).isAnalysisType()) {
            entityType = containerType == 0 ? "analysis" : "toolbar";
            agentProxy = (TRCAgentProxy)treeItem.getParentItem().getData();
            controlItemsSet = this.getAgentControlItems(entityType, agentProxy, this.createInput(entityType, agentProxy), navigatorItem.getAnalysisType().getId());
        }
        return controlItemsSet;
    }

    private StructuredSelection createInput(String entity, TRCAgentProxy agentProxy) {
        int i;
        TreeItem[] treeItemSelection = this.profilingMonitorTree.getSelection();
        ArrayList inputList = new ArrayList();
        String agentName = agentProxy.getName();
        String agentType = agentProxy.getType();
        if (entity.equals("process")) {
            i = 0;
            while (i < treeItemSelection.length) {
                Object data = treeItemSelection[i].getData();
                if (data instanceof TRCProcessProxy) {
                    this.addProcess((TRCProcessProxy)data, inputList, agentName, agentType);
                }
                ++i;
            }
        } else if (entity.equals("agent")) {
            i = 0;
            while (i < treeItemSelection.length) {
                Object data = treeItemSelection[i].getData();
                if (data instanceof TRCAgentProxy) {
                    this.addAgent(inputList, agentName, agentType, (TRCAgentProxy)data, data);
                }
                ++i;
            }
        } else if (entity.equals("analysis")) {
            i = 0;
            while (i < treeItemSelection.length) {
                Object data = treeItemSelection[i].getData();
                if (data instanceof INavigatorItem && ((INavigatorItem)data).getData() instanceof AnalysisType) {
                    this.addAgent(inputList, agentName, agentType, (TRCAgentProxy)treeItemSelection[i].getParentItem().getData(), data);
                }
                ++i;
            }
        } else if (entity.equals("toolbar")) {
            i = 0;
            while (i < treeItemSelection.length) {
                ProfileDetailItem profileDetailItem;
                Object data = treeItemSelection[i].getData();
                if (data instanceof TRCProcessProxy) {
                    this.addProcess((TRCProcessProxy)data, inputList, agentName, agentType);
                } else if (data instanceof TRCAgentProxy) {
                    this.addAgent(inputList, agentName, agentType, (TRCAgentProxy)data, data);
                } else if (data instanceof ProfileDetailItem && (profileDetailItem = (ProfileDetailItem)data).isAnalysisType()) {
                    TRCAgentProxy associatedAgentProxy = (TRCAgentProxy)treeItemSelection[i].getParentItem().getData();
                    this.addAgent(inputList, agentName, agentType, associatedAgentProxy, associatedAgentProxy);
                }
                ++i;
            }
        }
        Object[] elements = new Object[inputList.size()];
        inputList.toArray(elements);
        return new StructuredSelection(elements);
    }

    private void addProcess(TRCProcessProxy processProxy, ArrayList inputList, String agentName, String agentType) {
        EList agentProxies = processProxy.getAgentProxies();
        int j = 0;
        int agentCount = agentProxies.size();
        while (j < agentCount) {
            if (this.addAgent(inputList, agentName, agentType, (TRCAgentProxy)agentProxies.get(j), processProxy)) break;
            ++j;
        }
    }

    private boolean addAgent(ArrayList inputList, String targetAgentName, String targetAgentType, TRCAgentProxy agent, Object data) {
        if (agent.getName().equals(targetAgentName) && agent.getType().equals(targetAgentType)) {
            inputList.add(data);
            return true;
        }
        return false;
    }

    private Hashtable getAgentControlItems(String entityType, TRCAgentProxy agentProxy, StructuredSelection input, String inputId) {
        Hashtable controlItemSet = new Hashtable();
        if (agentProxy == null) {
            return controlItemSet;
        }
        String agentName = agentProxy.getName();
        String agentType = agentProxy.getType();
        String agentDeclarationId = AgentDeclarationManager.getInstance().getAgentDeclarationId(agentName, agentType);
        controlItemSet = agentDeclarationId == null ? ControlProviderManager.getInstance().getDefaultControlItemSet(entityType, input) : ControlProviderManager.getInstance().getControlItemSet(agentDeclarationId, entityType, input, inputId);
        return controlItemSet;
    }

    private Hashtable getAgentControlItems(String entityType, TRCAgentProxy agentProxy, StructuredSelection input) {
        return this.getAgentControlItems(entityType, agentProxy, input, "ALL");
    }

    public static INavigator getNavigator() {
        return navigator;
    }
}

