/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.control.provider.application;

import java.util.Iterator;
import org.eclipse.hyades.trace.ui.internal.actions.CollectObjRefAction;
import org.eclipse.hyades.trace.ui.internal.actions.NewSnapshotAction;
import org.eclipse.hyades.trace.ui.internal.actions.RunGCAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.StandardAgentStateModifier;

public class PIAgentControlProvider
extends AbstractAgentControlProvider {
    private static final String RESET_ITEM = "org.eclipse.hyades.trace.ui.internal.popupMenu.NewSnapshot";
    private static final String HEAP_DUMP_ITEM = "org.eclipse.hyades.trace.ui.monitorsview.popupMenu.ObjRef";
    private static final String GC_ITEM = "org.eclipse.hyades.trace.ui.monitorsview.popupMenu.GC";
    private IAgentStateModifier agentStateModifier = new StandardAgentStateModifier();
    private IControlItem dumpHeapControlItem;
    private IControlItem garbageCollectionControlItem;
    private IControlItem restartControlItem;

    protected void initializeControlItems() {
        super.initializeControlItems();
        this.addControlItem(this.createResetControlItem());
        this.addControlItem(this.createHeapDumpControlItem());
        this.addControlItem(this.createGCControlItem());
    }

    public IAgentStateModifier getAgentStateModifier() {
        return this.agentStateModifier;
    }

    protected IControlItem createHeapDumpControlItem() {
        if (this.dumpHeapControlItem != null) {
            return this.dumpHeapControlItem;
        }
        this.dumpHeapControlItem = new HeapDumpControlItem();
        return this.dumpHeapControlItem;
    }

    protected IControlItem createGCControlItem() {
        if (this.garbageCollectionControlItem != null) {
            return this.garbageCollectionControlItem;
        }
        this.garbageCollectionControlItem = new GCControlItem();
        return this.garbageCollectionControlItem;
    }

    protected IControlItem createResetControlItem() {
        if (this.restartControlItem != null) {
            return this.restartControlItem;
        }
        class ResetControlItem
        extends ControlItem {
            private NewSnapshotAction resetAction;

            public ResetControlItem() {
                super(PIAgentControlProvider.RESET_ITEM, "newSnapshotGroup", ControlMessages.CONTROL_ITEM_NEW_SNAPSHOT, null);
                this.resetAction = new NewSnapshotAction();
            }

            public void run() {
                try {
                    Iterator agents = this.input.iterator();
                    while (agents.hasNext()) {
                        this.resetAction.doAction(agents.next());
                    }
                }
                catch (Exception e) {
                    LauncherUtility.openMessageWithDetail(4, "", e.getMessage(), e);
                }
            }

            public boolean isEnabled() {
                boolean isEnable = true;
                Iterator agents = this.input.iterator();
                while (isEnable && agents.hasNext()) {
                    boolean bl = isEnable = isEnable && this.resetAction.isEnabledFor(agents.next());
                }
                return isEnable;
            }
        }
        this.restartControlItem = new ResetControlItem();
        return this.restartControlItem;
    }

    public static class GCControlItem
    extends ControlItem {
        private RunGCAction gcAction;

        public GCControlItem() {
            super(PIAgentControlProvider.GC_ITEM, "gcGroup", ControlMessages.CONTROL_ITEM_GC_ACTION, TraceUIImages.INSTANCE.getImageDescriptor("c", "rungc_co.gif"));
            this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "rungc_co.gif"));
            this.gcAction = new RunGCAction();
        }

        public void run() {
            try {
                Iterator agents = this.input.iterator();
                while (agents.hasNext()) {
                    this.gcAction.doAction(agents.next());
                }
            }
            catch (Exception e) {
                LauncherUtility.openMessageWithDetail(4, "", e.getMessage(), e);
            }
        }

        public boolean isEnabled() {
            if (this.input == null || this.input.size() == 0) {
                return false;
            }
            boolean isEnable = true;
            Iterator agents = this.input.iterator();
            while (isEnable && agents.hasNext()) {
                boolean bl = isEnable = isEnable && this.gcAction.isEnabledFor(agents.next());
            }
            return isEnable;
        }
    }

    public static class HeapDumpControlItem
    extends ControlItem {
        CollectObjRefAction collectObjRef;

        public HeapDumpControlItem() {
            super(PIAgentControlProvider.HEAP_DUMP_ITEM, "gcGroup", ControlMessages.CONTROL_ITEM_DUMP, TraceUIImages.INSTANCE.getImageDescriptor("c", "heap_start_co.gif"));
            this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "heap_start_co.gif"));
            this.collectObjRef = new CollectObjRefAction();
        }

        public void run() {
            try {
                Iterator agents = this.input.iterator();
                while (agents.hasNext()) {
                    this.collectObjRef.doAction(agents.next());
                }
            }
            catch (Exception e) {
                LauncherUtility.openMessageWithDetail(4, "", e.getMessage(), e);
            }
        }

        public boolean isEnabled() {
            if (this.input == null || this.input.size() == 0) {
                return false;
            }
            boolean isEnable = true;
            Iterator agents = this.input.iterator();
            while (isEnable && agents.hasNext()) {
                boolean bl = isEnable = isEnable && this.collectObjRef.isEnabledFor(agents.next());
            }
            return isEnable;
        }
    }
}

