/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Map;
import java.util.Vector;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage;

public abstract class AbstractConfiguration
implements IConfiguration {
    private Class[] configurationPages;
    private IExtendedConfigurationPage[] confPageContainer;

    public AbstractConfiguration(Class[] confPages) {
        this.configurationPages = confPages;
    }

    public void initialize() {
        Vector confPageVec = new Vector();
        int i = 0;
        while (i < this.configurationPages.length) {
            Object confPage = null;
            try {
                confPage = this.configurationPages[i].newInstance();
            }
            catch (Exception exception) {
                confPage = null;
            }
            if (confPage != null && confPage instanceof IExtendedConfigurationPage) {
                confPageVec.add(confPage);
            }
            ++i;
        }
        this.confPageContainer = new IExtendedConfigurationPage[confPageVec.size()];
        confPageVec.toArray(this.confPageContainer);
    }

    public IConfigurationPage[] getConfigurationPages() {
        return this.confPageContainer;
    }

    public DataCollectionEngineAttribute[] getAttributes() {
        Vector attributeContainer = new Vector();
        int i = 0;
        while (i < this.confPageContainer.length) {
            attributeContainer.addAll(this.confPageContainer[i].getAttributes());
            ++i;
        }
        DataCollectionEngineAttribute[] profilingAtts = new DataCollectionEngineAttribute[attributeContainer.size()];
        attributeContainer.toArray(profilingAtts);
        return profilingAtts;
    }

    public boolean finishConfiguration(ILaunchConfigurationWorkingCopy workingCopy) {
        boolean status = true;
        int i = 0;
        while (i < this.confPageContainer.length) {
            status = status && this.confPageContainer[i].storeAttributes(workingCopy);
            ++i;
        }
        return status;
    }

    public static abstract class ExtendedConfigurationPage
    implements IExtendedConfigurationPage {
        protected String getOption(Map options, String optionKey, String defaultValue) {
            String optionValue;
            ProfilingAttribute option = (ProfilingAttribute)options.get(optionKey);
            if (option != null && (optionValue = option.getValue()) != null) {
                return optionValue;
            }
            return defaultValue;
        }
    }

    public static interface IExtendedConfigurationPage
    extends IConfigurationPage {
        public boolean storeAttributes(ILaunchConfigurationWorkingCopy var1);

        public Vector getAttributes();
    }
}

