/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;
import org.eclipse.ui.PlatformUI;

public class LimitsConfigurationPage
implements AbstractConfiguration.IExtendedConfigurationPage,
SelectionListener {
    private String attributeName = IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING;
    private ILaunchConfiguration launchconfiguration;
    private Composite _monitoringGroup;
    private Button _autoMonitoring;
    private Label _monitoringDesp;
    private boolean _autoMonitor;

    public LimitsConfigurationPage() {
        this(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING);
    }

    public LimitsConfigurationPage(String attribute) {
        this.attributeName = attribute;
    }

    public String getTitle() {
        return LauncherMessages.CONFIGURATION_LIMIT_TITLE;
    }

    public ImageDescriptor getWizardBanner() {
        return TraceUIImages.INSTANCE.getImageDescriptor("profset_wiz.gif");
    }

    public void createControl(Composite parent) {
        this.addMonitorOption(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._autoMonitoring, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0003");
    }

    private void addMonitorOption(Composite parent) {
        this._monitoringGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        this._monitoringGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this._monitoringGroup.setLayout((Layout)layout);
        this._autoMonitoring = new Button(this._monitoringGroup, 32);
        this._autoMonitoring.setText(UIPlugin.getResourceString(TraceMessages.AMONC));
        this._autoMonitoring.setSelection(this.getLimitsValue());
        this._autoMonitoring.addSelectionListener((SelectionListener)this);
        this._monitoringDesp = new Label(this._monitoringGroup, 0);
        this._monitoringDesp.setText(UIPlugin.getResourceString(TraceMessages.AMONL));
        data = new GridData();
        data.horizontalIndent = 20;
        this._monitoringDesp.setLayoutData((Object)data);
        this._monitoringDesp.setVisible(false);
        this._autoMonitor = this._autoMonitoring.getSelection();
    }

    public boolean storeAttributes(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute(this.attributeName, this._autoMonitoring.getSelection());
        this._autoMonitor = this._autoMonitoring.getSelection();
        return true;
    }

    public Vector getAttributes() {
        Vector<DataCollectionEngineAttribute> options = new Vector<DataCollectionEngineAttribute>();
        options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, String.valueOf(this._autoMonitor)));
        return options;
    }

    public String getPageName() {
        return LauncherMessages.CONFIGURATION_LIMIT_TITLE;
    }

    public String getDescription() {
        return LauncherMessages.CONFIGURATION_LIMIT_DESC;
    }

    public void reset(ILaunchConfiguration config) {
        this.launchconfiguration = config;
    }

    public void addErrorListener(IStatusListener status) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public boolean getLimitsValue() {
        try {
            if (this.launchconfiguration != null) {
                return this.launchconfiguration.getAttribute(this.attributeName, true);
            }
        }
        catch (CoreException e) {
            CommonPlugin.logError((Throwable)e);
        }
        return true;
    }
}

