/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.FilterConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class PIConfiguration
extends AbstractConfiguration {
    public PIConfiguration() {
        this(FilterConfigurationPage.class);
    }

    protected PIConfiguration(Class FilterConfigurationPageClass) {
        super(new Class[]{FilterConfigurationPageClass, LimitsConfigurationPage.class});
    }

    private static class LimitsConfigurationPage
    implements AbstractConfiguration.IExtendedConfigurationPage {
        private TraceProfileCollectionsUI limitsUI = new TraceProfileCollectionsUI();
        private ILaunchConfiguration launchConfiguration;

        public void reset(ILaunchConfiguration launchConfiguration) {
            this.launchConfiguration = launchConfiguration;
        }

        public void createControl(Composite parent) {
            this.limitsUI.createControl(parent);
            if (this.launchConfiguration == null) {
                return;
            }
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            try {
                this.limitsUI.setLimitInvocations(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean("limitInvoc")));
                this.limitsUI.setLimitInvocNb(String.valueOf(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt("invoc_nb"))));
                this.limitsUI.setLimitTime(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean("limitTime")));
                this.limitsUI.setLimitTimeNb(String.valueOf(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt("timeSec"))));
                this.limitsUI.setAutoMonitoring(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean("prof_auto_monitor")));
            }
            catch (Exception e) {
                LauncherUtility.openWarningWithDetail(LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, LauncherMessages.ERROR_CONFIG_RESTORE, e);
                this.limitsUI.setDefaultOptions();
            }
        }

        public String getPageName() {
            return this.getClass().getName();
        }

        public String getTitle() {
            return LauncherMessages.CONFIGURATION_LIMIT_TITLE;
        }

        public ImageDescriptor getWizardBanner() {
            return TraceUIImages.INSTANCE.getImageDescriptor("profset_wiz.gif");
        }

        public String getDescription() {
            return LauncherMessages.CONFIGURATION_LIMIT_DESC;
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy launchConfigurationWC) {
            launchConfigurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, this.limitsUI.getLimitInvocations());
            launchConfigurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, this.limitsUI.getLimitInvocNb());
            launchConfigurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, this.limitsUI.getLimitTime());
            launchConfigurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, this.limitsUI.getLimitTimeNb());
            launchConfigurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, this.limitsUI.getAutoMonitoring());
            return true;
        }

        public Vector getAttributes() {
            Vector<DataCollectionEngineAttribute> options = new Vector<DataCollectionEngineAttribute>();
            try {
                IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
                boolean limitMethodInvocation = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, false);
                boolean limitTime = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, false);
                int invocationLimitNo = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt("invoc_nb"));
                int timeLimitNo = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt("timeSec"));
                if (limitMethodInvocation) {
                    options.addElement(new DataCollectionEngineAttribute("SETOPTION_BURST_MODE", limitTime ? "secondsAndInvocations" : "invocations"));
                    options.addElement(new DataCollectionEngineAttribute("SETOPTION_BURST_INVOCATIONS", String.valueOf(invocationLimitNo)));
                    if (limitTime) {
                        options.addElement(new DataCollectionEngineAttribute("SETOPTION_BURST_SECONDS", String.valueOf(timeLimitNo)));
                    }
                } else if (limitTime) {
                    options.addElement(new DataCollectionEngineAttribute("SETOPTION_BURST_MODE", "seconds"));
                    options.addElement(new DataCollectionEngineAttribute("SETOPTION_BURST_SECONDS", String.valueOf(timeLimitNo)));
                }
            }
            catch (CoreException e) {
                UIPlugin.getDefault().log(e);
            }
            return options;
        }

        public void addErrorListener(final IStatusListener statusListener) {
            this.limitsUI.addListener(new Listener(){

                public void handleEvent(Event event) {
                    String error = LimitsConfigurationPage.this.limitsUI.validate();
                    if (error != null) {
                        statusListener.handleErrorEvent(error);
                    } else {
                        statusListener.handleOKEvent();
                    }
                }
            });
        }
    }
}

