/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.defaults.ExecutionTimeUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class PITimeAnalysisConf
extends AbstractConfiguration {
    public PITimeAnalysisConf() {
        super(new Class[]{ExecutionTimeConfigurationPage.class});
    }

    public static class ExecutionTimeConfigurationPage
    extends AbstractConfiguration.ExtendedConfigurationPage {
        public static final int DEFAULT_POLLING_PERIOD = 60;
        private ExecutionTimeUI executionTimeUI = new ExecutionTimeUI(false);
        private ILaunchConfiguration launchConfiguration;
        private boolean collectCPUTime;
        private boolean collectBoundaryClass;
        private int boundaryDepth;
        private boolean showExecutionFlow;
        private boolean collectInstanceLevel;
        private boolean controlsCreated;
        private boolean isPollingAutomated;
        private int pollingFrequency;

        public void reset(ILaunchConfiguration launchConfiguration) {
            this.launchConfiguration = launchConfiguration;
            try {
                this.collectCPUTime = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_CPU_TIME, false);
                this.collectBoundaryClass = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_BOUNDARY_CLASS, false);
                this.boundaryDepth = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_BOUNDARY_CLASS_DEPTH, 1);
                this.showExecutionFlow = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, false);
                this.isPollingAutomated = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, true);
                this.pollingFrequency = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, 60);
                this.collectInstanceLevel = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, false);
            }
            catch (CoreException e) {
                UIPlugin.getDefault().log(e);
            }
        }

        public void createControl(Composite parent) {
            this.controlsCreated = true;
            this.executionTimeUI.createControl(parent);
            try {
                this.executionTimeUI.setCPUtime(this.collectCPUTime);
                this.executionTimeUI.setExecutionBoundary(this.collectBoundaryClass);
                this.executionTimeUI.setCollectionDepth(String.valueOf(this.boundaryDepth));
                this.executionTimeUI.setExecutionStatistic(!this.showExecutionFlow);
                this.executionTimeUI.setExecutionFlow(this.showExecutionFlow);
                this.executionTimeUI.setPollingFrequencyMode(this.isPollingAutomated);
                this.executionTimeUI.setPollingFrequency(this.pollingFrequency);
                this.executionTimeUI.setInstance(this.collectInstanceLevel);
            }
            catch (Exception e) {
                LauncherUtility.openWarningWithDetail(LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, LauncherMessages.ERROR_CONFIG_RESTORE, e);
                this.executionTimeUI.setDefaultSettings();
            }
        }

        public String getPageName() {
            return this.getClass().getName();
        }

        public String getTitle() {
            return UIPlugin.getResourceString("executionGroup");
        }

        public ImageDescriptor getWizardBanner() {
            return TraceUIImages.INSTANCE.getImageDescriptor("profset_wiz.gif");
        }

        public String getDescription() {
            return LauncherMessages.CONFIGURATION_EXEC_DESC;
        }

        public void addErrorListener(IStatusListener statusListener) {
            this.executionTimeUI.addStatusListener(statusListener);
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_CPU_TIME, this.controlsCreated ? this.executionTimeUI.getCPUtime() : this.collectCPUTime);
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_BOUNDARY_CLASS, this.controlsCreated ? this.executionTimeUI.getExecutionBoundary() : this.collectBoundaryClass);
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_BOUNDARY_CLASS_DEPTH, this.controlsCreated ? this.executionTimeUI.getCollectionDepth() : this.boundaryDepth);
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, this.controlsCreated ? this.executionTimeUI.getExecutionFlow() : this.showExecutionFlow);
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, this.controlsCreated ? this.executionTimeUI.isPollingFreqModeAutomated() : this.isPollingAutomated);
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, this.controlsCreated ? this.executionTimeUI.getPollingFrequency() : this.pollingFrequency);
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, this.controlsCreated ? this.executionTimeUI.getInstance() : this.collectInstanceLevel);
            return true;
        }

        public Vector getAttributes() {
            Vector<DataCollectionEngineAttribute> options = new Vector<DataCollectionEngineAttribute>();
            try {
                int idx;
                String[][] optionSet;
                boolean collectBoundary = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_BOUNDARY_CLASS, false);
                boolean collectInstanceLevelInfo = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, false);
                if (collectBoundary) {
                    optionSet = null;
                    optionSet = collectInstanceLevelInfo ? Options.OPTIONS_EXECUTION_FLOW_BOUNDARY_INSTANCES : Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
                    idx = 0;
                    while (idx < optionSet.length) {
                        options.add(new DataCollectionEngineAttribute("SETOPTION_" + optionSet[idx][0], optionSet[idx][1]));
                        ++idx;
                    }
                    options.add(new DataCollectionEngineAttribute("SETOPTION_BOUNDARY_DEPTH", String.valueOf(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_BOUNDARY_CLASS_DEPTH, 1))));
                } else {
                    optionSet = null;
                    optionSet = collectInstanceLevelInfo ? Options.OPTIONS_EXECUTION_FLOW_INSTANCES : Options.OPTIONS_EXECUTION_FLOW;
                    idx = 0;
                    while (idx < optionSet.length) {
                        options.add(new DataCollectionEngineAttribute("SETOPTION_" + optionSet[idx][0], optionSet[idx][1]));
                        ++idx;
                    }
                }
                boolean flow = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, false);
                options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, String.valueOf(flow)));
                if (flow) {
                    options.add(new DataCollectionEngineAttribute("SETOPTION_COMPRESS", "none"));
                } else {
                    options.add(new DataCollectionEngineAttribute("SETOPTION_COMPRESS", "aggregate"));
                }
                if (!flow) {
                    boolean automaticPoll = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, true);
                    if (!automaticPoll) {
                        options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, String.valueOf(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, 60))));
                    }
                    options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, String.valueOf(automaticPoll)));
                }
                String showHeap = String.valueOf(collectInstanceLevelInfo);
                options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, showHeap));
                boolean collectCPUTime = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_CPU_TIME, false);
                if (collectCPUTime) {
                    String[][] optionSet2 = Options.OPTIONS_COLLECT_CPU_TIME;
                    int idx2 = 0;
                    while (idx2 < optionSet2.length) {
                        options.add(new DataCollectionEngineAttribute("SETOPTION_" + optionSet2[idx2][0], optionSet2[idx2][1]));
                        ++idx2;
                    }
                }
            }
            catch (Exception e) {
                LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_LAUNCH_ATTRIBUTES, e);
            }
            return options;
        }
    }
}

