/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.platform.common.ui.trace.internal.util.CommonUITraceUtil;
import org.eclipse.tptp.trace.ui.internal.launcher.core.ConfigurationManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILaunchValidator;

public class AnalysisType
implements IProfilingSetType,
Cloneable {
    private String id;
    private String name;
    private String description;
    private Map coexistanceViolators;
    private ImageDescriptor icon;
    private LightConfigurationLoader configuration;
    private ILaunchValidator supplement;
    private ICollectorFiltration filter;
    private IProfilingType dummyProfilingType;

    private AnalysisType() {
    }

    public static AnalysisType constructInstance(IConfigurationElement configurationElement) {
        String name = configurationElement.getAttribute("name");
        ImageDescriptor icon = CommonUITraceUtil.resolveImageDescriptor((IConfigurationElement)configurationElement, (String)"icon");
        String configurationId = configurationElement.getAttribute("configurationId");
        LightConfigurationLoader configuration = null;
        if (configurationId != null) {
            configuration = ConfigurationManager.getInstance().getConfiguration(configurationId);
        }
        ILaunchValidator validator = null;
        if (configurationElement.getAttribute("validator") != null) {
            try {
                validator = (ILaunchValidator)configurationElement.createExecutableExtension("validator");
            }
            catch (Exception exception) {
                validator = null;
            }
        }
        String description = configurationElement.getAttribute("description");
        String id = configurationElement.getAttribute("id");
        if (id == null || name == null) {
            return null;
        }
        IConfigurationElement[] coexistanceViolatorsConf = configurationElement.getChildren("coexistanceViolation");
        Hashtable<String, Boolean> coexistanceViolators = new Hashtable<String, Boolean>();
        if (coexistanceViolatorsConf != null && coexistanceViolatorsConf.length == 1) {
            IConfigurationElement[] rule = coexistanceViolatorsConf[0].getChildren("rule");
            int i = 0;
            while (i < rule.length) {
                String coexistanceViolator = null;
                coexistanceViolator = rule[i].getAttribute("analysisTypeId");
                if (coexistanceViolator != null) {
                    coexistanceViolators.put(coexistanceViolator, Boolean.TRUE);
                }
                ++i;
            }
        }
        if (coexistanceViolators.size() <= 0) {
            coexistanceViolators = null;
        }
        ICollectorFiltration filter = null;
        try {
            if (configurationElement.getAttribute("filter") != null) {
                filter = (ICollectorFiltration)configurationElement.createExecutableExtension("filter");
            }
        }
        catch (CoreException coreException) {
            filter = null;
        }
        AnalysisType analysisType = new AnalysisType();
        analysisType.setName(name);
        analysisType.setId(id);
        analysisType.setIcon(icon);
        analysisType.setConfiguration(configuration);
        analysisType.setSupplement(validator);
        analysisType.setDescription(description);
        analysisType.setCoexistanceViolators(coexistanceViolators);
        analysisType.setFilter(filter);
        return analysisType;
    }

    public Map getCoexistanceViolators() {
        return this.coexistanceViolators;
    }

    public void setCoexistanceViolators(Map coexistanceViolators) {
        this.coexistanceViolators = coexistanceViolators;
    }

    public LightConfigurationLoader getConfigurationLoader() {
        return this.configuration;
    }

    public void setConfiguration(LightConfigurationLoader configuration) {
        this.configuration = configuration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public void setIcon(ImageDescriptor icon) {
        this.icon = icon;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ILaunchValidator getValidator() {
        return this.supplement;
    }

    public void setSupplement(ILaunchValidator validator) {
        this.supplement = validator;
    }

    public ImageDescriptor getImage() {
        return this.getIcon();
    }

    public void setImage(ImageDescriptor image) {
        this.setIcon(image);
    }

    public ICollectorFiltration getFilter() {
        return this.filter;
    }

    public void setFilter(ICollectorFiltration filter) {
        this.filter = filter;
    }

    public IProfilingType getProfilingType() {
        if (this.dummyProfilingType == null) {
            this.dummyProfilingType = this.createDummyProfilingType();
        }
        return this.dummyProfilingType;
    }

    public void setProfilingType(IProfilingType profilingType) {
        this.dummyProfilingType = profilingType;
    }

    public boolean isUseFilters() {
        return false;
    }

    public void setUseFilters(boolean useFilters) {
    }

    public String getGroup() {
        return null;
    }

    public void setGroup(String group) {
    }

    private IProfilingType createDummyProfilingType() {
        IProfilingType profilingType = new IProfilingType(){
            private Composite parent;

            public Control createControl(Composite parent, ProfilingSetsManagerCopy config) {
                this.parent = parent;
                return parent;
            }

            public Control getControl(String profilingSetName) {
                return this.parent;
            }

            public ProfilingAttribute[] getAttributes() {
                LightConfigurationLoader configurationLoader = AnalysisType.this.getConfigurationLoader();
                if (configurationLoader != null) {
                    return configurationLoader.getConfigurationClass().getAttributes();
                }
                return null;
            }

            public String validateConfiguration(ProfilingSetsManagerCopy managerCopy) {
                return null;
            }

            public String launch(ILaunchConfiguration config) {
                return null;
            }

            public String getDescription(ProfilingSetsManagerCopy managerCopy) {
                return AnalysisType.this.getDescription();
            }
        };
        return profilingType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnalysisType) {
            return this.id != null && this.id.equals(((AnalysisType)obj).getId());
        }
        if (obj instanceof IProfilingSetType) {
            return this.id != null && this.id.equals(((IProfilingSetType)obj).getId());
        }
        return false;
    }
}

