/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisTypeManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class AnalysisTypeAssociationManager {
    private Hashtable associatedAnalysisTypes = new Hashtable();
    private static AnalysisTypeAssociationManager instance;

    private AnalysisTypeAssociationManager() {
        this.initialize();
    }

    private void initialize() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.trace.ui.analysisTypesAssociation");
        int i = 0;
        while (i < elements.length) {
            String dataCollectorId = elements[i].getAttribute("dataCollectionMechanismId");
            if (dataCollectorId != null) {
                IConfigurationElement[] analysisTypes = elements[i].getChildren();
                int j = 0;
                while (j < analysisTypes.length) {
                    String analysisTypeId;
                    if ("analysisType".equals(analysisTypes[j].getName()) && (analysisTypeId = analysisTypes[j].getAttribute("id")) != null) {
                        ArrayList analysisTypesList = (ArrayList)LauncherUtility.getHashtableEntry(this.associatedAnalysisTypes, dataCollectorId, ArrayList.class, true);
                        analysisTypesList.add(analysisTypeId);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static AnalysisTypeAssociationManager getInstance() {
        if (instance == null) {
            instance = new AnalysisTypeAssociationManager();
        }
        return instance;
    }

    public AnalysisType[] getAssociatedAnalysisTypes(String dataCollectionMechanismId) {
        ArrayList<AnalysisType> analysisTypesList = new ArrayList<AnalysisType>();
        ArrayList analysisTypeIds = (ArrayList)this.associatedAnalysisTypes.get(dataCollectionMechanismId);
        if (analysisTypeIds != null) {
            int i = 0;
            int analysisTypeCount = analysisTypeIds.size();
            while (i < analysisTypeCount) {
                AnalysisType analysisType = AnalysisTypeManager.getInstance().getAnalysisType((String)analysisTypeIds.get(i));
                if (analysisType != null) {
                    analysisTypesList.add(analysisType);
                }
                ++i;
            }
        }
        AnalysisType[] associatedTypes = new AnalysisType[analysisTypesList.size()];
        analysisTypesList.toArray(associatedTypes);
        return associatedTypes;
    }
}

