/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.IAvailabilityTester;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;

public class ConfigurationLoader
extends LightConfigurationLoader {
    public static final String ATTRIBUTE_WIDTH = "width";
    public static final String ATTRIBUTE_HEIGHT = "height";
    private String dialogTitle;
    private Hashtable attributes;

    private ConfigurationLoader(String id, String dialogTitle, IConfiguration mainClass) {
        super(id);
        this.editable = true;
        this.configurationClass = mainClass;
        this.dialogTitle = dialogTitle;
    }

    public static LightConfigurationLoader constructInstance(IConfigurationElement configuration) {
        if (!"configuration".equalsIgnoreCase(configuration.getName())) {
            return null;
        }
        String[] attributeValues = LauncherUtility.getAttributes(configuration, new String[]{"id", "dialogTitle", "class", "testAvailabilityClass"});
        int i = 0;
        while (i < 2) {
            if (attributeValues[i] == null) {
                return null;
            }
            ++i;
        }
        IConfiguration configurationClass = null;
        IAvailabilityTester availabilityTester = null;
        try {
            if (attributeValues[2] != null) {
                configurationClass = (IConfiguration)configuration.createExecutableExtension("class");
            }
            if (attributeValues[3] != null) {
                availabilityTester = (IAvailabilityTester)configuration.createExecutableExtension("testAvailabilityClass");
            }
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationLoader configurationLoader = new ConfigurationLoader(attributeValues[0], attributeValues[1], configurationClass);
        configurationLoader.setAvailabilityTester(availabilityTester);
        IConfigurationElement[] children = configuration.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            String[] attribute;
            IConfigurationElement child = children[i2];
            if ("attribute".equalsIgnoreCase(child.getName()) && (attribute = LauncherUtility.getAttributes(child, new String[]{"name", "value"})) != null && attribute.length > 0 && attribute[0] != null && attribute[1] != null) {
                configurationLoader.getAttributes().put(attribute[0], attribute[1]);
            }
            ++i2;
        }
        configurationClass.initialize();
        return configurationLoader;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public Hashtable getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        return this.attributes;
    }

    public String retrieveAttribute(String name) {
        return (String)this.getAttributes().get(name);
    }
}

