/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;

public class DataCollectorAssociation {
    private Hashtable associatedDataCollectorMechanism = new Hashtable();
    private String[] defaultDataCollectors;
    private DataCollector[] dataCollectors;
    private String launchConfigurationId;
    private static DataCollectorAssociation defaultAssociation;

    protected DataCollectorAssociation() {
    }

    public static DataCollectorAssociation constructInstances(IConfigurationElement association, Hashtable associationTable) {
        String launchConfigID = association.getAttribute("launchConfigID");
        if (launchConfigID == null) {
            return null;
        }
        DataCollectorAssociation datacollectorAssociation = (DataCollectorAssociation)associationTable.get(launchConfigID);
        if (datacollectorAssociation == null) {
            datacollectorAssociation = new DataCollectorAssociation();
            datacollectorAssociation.setLaunchConfigurationId(launchConfigID);
        }
        Hashtable datacollectorAssociationData = datacollectorAssociation.getAssociatedDataCollectorMechanism();
        IConfigurationElement[] configurationElemChildren = association.getChildren("mechanism");
        int k = 0;
        while (k < configurationElemChildren.length) {
            DataCollectorAssociationData datacollectorAssociationDataEntry = DataCollectorAssociationData.constructInstance(configurationElemChildren[k]);
            if (datacollectorAssociationDataEntry != null) {
                datacollectorAssociationData.put(datacollectorAssociationDataEntry.getDataCollectorId(), datacollectorAssociationDataEntry);
            }
            ++k;
        }
        datacollectorAssociation.setAssociatedDataCollectorMechanism(datacollectorAssociationData);
        configurationElemChildren = association.getChildren("defaultDataCollectors");
        String[] defaultDataCollectors = null;
        if (configurationElemChildren != null && configurationElemChildren.length == 1) {
            configurationElemChildren = configurationElemChildren[0].getChildren("defaultCollector");
            Vector<String> defaultCollectors = new Vector<String>();
            int k2 = 0;
            while (k2 < configurationElemChildren.length) {
                defaultCollectors.add(configurationElemChildren[k2].getAttribute("datacollectorID"));
                ++k2;
            }
            defaultDataCollectors = datacollectorAssociation.getDefaultDataCollectors();
            if (defaultDataCollectors == null) {
                defaultDataCollectors = new String[defaultCollectors.size()];
                defaultCollectors.toArray(defaultDataCollectors);
                datacollectorAssociation.setDefaultDataCollectors(defaultDataCollectors);
            } else {
                int totalLength = defaultCollectors.size() + defaultDataCollectors.length;
                String[] updatedListOfDefaults = new String[totalLength];
                System.arraycopy(defaultDataCollectors, 0, updatedListOfDefaults, 0, defaultDataCollectors.length);
                int i = defaultDataCollectors.length;
                while (i < totalLength) {
                    updatedListOfDefaults[i] = (String)defaultCollectors.get(i - defaultDataCollectors.length);
                    ++i;
                }
                datacollectorAssociation.setDefaultDataCollectors(updatedListOfDefaults);
            }
        }
        return datacollectorAssociation;
    }

    public Hashtable getAssociatedDataCollectorMechanism() {
        return this.associatedDataCollectorMechanism;
    }

    public void setAssociatedDataCollectorMechanism(Hashtable associatedDataCollectorMechanism) {
        this.associatedDataCollectorMechanism = associatedDataCollectorMechanism;
    }

    public String[] getDefaultDataCollectors() {
        return this.defaultDataCollectors;
    }

    public void setDefaultDataCollectors(String[] defaultDataCollectors) {
        this.defaultDataCollectors = defaultDataCollectors;
    }

    public DataCollector[] getDataCollectors() {
        if (this.dataCollectors != null) {
            return this.dataCollectors;
        }
        Vector<DataCollector> datacollectorsContainer = new Vector<DataCollector>();
        for (DataCollectorAssociationData dataCollectorAssociationData : this.associatedDataCollectorMechanism.values()) {
            datacollectorsContainer.add(DataCollectorManager.getInstance().getDataCollector(dataCollectorAssociationData.getDataCollectorId()));
        }
        this.dataCollectors = new DataCollector[datacollectorsContainer.size()];
        datacollectorsContainer.toArray(this.dataCollectors);
        return this.dataCollectors;
    }

    public DataCollectorAssociationData getDataCollectorAssociationData(String dataCollectorId) {
        return (DataCollectorAssociationData)this.associatedDataCollectorMechanism.get(dataCollectorId);
    }

    public String getLaunchConfigurationId() {
        return this.launchConfigurationId;
    }

    public void setLaunchConfigurationId(String launchConfigurationId) {
        this.launchConfigurationId = launchConfigurationId;
    }

    public static DataCollectorAssociation getDefault() {
        if (defaultAssociation == null) {
            defaultAssociation = new DataCollectorAssociation();
            DataCollectorAssociation.defaultAssociation.associatedDataCollectorMechanism.put("org.eclipse.tptp.trace.ui.jvmpiMechanism", DataCollectorManager.getInstance().getDataCollectorAssociator("org.eclipse.jdt.launching.localJavaApplication").getDataCollectorAssociationData("org.eclipse.tptp.trace.ui.jvmpiMechanism"));
        }
        return defaultAssociation;
    }
}

