/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Collection;
import java.util.Hashtable;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.IDataCollectorFetchListener;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;

public class DataCollectorManager {
    private static DataCollectorManager instance;
    private Hashtable datacollectors = new Hashtable();
    private Hashtable datacollectorAssociations = new Hashtable();
    private WeakHashMap<IDataCollectorFetchListener, Object> collectorListeners = new WeakHashMap();
    private int runningJobs;

    private DataCollectorManager() {
        this.initialize();
    }

    private void initialize() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.trace.ui.dataCollectionMechanism");
        int i = 0;
        while (i < elements.length) {
            DataCollector datacollector;
            if ("collector".equalsIgnoreCase(elements[i].getName()) && (datacollector = DataCollector.constructInstances(elements[i])) != null) {
                this.datacollectors.put(datacollector.getId(), datacollector);
            }
            ++i;
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.trace.ui.launchConfigMechanismAssociator");
        i = 0;
        while (i < elements.length) {
            DataCollectorAssociation datacollectorAssociation;
            if ("association".equalsIgnoreCase(elements[i].getName()) && (datacollectorAssociation = DataCollectorAssociation.constructInstances(elements[i], this.datacollectorAssociations)) != null) {
                this.datacollectorAssociations.put(datacollectorAssociation.getLaunchConfigurationId(), datacollectorAssociation);
            }
            ++i;
        }
    }

    public static DataCollectorManager getInstance() {
        if (instance == null) {
            instance = new DataCollectorManager();
        }
        return instance;
    }

    public DataCollector getDataCollector(String datacollectorID) {
        return (DataCollector)this.datacollectors.get(datacollectorID);
    }

    public DataCollectorAssociation getDataCollectorAssociator(String launchConfigurationID) {
        DataCollectorAssociation association = (DataCollectorAssociation)this.datacollectorAssociations.get(launchConfigurationID);
        if (association == null) {
            return DataCollectorAssociation.getDefault();
        }
        return association;
    }

    public IDataCollectorBaseLauncher getDataCollectorLaunchDelegate(String dataCollectorID, ILaunchConfiguration configurationType) throws CoreException {
        DataCollector dataCollector = (DataCollector)this.datacollectors.get(dataCollectorID);
        if (dataCollector == null) {
            return null;
        }
        DataCollectorAssociation dataCollectorAssociation = (DataCollectorAssociation)this.datacollectorAssociations.get(configurationType.getType().getIdentifier());
        if (dataCollectorAssociation == null) {
            return null;
        }
        DataCollectorAssociationData datacollectorAssociationData = dataCollectorAssociation.getDataCollectorAssociationData(dataCollectorID);
        if (datacollectorAssociationData == null) {
            return null;
        }
        return datacollectorAssociationData.createLaunchDelegate();
    }

    public DataCollector[] getDataCollectors() {
        Collection values = this.datacollectors.values();
        DataCollector[] datacollectors = new DataCollector[values.size()];
        values.toArray(datacollectors);
        return datacollectors;
    }

    public synchronized boolean waitForDataCollectors(long timeout) {
        long baseTime = System.currentTimeMillis();
        while (this.isFetching()) {
            long remainingTime = baseTime + timeout - System.currentTimeMillis();
            if (remainingTime < 0L) {
                return false;
            }
            try {
                this.wait(remainingTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    synchronized void beginFetch() {
        if (this.runningJobs == 0) {
            for (IDataCollectorFetchListener l : this.collectorListeners.keySet()) {
                l.fetchStarted();
            }
        }
        ++this.runningJobs;
    }

    synchronized void endFetch(DataCollector[] result) {
        --this.runningJobs;
        if (this.runningJobs == 0) {
            for (IDataCollectorFetchListener l : this.collectorListeners.keySet()) {
                l.fetchComplete(result);
            }
            this.notifyAll();
        }
    }

    public synchronized void addDataCollectorFetchListener(IDataCollectorFetchListener listener) {
        this.collectorListeners.put(listener, null);
    }

    public synchronized void removeDataCollectorFetchListener(IDataCollectorFetchListener listener) {
        this.collectorListeners.remove(listener);
    }

    public synchronized boolean isFetching() {
        return this.runningJobs > 0;
    }
}

