/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFilterManager;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachAgentTabProviders;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.SelectedAgent;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisTypeManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeContentProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorSelfManageableLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILaunchValidator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;

public class LauncherUtility {
    public static final byte ANALYSIS_TYPE = 1;
    public static final byte IPROFILING_SET_TYPE = 2;

    public static CoreException createCoreException(int severity, String message, Exception exception) {
        Status status = new Status(severity, UIPlugin.getPluginId(), 0, message == null ? "" : message, (Throwable)exception);
        return new CoreException((IStatus)status);
    }

    public static CoreException createCoreException(int severity, String message) {
        return LauncherUtility.createCoreException(severity, message, null);
    }

    public static Object getHashtableEntry(Hashtable hashtable, Object key, Class valueType, boolean create) {
        Object hashtableEntry = hashtable.get(key);
        if (hashtableEntry == null && create) {
            try {
                hashtableEntry = valueType.newInstance();
                hashtable.put(key, hashtableEntry);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return hashtableEntry;
    }

    public static void setBold(Label label) {
        FontData[] fontData = label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        label.setFont(new Font(null, fontData));
    }

    public static void openMessageWithDetail(Shell parent, int severity, String title, String message, String cause) {
        class CustomErrorDialog
        extends ErrorDialog {
            private String cause;
            private static final int LIST_ITEM_COUNT = 7;
            private org.eclipse.swt.widgets.List list;
            private boolean isListDisplayed;
            private Clipboard clipboard;

            public CustomErrorDialog(Shell parentShell, int severity, String dialogTitle, String message, String cause) {
                super(parentShell, dialogTitle, message, (IStatus)new Status(severity, UIPlugin.getPluginId(), severity, "", new Throwable(cause)), 7);
                this.cause = cause;
                this.isListDisplayed = false;
            }

            public void openErrorDialog() {
                this.open();
            }

            protected org.eclipse.swt.widgets.List createDropDownList(Composite parent) {
                if (this.isListDisplayed) {
                    this.isListDisplayed = false;
                    this.list.dispose();
                    return this.list;
                }
                this.isListDisplayed = true;
                this.list = new org.eclipse.swt.widgets.List(parent, 2818);
                if (this.cause != null) {
                    StringTokenizer st = new StringTokenizer(this.cause, "\n");
                    String indents = "";
                    boolean addedIndentation = false;
                    while (st.hasMoreTokens()) {
                        String currentToken = st.nextToken();
                        currentToken = currentToken.replace('\r', ' ');
                        currentToken = currentToken.trim();
                        if (!addedIndentation && currentToken.startsWith("at")) {
                            indents = String.valueOf(indents) + "  ";
                            addedIndentation = true;
                        } else if (addedIndentation && !currentToken.startsWith("at")) {
                            addedIndentation = false;
                        }
                        this.list.add(String.valueOf(indents) + currentToken);
                    }
                }
                GridData data = new GridData(1808);
                data.heightHint = this.list.getItemHeight() * 7;
                data.horizontalSpan = 2;
                this.list.setLayoutData((Object)data);
                this.list.setFont(parent.getFont());
                Menu copyMenu = new Menu((Control)this.list);
                MenuItem copyItem = new MenuItem(copyMenu, 0);
                copyItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }
                });
                copyItem.setText(LauncherMessages.LAUNCHER_COMMON_COPY);
                this.list.setMenu(copyMenu);
                return this.list;
            }

            private void copyToClipboard() {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                StringBuffer clipBoardBuffer = new StringBuffer();
                String[] listEntrySelections = this.list.getSelection();
                int i = 0;
                while (i < listEntrySelections.length) {
                    clipBoardBuffer.append(String.valueOf(listEntrySelections[i]) + LauncherConstants.LINE_SEPARATOR);
                    ++i;
                }
                this.clipboard = new Clipboard(this.list.getDisplay());
                this.clipboard.setContents(new Object[]{clipBoardBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        CustomErrorDialog errorDialog = new CustomErrorDialog(parent, severity, title, message, cause);
        errorDialog.openErrorDialog();
    }

    public static void openMessageWithDetail(final int severity, final String title, final String message, Throwable t) {
        String stackTrace = t == null ? null : LauncherUtility.getExceptionStackTrace(t);
        Throwable exceptionCause = t != null && t.getCause() != null ? t.getCause() : t;
        final String cause = exceptionCause != null ? String.valueOf(exceptionCause.getClass().getName()) + "\n" + exceptionCause.getMessage() + "\n \n" + stackTrace : "";
        final IWorkbench workbench = UIPlugin.getDefault().getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LauncherUtility.openMessageWithDetail(workbench.getActiveWorkbenchWindow().getShell(), severity, title, message, cause);
            }
        });
    }

    public static void openErrorWithDetail(String title, String message, Throwable t) {
        LauncherUtility.openMessageWithDetail(4, title, message, t);
    }

    public static void openWarningWithDetail(String title, String message, Throwable t) {
        LauncherUtility.openMessageWithDetail(2, title, message, t);
    }

    public static String getExceptionStackTrace(Throwable t) {
        Throwable throwable = LauncherUtility.findCause(t);
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        return stackTrace.toString();
    }

    public static Throwable findCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        } else if (t instanceof CoreException) {
            cause = ((CoreException)t).getStatus().getException();
        }
        if (cause == null) {
            return t;
        }
        return LauncherUtility.findCause(cause);
    }

    public static DataCollectorTreeContentProvider.ParentChildNode[] getSelectedDataCollectors(String profilingSetId) {
        if (profilingSetId == null) {
            return null;
        }
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        IProfilingSet set = (IProfilingSet)manager.getProfilingSets().get(profilingSetId);
        Vector<DataCollectorTreeContentProvider.ParentChildNode> itemsSelected = new Vector<DataCollectorTreeContentProvider.ParentChildNode>();
        if (set != null) {
            List profilingTypes = set.getProfilingTypes();
            int i = 0;
            int profilingTypeCount = profilingTypes.size();
            while (i < profilingTypeCount) {
                DataCollectorTreeContentProvider.ParentChildNode parentChildNode = LauncherUtility.findAnalysisTypeItem((String)profilingTypes.get(i));
                if (parentChildNode != null) {
                    itemsSelected.add(parentChildNode);
                }
                ++i;
            }
        }
        DataCollectorTreeContentProvider.ParentChildNode[] items = new DataCollectorTreeContentProvider.ParentChildNode[itemsSelected.size()];
        itemsSelected.toArray(items);
        return items;
    }

    private static DataCollectorTreeContentProvider.ParentChildNode findAnalysisTypeItem(String analysisTypeId) {
        if ("org.eclipse.hyades.profilingType.execution".equals(analysisTypeId)) {
            analysisTypeId = "org.eclipse.tptp.analysisType.execution";
        } else if ("org.eclipse.hyades.profilingType.memoryHeap".equals(analysisTypeId)) {
            analysisTypeId = "org.eclipse.tptp.analysisType.memoryHeap";
        } else if ("org.eclipse.hyades.profilingType.methodCoverage".equals(analysisTypeId)) {
            analysisTypeId = "org.eclipse.tptp.analysisType.methodCoverage";
        }
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        DataCollector jvmpiDataCollector = DataCollectorManager.getInstance().getDataCollector("org.eclipse.tptp.trace.ui.jvmpiMechanism");
        Object child = manager.getProfilingTypes().get(analysisTypeId);
        if (child == null) {
            child = LauncherUtility.getAnalysisType(jvmpiDataCollector, analysisTypeId);
        }
        if (child != null) {
            return new DataCollectorTreeContentProvider.ParentChildNode(jvmpiDataCollector, child);
        }
        DataCollector[] dataCollectors = DataCollectorManager.getInstance().getDataCollectors();
        int i = 0;
        while (i < dataCollectors.length) {
            child = LauncherUtility.getAnalysisType(dataCollectors[i], analysisTypeId);
            if (child != null) {
                return new DataCollectorTreeContentProvider.ParentChildNode(dataCollectors[i], child);
            }
            ++i;
        }
        return null;
    }

    private static Object getAnalysisType(DataCollector dataCollector, String analysisTypeId) {
        AnalysisType[] analysisTypes = dataCollector.getApplicableAnalysisTypes();
        if (analysisTypes == null) {
            return null;
        }
        int i = 0;
        while (i < analysisTypes.length) {
            if (analysisTypes[i].getId().equals(analysisTypeId)) {
                return analysisTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static String serializeSelection(String profilingSetId) {
        if (profilingSetId == null) {
            return null;
        }
        DataCollectorTreeContentProvider.ParentChildNode[] parentChildNodes = LauncherUtility.getSelectedDataCollectors(profilingSetId);
        Hashtable<Object, Integer> dataCollectors = new Hashtable<Object, Integer>();
        Vector<Object> selection = new Vector<Object>();
        int i = 0;
        while (i < parentChildNodes.length) {
            if (dataCollectors.get(parentChildNodes[i].parent) == null) {
                selection.add(parentChildNodes[i].parent);
                dataCollectors.put(parentChildNodes[i].parent, new Integer(selection.size()));
            }
            selection.add((Integer)dataCollectors.get(parentChildNodes[i].parent), parentChildNodes[i]);
            ++i;
        }
        Object[] selectedElements = new Object[selection.size()];
        selection.toArray(selectedElements);
        return LauncherUtility.serializeSelection(selectedElements);
    }

    public static String serializeSelection(CheckboxTreeViewer checkBoxTreeViewer) {
        return LauncherUtility.serializeSelection(checkBoxTreeViewer.getCheckedElements());
    }

    public static String serializeSelection(Object[] selection) {
        String serializedTreeSelection = "";
        boolean lastSelectionWasDataCollector = false;
        int i = 0;
        while (i < selection.length) {
            Object childNode = null;
            if (selection[i] instanceof DataCollector) {
                if (serializedTreeSelection.length() > 0) {
                    serializedTreeSelection = String.valueOf(serializedTreeSelection) + ";";
                }
                serializedTreeSelection = String.valueOf(serializedTreeSelection) + ((DataCollector)selection[i]).getId();
                lastSelectionWasDataCollector = true;
            } else if (selection[i] instanceof DataCollectorTreeContentProvider.ParentChildNode) {
                childNode = ((DataCollectorTreeContentProvider.ParentChildNode)selection[i]).child;
                String typeID = null;
                if (childNode instanceof AnalysisType) {
                    typeID = ((AnalysisType)childNode).getId();
                } else if (childNode instanceof IProfilingSetType) {
                    typeID = ((IProfilingSetType)childNode).getId();
                }
                if (typeID != null) {
                    serializedTreeSelection = lastSelectionWasDataCollector ? String.valueOf(serializedTreeSelection) + ":" : String.valueOf(serializedTreeSelection) + ",";
                    serializedTreeSelection = String.valueOf(serializedTreeSelection) + typeID;
                    lastSelectionWasDataCollector = false;
                }
            }
            ++i;
        }
        return serializedTreeSelection;
    }

    public static Hashtable unserializeSelection(ILaunchConfiguration conf) {
        try {
            String dataCollectorsStr = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, null);
            return LauncherUtility.unserializeSelection(dataCollectorsStr);
        }
        catch (Exception e1) {
            LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_DCM_NOT_FOUND, e1);
            return null;
        }
    }

    public static Hashtable unserializeSelection(String dataCollectorsStr) {
        Hashtable collectorAnalysisMap = new Hashtable();
        ArrayList<IProfilingSetType> childTypesContainer = new ArrayList<IProfilingSetType>();
        if (dataCollectorsStr == null) {
            return null;
        }
        StringTokenizer datacollectorTokenizer = new StringTokenizer(dataCollectorsStr, ";");
        while (datacollectorTokenizer.hasMoreTokens()) {
            String dataCollectorID;
            String selectedDataCollector = datacollectorTokenizer.nextToken();
            int dataCollectorInx = selectedDataCollector.indexOf(58);
            if (dataCollectorInx == -1) {
                dataCollectorID = selectedDataCollector;
            } else {
                dataCollectorID = selectedDataCollector.substring(0, dataCollectorInx);
                StringTokenizer analysisTypesSelected = new StringTokenizer(selectedDataCollector.substring(dataCollectorInx + 1), ",");
                childTypesContainer = new ArrayList();
                while (analysisTypesSelected.hasMoreTokens()) {
                    String childTypeId = analysisTypesSelected.nextToken();
                    AnalysisType analysisType = AnalysisTypeManager.getInstance().getAnalysisType(childTypeId);
                    if (analysisType != null) {
                        childTypesContainer.add(analysisType);
                        continue;
                    }
                    IProfilingSetType profilingSetType = (IProfilingSetType)ProfilingSetsManager.instance().getProfilingTypes().get(childTypeId);
                    if (profilingSetType == null) continue;
                    childTypesContainer.add(profilingSetType);
                }
            }
            DataCollector dataCollector = DataCollectorManager.getInstance().getDataCollector(dataCollectorID);
            if (dataCollector == null) {
                LauncherUtility.openWarningWithDetail(LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, NLS.bind((String)LauncherMessages.ERROR_DCM_INVALID, (Object)dataCollectorID), null);
                continue;
            }
            collectorAnalysisMap.put(dataCollector, childTypesContainer);
        }
        return collectorAnalysisMap;
    }

    public static List getDefaultProfilingOptions() {
        ArrayList<ProfilingAttribute> list = new ArrayList<ProfilingAttribute>();
        String[][] options = Options.OPTIONS_DEFAULT;
        int i = 0;
        while (i < options.length) {
            list.add(new ProfilingAttribute("SETOPTION_" + options[i][0], options[i][1]));
            ++i;
        }
        return list;
    }

    public static ProfilingAttribute[] getDefaultProfilingOptionsAttributes() {
        String[][] options = Options.OPTIONS_DEFAULT;
        ProfilingAttribute[] attributes = new ProfilingAttribute[options.length];
        int i = 0;
        while (i < options.length) {
            attributes[i] = new ProfilingAttribute("SETOPTION_" + options[i][0], options[i][1]);
            ++i;
        }
        return attributes;
    }

    public static List filterDuplicateOptions(List original) {
        ArrayList result = new ArrayList();
        Iterator iter = original.iterator();
        while (iter.hasNext()) {
            LauncherUtility.addProfilingOption(result, (ProfilingAttribute)iter.next());
        }
        return result;
    }

    public static void addProfilingOption(List options, ProfilingAttribute option) {
        int idx = 0;
        while (idx < options.size()) {
            ProfilingAttribute pOption = (ProfilingAttribute)options.get(idx);
            if (pOption.getName().equals(option.getName())) {
                if (pOption.getValue().equals("false")) {
                    pOption.setValue(option.getValue());
                } else if (pOption.getValue().equals("none")) {
                    pOption.setValue(option.getValue());
                } else {
                    if (option.getValue().equals("false")) {
                        return;
                    }
                    if (pOption.getValue().equals("none")) {
                        return;
                    }
                    if (pOption.getName().equals("SETOPTION_STACK_INFORMATION")) {
                        if (pOption.getValue().equals("boundary")) {
                            return;
                        }
                        if (!option.getValue().equals("none")) {
                            pOption.setValue(option.getValue());
                        }
                    } else if (pOption.getName().equals("SETOPTION_TRACE_MODE") && pOption.getValue().equals("noObjectCorrelation")) {
                        pOption.setValue(option.getValue());
                    }
                }
                return;
            }
            ++idx;
        }
        options.add(option);
    }

    public static String[] getAttributes(IConfigurationElement configuration, String[] attributeNames) {
        if (attributeNames == null || attributeNames.length <= 0) {
            return null;
        }
        String[] attributeValues = new String[attributeNames.length];
        int i = -1;
        while (++i < attributeNames.length) {
            attributeValues[i] = configuration.getAttribute(attributeNames[i]);
        }
        return attributeValues;
    }

    public static boolean isInputPositiveInteger(String num) {
        try {
            return Integer.parseInt(num) > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void openInfo(String title, String message) {
        MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    public static int getPort(ILaunchConfiguration conf) throws CoreException {
        IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
        int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
        return port;
    }

    public static String[] resolveProcessAttributes(Process process) throws InactiveProcessException {
        String pName = process.getParameters();
        if (pName == null) {
            pName = LauncherMessages.LAUNCHER_COMMON_UNKNOWN;
        }
        String params = "";
        String vmparam = "";
        if (process.getExecutable().startsWith("java")) {
            int idx;
            String exeName = process.getParameters();
            if (exeName == null) {
                exeName = LauncherMessages.LAUNCHER_COMMON_UNKNOWN;
            }
            if (!exeName.startsWith("-X")) {
                exeName = "-X " + exeName;
            }
            if ((idx = (exeName = exeName.trim()).indexOf(" ")) != -1 && idx < exeName.length() + 1) {
                exeName = exeName.substring(idx + 1).trim();
            }
            while (exeName.startsWith("-") || exeName.startsWith("\"")) {
                idx = LauncherUtility.findVMendIdx(exeName);
                if (idx != -1) {
                    vmparam = String.valueOf(vmparam) + " " + exeName.substring(0, idx);
                    exeName = exeName.substring(idx + 1).trim();
                    continue;
                }
                vmparam = exeName;
                exeName = "";
            }
            idx = exeName.indexOf(" ");
            if (idx != -1) {
                params = exeName.substring(idx);
                exeName = exeName.substring(0, idx);
            }
            pName = exeName;
        }
        return new String[]{pName, params, vmparam};
    }

    private static int findVMendIdx(String vmargs) {
        int qIdx;
        String space = " ";
        String quote = "\"";
        int startIdx = 0;
        int endIdx = vmargs.indexOf(space);
        if (endIdx != -1 && (qIdx = vmargs.substring(startIdx, endIdx).indexOf(quote)) != -1) {
            startIdx = endIdx + vmargs.substring(endIdx + 1).indexOf(quote) + 1;
            endIdx = startIdx + LauncherUtility.findVMendIdx(vmargs.substring(startIdx + 1)) + 1;
        }
        return endIdx;
    }

    public static void sendProfileEvent(final int profileEvent, final Object source) {
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(source);
                event.setType(profileEvent);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    public static String convertToString(String[] attributeValue) {
        if (attributeValue.length == 0) {
            return null;
        }
        return ProfileLaunchUtil.convertToDelimitedString(attributeValue, ' ');
    }

    public static DataCollectorAssociationData findDataCollectorAssociationData(ILaunchConfiguration launchConfiguration, Object selectedElement) {
        try {
            DataCollectorAssociation dataCollectionAssociation;
            DataCollector dataCollector = null;
            if (selectedElement instanceof DataCollector) {
                dataCollector = (DataCollector)selectedElement;
            } else if (selectedElement instanceof AttachAgentTabProviders.AgentTreeItem) {
                dataCollector = ((AttachAgentTabProviders.AgentTreeItem)selectedElement).getDataCollector();
            }
            if (dataCollector != null && (dataCollectionAssociation = DataCollectorManager.getInstance().getDataCollectorAssociator(launchConfiguration.getType().getIdentifier())) != null) {
                return dataCollectionAssociation.getDataCollectorAssociationData(dataCollector.getId());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static AgentConfigurationEntry createAgentConfigurationEntry(String name, String value) {
        AgentConfigurationEntry entry = new AgentConfigurationEntry();
        entry.setName(name);
        entry.setValue(value);
        entry.setType("SETOPTION");
        return entry;
    }

    public static AgentConfigurationEntry associateAnalysisType(Agent agent, String id) {
        String name = String.valueOf(LauncherConstants.ANALYSIS_TYPE_ASSOCIATION) + "(" + id + ")";
        String value = id;
        int i = 0;
        while (agent != null && i < agent.getConfiguration().size()) {
            AgentConfigurationEntry entry = agent.getConfiguration().getEntryAt(i);
            if (entry.getName().equals(name) && entry.getValue().equals(value)) {
                return entry;
            }
            ++i;
        }
        AgentConfigurationEntry entry = LauncherUtility.createAgentConfigurationEntry(String.valueOf(LauncherConstants.ANALYSIS_TYPE_ASSOCIATION) + "(" + id + ")", id);
        if (agent != null) {
            agent.getConfiguration().addEntry(entry);
        }
        return entry;
    }

    public static Hashtable validateLaunchItems(Hashtable selectedLaunchItems, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        DataCollectorManager dataCollectorManager = DataCollectorManager.getInstance();
        Enumeration dataCollectors = selectedLaunchItems.keys();
        Hashtable<IDataCollectorBaseLauncher, String> delegateCollectorAssociation = new Hashtable<IDataCollectorBaseLauncher, String>();
        while (dataCollectors.hasMoreElements()) {
            DataCollector dataCollector = (DataCollector)dataCollectors.nextElement();
            IDataCollectorBaseLauncher dataCollectorLaunchDelegate = dataCollectorManager.getDataCollectorLaunchDelegate(dataCollector.getId(), configuration);
            if (dataCollectorLaunchDelegate == null) {
                LauncherUtility.openWarningWithDetail(LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, NLS.bind((String)LauncherMessages.WARNING_DCM_UNRESOLVED_DELEGATE, (Object)dataCollector.getId()), null);
                continue;
            }
            delegateCollectorAssociation.put(dataCollectorLaunchDelegate, dataCollector.getId());
            DataCollectorAssociationData associationData = LauncherUtility.findDataCollectorAssociationData(configuration, dataCollector);
            if (associationData != null && !LauncherUtility.continueLaunch(associationData.getValidator(), configuration, monitor)) {
                return null;
            }
            ArrayList analysisTypes = (ArrayList)selectedLaunchItems.get(dataCollector);
            int i = 0;
            int analysisTypeCount = analysisTypes.size();
            while (i < analysisTypeCount) {
                Object currentType = analysisTypes.get(i);
                if (currentType instanceof AnalysisType && !LauncherUtility.continueLaunch(((AnalysisType)currentType).getValidator(), configuration, monitor)) {
                    return null;
                }
                ++i;
            }
        }
        return delegateCollectorAssociation;
    }

    public static boolean continueLaunch(ILaunchValidator validator, ILaunchConfiguration configuration, IProgressMonitor monitor) {
        int severity;
        if (validator == null) {
            return true;
        }
        IStatus status = validator.launchNotification(configuration);
        if (status == null || (severity = status.getSeverity()) == 0) {
            return true;
        }
        LauncherUtility.openMessageWithDetail(status.getSeverity(), "", status.getMessage(), status.getException());
        if (severity == 4) {
            monitor.setCanceled(true);
            return false;
        }
        return true;
    }

    public static ArrayList delegateInit(ArrayList launchDelegates, ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<IDataCollectorBaseLauncher> mutualLaunchDelegates = new ArrayList<IDataCollectorBaseLauncher>();
        int i = 0;
        int delegateCount = launchDelegates.size();
        while (i < delegateCount) {
            IDataCollectorBaseLauncher currentDelegate = (IDataCollectorBaseLauncher)launchDelegates.get(i);
            if (currentDelegate.isMutualLauncher()) {
                ((IDataCollectorMutualLauncher)currentDelegate).preLaunch(conf, mode, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                mutualLaunchDelegates.add(currentDelegate);
            } else {
                ((IDataCollectorSelfManageableLauncher)currentDelegate).launch(conf, mode, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            ++i;
        }
        return mutualLaunchDelegates;
    }

    public static IWorkingSet[] getActiveWorkingSets() {
        class GetActiveWorkbenchWindowRunnable
        implements Runnable {
            private IWorkbenchWindow window;

            GetActiveWorkbenchWindowRunnable() {
            }

            public IWorkbenchWindow getActiveWorkbenchWindow() {
                return this.window;
            }

            public void run() {
                this.window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            }
        }
        GetActiveWorkbenchWindowRunnable runnable = new GetActiveWorkbenchWindowRunnable();
        Display.getDefault().syncExec((Runnable)runnable);
        IWorkbenchWindow workbenchWindow = runnable.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        return activePage.getWorkingSets();
    }

    public static void storeAutogeneratedFilterSet(ArrayList filters) {
        String gereratedFilterSetName = "auto_generated_filter_set";
        ArrayList filtersSetList = TraceFilterManager.getInstance().getFilterSetCopy();
        FilterSetElement generatedFilterSet = null;
        int i = 0;
        while (i < filtersSetList.size()) {
            FilterSetElement filterSet = (FilterSetElement)filtersSetList.get(i);
            if (gereratedFilterSetName.equals(filterSet.getName())) {
                generatedFilterSet = filterSet;
                break;
            }
            ++i;
        }
        if (generatedFilterSet == null) {
            generatedFilterSet = new FilterSetElement(gereratedFilterSetName);
            generatedFilterSet.setName(gereratedFilterSetName);
            filtersSetList.add(generatedFilterSet);
        }
        FilterTableElement finalFilter = new FilterTableElement("*", "*", "EXCLUDE");
        filters.add(finalFilter);
        generatedFilterSet.setChildren(filters);
        TraceFilterManager.getInstance().storeFilterSetList(filtersSetList);
    }

    public static void removeAutogeneratedFilterSet() {
        ArrayList filtersSetList = TraceFilterManager.getInstance().getFilterSetCopy();
        int i = 0;
        while (i < filtersSetList.size()) {
            FilterSetElement filterSet = (FilterSetElement)filtersSetList.get(i);
            if ("auto_generated_filter_set".equals(filterSet.getName())) {
                filtersSetList.remove(i);
                break;
            }
            ++i;
        }
        TraceFilterManager.getInstance().storeFilterSetList(filtersSetList);
    }

    public static boolean isAutoFilteringCriteria(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, false);
    }

    public static ILaunchConfiguration addExtendedConfigurationDefaults(ILaunchConfiguration config) {
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            boolean autoFilteringCriteriaDefault = store.getBoolean("auto_filter_criteria");
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, autoFilteringCriteriaDefault);
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, manager.getDefaultSet() == null ? null : manager.getDefaultSet().getId());
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, autoFilteringCriteriaDefault ? "auto_generated_filter_set" : "org.eclipse.hyades.trace.ui.filterSet.default");
            return wc.doSave();
        }
        catch (CoreException coreException) {
            return config;
        }
    }

    public static File getFileInPlugin(IPath path) {
        try {
            URL installURL = new URL(Platform.getBundle((String)"org.eclipse.jdt.launching").getEntry("/"), path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SelectedAgent[] retrieveSelectedAgents(ILaunchConfiguration configuration) throws CoreException {
        String selection = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, "");
        StringTokenizer selectedItems = new StringTokenizer(selection, ";");
        ArrayList<SelectedAgent> selectedAgents = new ArrayList<SelectedAgent>();
        while (selectedItems.hasMoreTokens()) {
            String selectedItem = selectedItems.nextToken();
            SelectedAgent agentAttribute = new SelectedAgent(selectedItem);
            if (agentAttribute.getPid() == null || agentAttribute.getCollectorId() == null) continue;
            selectedAgents.add(agentAttribute);
        }
        return selectedAgents.toArray(new SelectedAgent[selectedAgents.size()]);
    }

    public static void addLaunchConfigId(TRCProcessProxy processProxy, String launchConfigId) {
        TRCEnvironmentVariable variable = HierarchyFactory.eINSTANCE.createTRCEnvironmentVariable();
        variable.setName("org.eclipse.tptp.platform.common.ui.trace.LAUNCH_CONFIGURATION_ID");
        variable.setValue(launchConfigId);
        processProxy.getEnvironmentVariables().add((Object)variable);
    }

    public static class JUnitConfigurationExtended
    extends JUnitLaunchConfigurationDelegate {
        private IVMRunner runner;
        private VMRunnerConfiguration configuration;

        public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
            if (this.runner == null) {
                this.runner = new IVMRunner(){

                    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
                        JUnitConfigurationExtended.this.configuration = configuration;
                    }
                };
            }
            return this.runner;
        }

        public VMRunnerConfiguration getVMRunnerConfiguration() {
            return this.configuration;
        }
    }
}

