/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileUIManager;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AgentDiscovererConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.IDiscovererLaunchConfConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class AgentDiscovererDelegateHelper {
    public static String LAD_NAME = "Agent Discoverer";
    public static String LAD_TYPE = "org.eclipse.tptp.trace.ui.loggingAgentDiscoverer";

    public static Process createProcess(Node node) {
        CustomProcess process = new CustomProcess(node);
        if (node instanceof NodeImpl) {
            process.addProcessListener(((NodeImpl)node).getProcessListener());
        }
        try {
            process.setExecutable("java.exe");
        }
        catch (ProcessActiveException e) {
            e.printStackTrace();
        }
        return process;
    }

    public static void registerProcessListener(Process process, final TRCProcessProxy trcProcessProxy, final DynamicAgentDiscoverer dynamicDiscoverer, final ILoggingAgentDiscovererDelegate logAgentDiscoverer) {
        try {
            process.addProcessListener(new ProcessListener(){

                public void processLaunched(Process process) {
                    dynamicDiscoverer.start();
                    logAgentDiscoverer.activateAgent(trcProcessProxy);
                }

                public void processExited(Process process) {
                    dynamicDiscoverer.terminate();
                }
            });
        }
        catch (Exception e) {
            LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_LOG_DISCOVER_INITIALIZE, e);
        }
    }

    public static void activateAgent(TRCProcessProxy processProxy, TRCAgentProxy agentProxy) {
        agentProxy.setAttached(true);
        agentProxy.setActive(true);
        agentProxy.setMonitored(true);
        LauncherUtility.sendProfileEvent(1, agentProxy);
    }

    public static class CustomProcess
    extends ProcessImpl {
        public CustomProcess(Node node) {
            super(node);
        }

        public void handleCommand(CommandElement command) {
            super.handleCommand(command);
        }
    }

    public static class DummyAgent
    extends AgentImpl {
        public DummyAgent(Process process) {
            super(process, LAD_NAME);
            this.setType(LAD_TYPE);
        }
    }

    public static class DynamicAgentDiscoverer
    implements Runnable {
        private static final int INCREMENTAL_WAIT = 100;
        private static final int TOTAL_INC_WAIT = 34;
        private Process process;
        private TRCProcessProxy trcProcessProxy;
        private TRCAgentProxy trcAgentProxy;
        private long processId;
        private boolean enabled;
        private Hashtable agentBlackList;
        private QueryCommandHandler queryCommandHandler;
        private Hashtable lastAgentList;
        private long frequency;
        private AgentDiscovererConfiguration.AgentDiscovererFilterEntry[] filters;
        private boolean messageProcessed;

        public DynamicAgentDiscoverer(ILaunchConfiguration conf, Process process, TRCProcessProxy trcProcessProxy) {
            block3: {
                this.process = process;
                this.trcProcessProxy = trcProcessProxy;
                this.queryCommandHandler = new QueryCommandHandler();
                this.frequency = -1L;
                this.filters = null;
                try {
                    this.frequency = conf.getAttribute(IDiscovererLaunchConfConstants.ATTR_OPT_FREQUENCY, 500);
                    this.filters = AgentDiscovererConfiguration.unserializeFilters(conf.getAttribute(IDiscovererLaunchConfConstants.ATTR_FILTER, ".*,1"));
                }
                catch (CoreException coreException) {
                    if (this.frequency == -1L) {
                        this.frequency = 500L;
                    }
                    if (this.filters != null) break block3;
                    this.filters = AgentDiscovererConfiguration.unserializeFilters(".*,1");
                }
            }
        }

        public void setAgentProxy(TRCAgentProxy trcAgentProxy) {
            this.trcAgentProxy = trcAgentProxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            this.enabled = false;
            if (this.trcAgentProxy != null) {
                this.trcAgentProxy.setActive(false);
                this.trcAgentProxy.getProcessProxy().setActive(false);
                LauncherUtility.sendProfileEvent(16, this.trcAgentProxy);
            }
            DynamicAgentDiscoverer dynamicAgentDiscoverer = this;
            synchronized (dynamicAgentDiscoverer) {
                this.notify();
            }
        }

        public void start() {
            try {
                this.processId = Long.parseLong(this.process.getProcessId());
            }
            catch (InactiveProcessException e) {
                LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_LOG_DISCOVER_INITIALIZE, e);
                return;
            }
            this.enabled = true;
            new Thread((Runnable)this, "Query Agents").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.enabled) {
                try {
                    if (this.trcAgentProxy != null && this.trcAgentProxy.isMonitored()) {
                        this.discoverLogAgents();
                    }
                    DynamicAgentDiscoverer dynamicAgentDiscoverer = this;
                    synchronized (dynamicAgentDiscoverer) {
                        this.wait(this.frequency);
                    }
                }
                catch (Throwable t) {
                    LauncherUtility.openErrorWithDetail("", t.getMessage(), t);
                    this.terminate();
                    break;
                }
            }
        }

        private void discoverLogAgents() {
            try {
                if (!this.isProcessAlive()) {
                    this.terminate();
                    if (this.process instanceof CustomProcess) {
                        ProcessExitedCommand pec = new ProcessExitedCommand();
                        pec.setProcessId(this.processId);
                        ((CustomProcess)this.process).handleCommand((CommandElement)pec);
                    }
                    return;
                }
                List availableAgents = this.queryAvailableAgents();
                if (availableAgents == null) {
                    return;
                }
                int i = 0;
                int agentSize = availableAgents.size();
                while (i < agentSize) {
                    Agent currentAgent = (Agent)availableAgents.get(i);
                    if (!currentAgent.getType().equals(LAD_TYPE) && !currentAgent.isAttached() && this.agentIsIncluded(currentAgent)) {
                        try {
                            final TRCAgentProxy loggingAgent = PDCoreUtil.attachToAgent(this.trcProcessProxy, currentAgent);
                            PDCoreUtil.doAttach(currentAgent, loggingAgent);
                            UIPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    ProfileUIManager.getInstance().startMonitoring(loggingAgent);
                                }
                            });
                        }
                        catch (Exception e) {
                            LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, NLS.bind((String)LauncherMessages.ERROR_LOG_DISCOVER_ATTACH, (Object)currentAgent.getName()), e);
                            this.addToBlackList(currentAgent);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e1) {
                LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_LOG_DISCOVER_UNEXPECTED, e1);
                this.terminate();
            }
        }

        private void addToBlackList(Agent currentAgent) {
            if (this.agentBlackList == null) {
                this.agentBlackList = new Hashtable();
            }
            this.agentBlackList.put(String.valueOf(currentAgent.getName()) + currentAgent.getType(), Boolean.TRUE);
        }

        private boolean agentIsIncluded(Agent currentAgent) {
            String agentName = currentAgent.getName();
            String agentType = currentAgent.getType();
            if (this.agentBlackList != null && this.agentBlackList.get(String.valueOf(agentName) + agentType) != null) {
                return false;
            }
            boolean included = false;
            int i = 0;
            while (i < this.filters.length) {
                int match = this.filters[i].match(agentName);
                boolean bl = included = match == 0;
                if (included || match == 1) break;
                ++i;
            }
            if (!included) {
                this.addToBlackList(currentAgent);
            }
            return included;
        }

        private boolean isProcessAlive() throws IOException, InactiveProcessException {
            ControlMessage message = new ControlMessage();
            QueryProcessListCommand qplCommand = new QueryProcessListCommand();
            message.appendCommand((CommandElement)qplCommand);
            this.sendMessage(this.process.getNode().getConnection(), message);
            if (!this.messageProcessed) {
                return false;
            }
            long[] pids = this.queryCommandHandler.getAvailableProcesses();
            if (pids == null) {
                return false;
            }
            int i = 0;
            while (i < pids.length) {
                if (pids[i] == this.processId) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private List queryAvailableAgents() throws InactiveProcessException, IOException {
            Connection connection = this.process.getNode().getConnection();
            ControlMessage message = new ControlMessage();
            QueryAgentListCommand qalCommand = new QueryAgentListCommand();
            qalCommand.setProcessId(this.processId);
            message.appendCommand((CommandElement)qalCommand);
            this.sendMessage(connection, message);
            if (!this.messageProcessed) {
                return null;
            }
            Hashtable eAgents = this.queryCommandHandler.getAgentsMetaInfo();
            if (eAgents.size() == 0 || this.listEqual(this.lastAgentList, eAgents)) {
                return null;
            }
            this.lastAgentList = eAgents;
            this.queryCommandHandler.getAvailableAgents().clear();
            Enumeration availableAgents = eAgents.keys();
            while (availableAgents.hasMoreElements()) {
                String agentName = (String)availableAgents.nextElement();
                if (agentName.equals(LAD_NAME)) continue;
                message = new ControlMessage();
                QueryAgentDetailsCommand qadCommand = new QueryAgentDetailsCommand();
                qadCommand.setProcessId(this.processId);
                qadCommand.setAgentName(agentName);
                message.appendCommand((CommandElement)qadCommand);
                this.sendMessage(connection, message);
            }
            if (!this.messageProcessed) {
                return null;
            }
            return this.queryCommandHandler.getAvailableAgents();
        }

        private boolean listEqual(Hashtable agentList1, Hashtable agentList2) {
            int agentListSize2;
            if (agentList1 == null && agentList2 != null || agentList1 != null && agentList2 == null) {
                return false;
            }
            int agentListSize1 = agentList1.size();
            if (agentListSize1 != (agentListSize2 = agentList2.size())) {
                return false;
            }
            Enumeration agentNames = agentList1.keys();
            while (agentNames.hasMoreElements()) {
                String currentAgentName = (String)agentNames.nextElement();
                if (agentList2.get(currentAgentName) != null) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(Connection connection, ControlMessage message) throws IOException {
            this.messageProcessed = false;
            connection.sendMessage(message, (CommandHandler)this.queryCommandHandler);
            for (int waitCounter = 0; waitCounter < 34 && !this.messageProcessed; ++waitCounter) {
                DynamicAgentDiscoverer dynamicAgentDiscoverer = this;
                synchronized (dynamicAgentDiscoverer) {
                    try {
                        this.wait(100L);
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        }

        public class QueryCommandHandler
        implements CommandHandler {
            private Hashtable agentMetaData = new Hashtable();
            private List availableAgents = new ArrayList();
            private long[] availableProcesses;

            public void incommingCommand(Node node, CommandElement command) {
                int tag = (int)command.getTag();
                switch (tag) {
                    case 33: {
                        RegisteredProcessListCommand rplCmd = (RegisteredProcessListCommand)command;
                        this.availableProcesses = rplCmd.getProcessList();
                        break;
                    }
                    case 34: {
                        String[] agentNames;
                        this.agentMetaData.clear();
                        ActiveAgentListCommand aalCmd = (ActiveAgentListCommand)command;
                        long processId = aalCmd.getProcessId();
                        if (processId != DynamicAgentDiscoverer.this.processId || (agentNames = aalCmd.getAgents()) == null) break;
                        int i = 0;
                        while (i < agentNames.length) {
                            this.agentMetaData.put(agentNames[i], Boolean.TRUE);
                            ++i;
                        }
                        break;
                    }
                    case 40: {
                        AgentDetailsCommand adCmd = (AgentDetailsCommand)command;
                        long processId = adCmd.getProcessId();
                        if (processId != DynamicAgentDiscoverer.this.processId) break;
                        String agentName = adCmd.getAgentName();
                        String agentType = adCmd.getAgentType();
                        String agentUUID = adCmd.getAgentUUID();
                        Agent ag = DynamicAgentDiscoverer.this.process.getAgent(agentName);
                        if (ag == null) {
                            ag = AgentFactory.createAgent((Process)DynamicAgentDiscoverer.this.process, (String)agentName);
                            ag.setActive(true);
                            ag.setType(agentType);
                            ag.setUUID(agentUUID);
                            ag.addAgentListener((AgentListener)((ProcessImpl)DynamicAgentDiscoverer.this.process));
                        }
                        this.availableAgents.add(ag);
                    }
                }
                DynamicAgentDiscoverer.this.messageProcessed = true;
            }

            public long[] getAvailableProcesses() {
                return this.availableProcesses;
            }

            public Hashtable getAgentsMetaInfo() {
                return (Hashtable)this.agentMetaData.clone();
            }

            public List getAvailableAgents() {
                return this.availableAgents;
            }
        }
    }

    public static interface ILoggingAgentDiscovererDelegate {
        public void activateAgent(TRCProcessProxy var1);
    }
}

