/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.IJVMVersionDetector;

public class DefaultJVMVersionDetector
implements IJVMVersionDetector {
    public static final long TIMEOUT = 5000L;
    private JVMVersionProcessor dataProcessor = new JVMVersionProcessor();
    private Process process;
    private static Object connectionLock = new Object();
    private static Connection lastConnection = null;
    private static String lastConnectionVersion = null;

    public static synchronized DefaultJVMVersionDetector getInstance() {
        return new DefaultJVMVersionDetector();
    }

    private DefaultJVMVersionDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJVMVersion(String host, int port) {
        String jvmVersion = null;
        Node node = this.connect(host, port);
        if (node == null || !node.isConnected()) {
            return "";
        }
        Object object = connectionLock;
        synchronized (object) {
            if (node.getConnection() != null && lastConnection != null && lastConnection.equals(node.getConnection())) {
                return lastConnectionVersion;
            }
        }
        if (this.launchJVM(node)) {
            object = this.dataProcessor;
            synchronized (object) {
                if (this.dataProcessor.getOutput().length() == 0) {
                    try {
                        this.dataProcessor.wait(5000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.close();
        jvmVersion = this.dataProcessor.getOutput();
        object = connectionLock;
        synchronized (object) {
            lastConnection = node.getConnection();
            lastConnectionVersion = jvmVersion;
        }
        return jvmVersion;
    }

    private Node connect(String host, int port) {
        Node node;
        try {
            host = "localhost".equals(host) ? InetAddress.getLocalHost().getHostName() : host;
            node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(port), (boolean)false);
        }
        catch (Exception exception) {
            node = null;
        }
        return node;
    }

    private boolean launchJVM(Node node) {
        boolean r;
        if (node == null || !node.isConnected()) {
            return false;
        }
        try {
            this.dataProcessor.clear();
            this.process = ProcessFactory.createProcess((Node)node);
            this.process.setExecutable("java.exe");
            this.process.setParameters(" -version");
            this.process.getConsole().setDataProcessor((DataProcessor)this.dataProcessor);
            this.process.launch();
            r = true;
        }
        catch (Exception exception) {
            r = false;
        }
        return r;
    }

    private void close() {
        if (this.process == null) {
            return;
        }
        Console console = this.process.getConsole();
        if (console != null) {
            console.close();
        }
    }

    class JVMVersionProcessor
    implements DataProcessor {
        private StringBuffer output = new StringBuffer();

        JVMVersionProcessor() {
        }

        public void incommingData(byte[] buffer, int length, InetAddress peer) {
            this.appendOutput(new String(buffer, 0, length));
        }

        public void incommingData(char[] buffer, int length, InetAddress peer) {
            this.appendOutput(new String(buffer, 0, length));
        }

        public void invalidDataType(byte[] data, int length, InetAddress peer) {
        }

        public void waitingForData() {
        }

        private synchronized void appendOutput(String buffer) {
            this.output.append(buffer);
            this.notifyAll();
        }

        public String getOutput() {
            return this.output.toString();
        }

        public void clear() {
            this.output.setLength(0);
        }
    }
}

