/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IExtendedProfilingType;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.DefaultJVMVersionDetector;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.IJVMVersionDetector;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;

public class PIDelegateHelper {
    private static IJVMVersionDetector jvmVersionDetector;

    public static PIProcessListener configureProcess(Process process, TRCProcessProxy trcProcessProxy, ILaunchConfiguration conf, String classpath) throws CoreException {
        PIProcessListener listener = new PIProcessListener(trcProcessProxy.getNode(), trcProcessProxy);
        listener.monitor(true);
        process.addProcessListener((ProcessListener)listener);
        listener.setLaunchMode(1);
        listener.setAutoMonitoring(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true));
        listener.getProcessVariableList().add(new Variable("UICLASSPATH", classpath));
        PDCoreUtil.setEnvironmentVariable(process, ProfileLaunchUtil.getEnvironmentVariables(conf), listener);
        return listener;
    }

    public static Agent createAgent(ILaunchConfiguration conf, Process process, TRCProcessProxy trcProcessProxy, String agentName, String agentType, String profileFile, PIProcessListener listener) throws CoreException {
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        Vector options = manager.getOptions(conf);
        Agent agent = PDCoreUtil.createAgent(process, manager.getFilters(conf), options, trcProcessProxy, agentName, agentType);
        if (profileFile != null) {
            agent.setProfileFile(profileFile);
        }
        agent.addAgentListener((AgentListener)listener);
        listener.addAgent(agent);
        AgentConfigurationEntry[] confEntries = PeriodicPoll.getOption(options, new String[]{IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ});
        String[] pollingOptions = new String[3];
        int i = 0;
        while (i < confEntries.length) {
            pollingOptions[i] = confEntries[i] == null ? null : confEntries[i].getValue();
            ++i;
        }
        PeriodicPoll periodicPoll = PeriodicPoll.createInstance(pollingOptions, trcProcessProxy, listener, agent);
        if (periodicPoll != null) {
            periodicPoll.start();
        }
        return agent;
    }

    public static ProcessParameters getProcessParameter(ProcessParameters processParameters, ILaunchConfiguration conf) {
        processParameters.addExecutableParameter(PDCoreUtil.getPIVMArgument((byte)1));
        Hashtable hashTable = LauncherUtility.unserializeSelection(conf);
        if (hashTable == null) {
            return processParameters;
        }
        Enumeration dataCollectorKeys = hashTable.keys();
        while (dataCollectorKeys.hasMoreElements()) {
            DataCollector dataCollector = (DataCollector)dataCollectorKeys.nextElement();
            if (!dataCollector.getId().equals("org.eclipse.tptp.trace.ui.jvmpiMechanism")) continue;
            List valueList = (List)hashTable.get(dataCollector);
            int i = 0;
            while (i < valueList.size()) {
                IProfilingType profilingType;
                ProfilingSetType profilingSetType;
                if (valueList.get(i) instanceof ProfilingSetType && (profilingSetType = (ProfilingSetType)valueList.get(i)).getId().equals("org.eclipse.tptp.probekit.ui.ProbekitProfilingType") && (profilingType = profilingSetType.getProfilingType()) instanceof IExtendedProfilingType) {
                    processParameters.addExecutableParameter(((IExtendedProfilingType)profilingType).getVMArguments(conf));
                }
                ++i;
            }
        }
        return processParameters;
    }

    public static void setJvmVersionDetector(IJVMVersionDetector jvmVersionDetector) {
        PIDelegateHelper.jvmVersionDetector = jvmVersionDetector;
    }

    public static class JVMVersionDetector {
        private String host;
        private int port;

        public JVMVersionDetector(final ILaunchConfiguration configuration) {
            UIPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        JVMVersionDetector.this.host = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
                        JVMVersionDetector.this.port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, CommonUIPlugin.getDefault().getPreferenceStore().getDefaultInt("localhost_port"));
                    }
                    catch (CoreException e) {
                        UIPlugin.getDefault().log(e);
                    }
                }
            });
        }

        public JVMVersionDetector(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String retrieveVersionOutput() {
            String ver;
            if (jvmVersionDetector != null && (ver = jvmVersionDetector.getJVMVersion(this.host, this.port)) != null && ver.length() > 0) {
                return ver;
            }
            return DefaultJVMVersionDetector.getInstance().getJVMVersion(this.host, this.port);
        }
    }

    public static class PeriodicPoll
    extends Thread {
        private static final int INCOMING_EVENTS_THRESHOLD = 3072;
        private static final int INCREMENTAL_UNIT = 10;
        private double pollFrequency;
        private boolean isAutomated;
        private TRCProcessProxy processProxy;
        private Agent agent;
        private PIProcessListener listener;
        private boolean isProcessTerminated;

        public static PeriodicPoll createInstance(String[] options, TRCProcessProxy trcProcessProxy, PIProcessListener listener, Agent agent) {
            if (options[0] != null && "false".equalsIgnoreCase(options[0])) {
                boolean isPollAutomatic;
                boolean bl = isPollAutomatic = options[1] == null || "true".equalsIgnoreCase(options[1]);
                if (isPollAutomatic) {
                    return new PeriodicPoll(trcProcessProxy, listener, agent);
                }
                int pollingFrequency = options[2] == null ? 10 : Integer.parseInt(options[2]);
                return new PeriodicPoll(trcProcessProxy, listener, agent, pollingFrequency);
            }
            return null;
        }

        private PeriodicPoll(TRCProcessProxy processProxy, PIProcessListener listener, Agent agent) {
            this(processProxy, listener, agent, 10);
            this.isAutomated = true;
        }

        private PeriodicPoll(TRCProcessProxy processProxy, PIProcessListener listener, Agent agent, int pollingFrequency) {
            this.processProxy = processProxy;
            this.listener = listener;
            this.agent = agent;
            this.pollFrequency = pollingFrequency;
            this.isAutomated = false;
            agent.getProcess().addProcessListener(new ProcessListener(){

                public void processExited(Process process) {
                    PeriodicPoll.this.isProcessTerminated = true;
                }

                public void processLaunched(Process process) {
                }
            });
        }

        public void run() {
            while (!this.isProcessTerminated && this.agent != null) {
                int lastEventSize;
                boolean isMonitored = this.agent.isMonitored();
                if (isMonitored) {
                    try {
                        Node node;
                        TRCNode trcNode = this.processProxy.getNode();
                        if (trcNode == null || (node = PDCoreUtil.profileConnect((String)trcNode.getName(), (String)String.valueOf(trcNode.getPort()))) == null) break;
                        CustomCommand command = new CustomCommand();
                        command.setData("COLLECTDATA");
                        this.agent.invokeCustomCommand(command);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        break;
                    }
                }
                try {
                    Thread.sleep((long)(Math.ceil(this.pollFrequency) * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
                if (!isMonitored || !this.isAutomated || this.listener.getDataProcessor() == null || (lastEventSize = this.listener.getDataProcessor().getSizeOfLastEvent()) <= 0) continue;
                this.pollFrequency += Math.ceil((double)(3072 - lastEventSize) / 3072.0 * 10.0);
                if (this.pollFrequency < 1.0) {
                    this.pollFrequency = 1.0;
                } else if (this.pollFrequency > 120.0) {
                    this.pollFrequency = 120.0;
                }
                this.listener.getDataProcessor().resetStats();
            }
        }

        public static AgentConfigurationEntry[] getOption(Vector options, String[] optionKeys) {
            AgentConfigurationEntry[] confEntries = new AgentConfigurationEntry[optionKeys.length];
            Hashtable<String, Integer> optionKeysHash = new Hashtable<String, Integer>();
            int i = 0;
            while (i < optionKeys.length) {
                optionKeysHash.put(optionKeys[i++], new Integer(i - 1));
            }
            i = 0;
            int optionsCount = options.size();
            while (i < optionsCount) {
                AgentConfigurationEntry currentConfEntry = (AgentConfigurationEntry)options.get(i);
                Integer inx = (Integer)optionKeysHash.get(currentConfEntry.getName());
                if (inx != null) {
                    confEntries[inx.intValue()] = currentConfEntry;
                }
                ++i;
            }
            return confEntries;
        }
    }
}

