/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ProcessControlProvider;

public abstract class AbstractAgentControlProvider
extends ProcessControlProvider {
    public static final String ATTACH_ITEM = "org.eclipse.hyades.trace.ui.internal.popupMenu.AttachAction";
    public static final String DETACH_ITEM = "org.eclipse.hyades.trace.ui.internal.popupMenu.DetachAction";
    public static final String START_MONITORING = "org.eclipse.hyades.trace.ui.internal.monitorsview.popupMenu.startMonitoring";
    public static final String PAUSE_MONITORING = "org.eclipse.hyades.trace.ui.internal.popupMenu.stopMonitoring";
    private IControlItem attachItem;
    private IControlItem detachItem;
    private IControlItem resumeItem;
    private IControlItem pauseItem;

    protected void initializeControlItems() {
        super.initializeControlItems();
        this.addControlItem(this.createAttachControlItem());
        this.addControlItem(this.createDetachControlItem());
        this.addControlItem(this.createStartMonitoringControlItem());
        this.addControlItem(this.createPauseMonitoringControlItem());
    }

    public abstract IAgentStateModifier getAgentStateModifier();

    protected IControlItem createAttachControlItem() {
        if (this.attachItem != null) {
            return this.attachItem;
        }
        class AttachControlItem
        extends AgentControlItem {
            public AttachControlItem() {
                super(AbstractAgentControlProvider.this.getAgentStateModifier(), AbstractAgentControlProvider.ATTACH_ITEM, "attachGroup", ControlMessages.CONTROL_ITEM_ATTACH, TraceUIImages.INSTANCE.getImageDescriptor("c", "detachAgent.gif"));
                this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "attachAgent.gif"));
            }

            public void run() {
                IAgentStateModifier agentStateModifier = AbstractAgentControlProvider.this.getAgentStateModifier();
                try {
                    agentStateModifier.attach();
                }
                catch (CoreException e) {
                    LauncherUtility.openMessageWithDetail(e.getStatus().getSeverity(), "", e.getMessage(), e);
                }
            }

            public boolean isEnabled() {
                return AbstractAgentControlProvider.this.getAgentStateModifier().canAttach();
            }
        }
        this.attachItem = new AttachControlItem();
        return this.attachItem;
    }

    protected IControlItem createDetachControlItem() {
        if (this.detachItem != null) {
            return this.detachItem;
        }
        class DetachControlItem
        extends AgentControlItem {
            public DetachControlItem() {
                super(AbstractAgentControlProvider.this.getAgentStateModifier(), AbstractAgentControlProvider.DETACH_ITEM, "attachGroup", ControlMessages.CONTROL_ITEM_DETACH, TraceUIImages.INSTANCE.getImageDescriptor("c", "detachAgent.gif"));
                this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "detachAgent.gif"));
            }

            public void run() {
                IAgentStateModifier agentStateModifier = AbstractAgentControlProvider.this.getAgentStateModifier();
                try {
                    agentStateModifier.detach();
                }
                catch (CoreException e) {
                    LauncherUtility.openMessageWithDetail(e.getStatus().getSeverity(), "", e.getMessage(), e);
                }
            }

            public boolean isEnabled() {
                return AbstractAgentControlProvider.this.getAgentStateModifier().canDetach();
            }
        }
        this.detachItem = new DetachControlItem();
        return this.detachItem;
    }

    protected IControlItem createStartMonitoringControlItem() {
        if (this.resumeItem != null) {
            return this.resumeItem;
        }
        class ResumeControlItem
        extends AgentControlItem {
            public ResumeControlItem() {
                super(AbstractAgentControlProvider.this.getAgentStateModifier(), AbstractAgentControlProvider.START_MONITORING, "monitoringGroup", ControlMessages.CONTROL_ITEM_RESUME, TraceUIImages.INSTANCE.getImageDescriptor("c", "resume_co.gif"));
                this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "resume_co.gif"));
            }

            public void run() {
                IAgentStateModifier agentStateModifier = AbstractAgentControlProvider.this.getAgentStateModifier();
                if (agentStateModifier.canDetach()) {
                    try {
                        agentStateModifier.startMonitoring();
                    }
                    catch (CoreException e) {
                        LauncherUtility.openMessageWithDetail(e.getStatus().getSeverity(), "", e.getMessage(), e);
                    }
                } else {
                    try {
                        agentStateModifier.attach();
                    }
                    catch (CoreException e) {
                        LauncherUtility.openMessageWithDetail(e.getStatus().getSeverity(), "", e.getMessage(), e);
                    }
                }
            }

            public boolean isEnabled() {
                if (AbstractAgentControlProvider.this.getAgentStateModifier().canDetach()) {
                    return AbstractAgentControlProvider.this.getAgentStateModifier().canResume();
                }
                return AbstractAgentControlProvider.this.getAgentStateModifier().canAttach();
            }
        }
        this.resumeItem = new ResumeControlItem();
        return this.resumeItem;
    }

    protected IControlItem createPauseMonitoringControlItem() {
        if (this.pauseItem != null) {
            return this.pauseItem;
        }
        class PauseControlItem
        extends AgentControlItem {
            public PauseControlItem() {
                super(AbstractAgentControlProvider.this.getAgentStateModifier(), AbstractAgentControlProvider.PAUSE_MONITORING, "monitoringGroup", ControlMessages.CONTROL_ITEM_PAUSE, TraceUIImages.INSTANCE.getImageDescriptor("c", "suspend_co.gif"));
                this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "suspend_co.gif"));
            }

            public void run() {
                IAgentStateModifier agentStateModifier = AbstractAgentControlProvider.this.getAgentStateModifier();
                try {
                    agentStateModifier.pauseMonitoring();
                }
                catch (CoreException e) {
                    LauncherUtility.openMessageWithDetail(e.getStatus().getSeverity(), "", e.getMessage(), e);
                }
            }

            public boolean isEnabled() {
                return AbstractAgentControlProvider.this.getAgentStateModifier().canPause();
            }
        }
        this.pauseItem = new PauseControlItem();
        return this.pauseItem;
    }

    private static class AgentControlItem
    extends ControlItem {
        private IAgentStateModifier stateModifier;

        public AgentControlItem(IAgentStateModifier stateModifier, String itemId, String groupName, String text, ImageDescriptor imageDescriptor) {
            super(itemId, groupName, text, imageDescriptor);
            this.stateModifier = stateModifier;
        }

        public void setInput(StructuredSelection input) {
            this.stateModifier.setInput(input);
        }

        public IAgentStateModifier getStateModifier() {
            return this.stateModifier;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AgentControlItem)) {
                return false;
            }
            return this.stateModifier == ((AgentControlItem)o).getStateModifier() && super.equals(o);
        }
    }
}

