/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.internal.control.provider.TraceControlItemManager;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlProvider;

public abstract class AbstractControlProvider
implements IControlProvider {
    protected boolean isInputDifferent;
    protected boolean isContextDifferent;
    protected List controlItems = new ArrayList();
    protected StructuredSelection input;
    private INavigator context;

    public void initialize(String entity) {
    }

    public void setInput(StructuredSelection input) {
        if (!this.isInputSame(this.input, input)) {
            this.isInputDifferent = true;
            this.input = input;
        }
    }

    private boolean isInputSame(StructuredSelection firstInput, StructuredSelection secondInput) {
        if (firstInput == null || secondInput == null || firstInput.size() != secondInput.size()) {
            return false;
        }
        Iterator firstCollectionItems = firstInput.iterator();
        Iterator secondCollectionItems = secondInput.iterator();
        while (firstCollectionItems.hasNext()) {
            if (firstCollectionItems.next().equals(secondCollectionItems.next())) continue;
            return false;
        }
        return true;
    }

    public IControlItem[] createControlItems() {
        boolean bl = this.isContextDifferent = this.context != TraceControlItemManager.getNavigator();
        if (this.isInputDifferent || this.isContextDifferent) {
            this.context = TraceControlItemManager.getNavigator();
            this.initializeControlItems();
            int i = 0;
            int controlItemCount = this.controlItems.size();
            while (i < controlItemCount) {
                ((IControlItem)this.controlItems.get(i)).setInput(this.input);
                ++i;
            }
            this.isInputDifferent = false;
            this.isContextDifferent = false;
        }
        if (this.controlItems == null) {
            return null;
        }
        IControlItem[] controlItems = new IControlItem[this.controlItems.size()];
        this.controlItems.toArray(controlItems);
        return controlItems;
    }

    protected abstract void initializeControlItems();

    protected void addControlItem(IControlItem item) {
        if (item != null) {
            this.controlItems.add(item);
        }
    }

    public static class ControlItemAdapter
    extends ControlItem {
        private IAction action;
        private String groupName;

        public ControlItemAdapter(String groupName, IAction selectionProviderAction) {
            this.groupName = groupName;
            this.action = selectionProviderAction;
        }

        public IAction getAction() {
            return this.action;
        }

        public String getGroup() {
            return this.groupName;
        }

        public String getText() {
            return this.action.getText();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.action.getImageDescriptor();
        }

        public void run() {
            this.action.run();
        }
    }
}

