/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import java.util.Iterator;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.tptp.trace.ui.internal.control.provider.TraceControlItemManager;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.LogicalItemControlProvider;

public class ResourceItemControlProvider
extends LogicalItemControlProvider {
    private static final String REFRESH_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.popupMenu.refreshViews";
    private static final String REFRESH_OPTION = "org.eclipse.hyades.trace.ui.internal.monitorsview.popupMenu.refreshOption";
    private IControlItem delete;
    private IControlItem save;
    private IControlItem refresh;
    private IControlItem refreshOption;
    private IControlItem properties;
    private String entity;

    public void initialize(String entity) {
        super.initialize(entity);
        this.entity = entity;
    }

    protected void initializeControlItems() {
        super.initializeControlItems();
        this.addControlItem(this.createDeleteControlItem());
        this.addControlItem(this.createSaveControlItem());
        this.addControlItem(this.createRefreshViewsControlItem());
        this.addControlItem(this.createRefreshOptionControlItem());
        this.addControlItem(this.createPropertiesControlItem());
    }

    protected IControlItem createDeleteControlItem() {
        if (this.delete != null && !this.isContextDifferent) {
            return this.delete;
        }
        this.delete = new AbstractControlProvider.ControlItemAdapter("group.delete", (IAction)new DeleteAction(TraceControlItemManager.getNavigator()));
        return this.delete;
    }

    protected IControlItem createSaveControlItem() {
        if (this.save != null && !this.isContextDifferent) {
            return this.save;
        }
        this.save = new AbstractControlProvider.ControlItemAdapter("group.save", (IAction)new SaveAction(TraceControlItemManager.getNavigator()));
        return this.save;
    }

    protected IControlItem createRefreshViewsControlItem() {
        if (this.refresh != null) {
            return this.refresh;
        }
        class RefreshView
        extends ControlItem {
            public RefreshView() {
                super(ResourceItemControlProvider.REFRESH_ITEM, "refreshGroup", ControlMessages.CONTROL_ITEM_REFRESH_VIEWS, TraceUIImages.INSTANCE.getImageDescriptor("c", "updateviews_co.gif"));
            }

            public void run() {
                if (this.input == null) {
                    return;
                }
                Iterator sources = this.input.iterator();
                while (sources.hasNext()) {
                    ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent(sources.next());
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            }
        }
        this.refresh = new RefreshView();
        return this.refresh;
    }

    protected IControlItem createRefreshOptionControlItem() {
        if (this.refreshOption != null) {
            return this.refreshOption;
        }
        class RefreshOption
        extends ControlItem {
            public RefreshOption() {
                super(ResourceItemControlProvider.REFRESH_OPTION, "refreshGroup", ControlMessages.CONTROL_ITEM_REFRESH_OPTION, TraceUIImages.INSTANCE.getImageDescriptor("c", "message_options.gif"));
            }

            public void run() {
                if (this.input == null) {
                    return;
                }
                Iterator sources = this.input.iterator();
                while (sources.hasNext()) {
                    ProfileEvent event = UIPlugin.getDefault().getRefreshOptionEvent(sources.next());
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            }
        }
        this.refreshOption = new RefreshOption();
        return this.refreshOption;
    }

    protected IControlItem createPropertiesControlItem() {
        if (this.properties != null && !this.isContextDifferent) {
            return this.properties;
        }
        if (this.entity.equals("process")) {
            this.properties = new AbstractControlProvider.ControlItemAdapter("group.properties", (IAction)new OpenWizardAction((INavigator)((PDProjectExplorer)TraceControlItemManager.getNavigator()), OpenProcessWizard.class, UIPlugin.getResourceString(TraceMessages.PROP)));
        } else if (this.entity.equals("agent")) {
            this.properties = new AbstractControlProvider.ControlItemAdapter("group.properties", (IAction)new OpenWizardAction((INavigator)((PDProjectExplorer)TraceControlItemManager.getNavigator()), OpenProfAgentWizard.class, UIPlugin.getResourceString(TraceMessages.PROP)));
        }
        return this.properties;
    }

    public String getEntity() {
        return this.entity;
    }
}

