/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.OpenTraceViewAction;
import org.eclipse.hyades.trace.views.adapter.internal.PatternViewer;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenPatternViewAction
extends OpenTraceViewAction {
    private final String VIEW_ID = "org.eclipse.hyades.trace.views.adapter.internal.PatternViewer";

    public OpenPatternViewAction() {
        super("");
    }

    public OpenPatternViewAction(String label) {
        super(label);
    }

    public OpenPatternViewAction(String label, ImageDescriptor image) {
        super(label, image);
    }

    public void run() {
        IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage persp = UIPlugin.getActivePage();
            PatternViewer view = (PatternViewer)persp.showView("org.eclipse.hyades.trace.views.adapter.internal.PatternViewer");
            if (view != null) {
                view.addViewPage(this.getMofObject(), true);
            }
        }
        catch (Exception e) {
            Status err = new Status(2, "org.eclipse.core.resources", 566, TraceUIMessages._1, null);
            ErrorDialog.openError((Shell)window.getShell(), (String)TraceUIMessages._1, (String)e.toString(), (IStatus)err);
            e.printStackTrace();
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public String getViewID() {
        return "org.eclipse.hyades.trace.views.adapter.internal.PatternViewer";
    }

    private boolean isEnabledForObj(TRCAgentProxy obj) {
        TRCCollectionMode tcm = obj.getCollectionMode();
        if (tcm.getValue() == 2) {
            return true;
        }
        if (tcm.getValue() == 5) {
            return true;
        }
        if (tcm.getValue() == 8) {
            return true;
        }
        return tcm.getValue() == 6;
    }

    private boolean isEnabledForObj(TRCProcessProxy obj) {
        EList el = obj.getAgentProxies();
        for (TRCAgentProxy element : el) {
            if (!this.isEnabledForObj(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabledForObj(TRCNode obj) {
        EList el = obj.getProcessProxies();
        for (TRCProcessProxy element : el) {
            if (!this.isEnabledForObj(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabledForObj(TRCMonitor obj) {
        EList el = obj.getNodes();
        for (TRCNode element : el) {
            if (!this.isEnabledForObj(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabledForObject(Object obj) {
        EObject eo = this.getMofObject();
        if (eo instanceof TRCAgentProxy) {
            return this.isEnabledForObj((TRCAgentProxy)eo);
        }
        if (eo instanceof TRCProcessProxy) {
            return this.isEnabledForObj((TRCProcessProxy)eo);
        }
        if (eo instanceof TRCNode) {
            return this.isEnabledForObj((TRCNode)eo);
        }
        if (eo instanceof TRCMonitor) {
            return this.isEnabledForObj((TRCMonitor)eo);
        }
        return true;
    }
}

