/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

public abstract class ActiveFilter {
    private HashSet oneNameSet;
    private final String enabledKey;
    private final String disabledKey;

    public ActiveFilter(String enabledKey, String disabledKey) {
        this.enabledKey = enabledKey;
        this.disabledKey = disabledKey;
    }

    public String getEnabledKey() {
        return this.enabledKey;
    }

    public String getDisabledKey() {
        return this.disabledKey;
    }

    public abstract WhereExpression createDisabledExpression();

    public abstract WhereExpression createActiveExpression();

    public static boolean isFilterEnabled(ActiveFilter filter, SimpleSearchQuery query) {
        return filter.containsNamedSubexpression(query, filter.getEnabledKey());
    }

    public static boolean isFilterDisabled(ActiveFilter filter, SimpleSearchQuery query) {
        return filter.containsNamedSubexpression(query, filter.getDisabledKey());
    }

    protected WhereExpression getNamedSubexpression(WhereExpression we, String name) {
        return ActiveFilter.getNamedSubexpression(we, this.createSet(name));
    }

    protected static WhereExpression getNamedSubexpression(WhereExpression we, Set names) {
        if (names.contains(we.getName())) {
            return we;
        }
        if (we instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)we;
            EList subExpsessions = le.getArguments();
            int i = 0;
            while (i < subExpsessions.size()) {
                WhereExpression subExpression = (WhereExpression)subExpsessions.get(i);
                WhereExpression keyNamedSubexpression = ActiveFilter.getNamedSubexpression(subExpression, names);
                if (keyNamedSubexpression != null) {
                    return keyNamedSubexpression;
                }
                ++i;
            }
        }
        return null;
    }

    private Set createSet(String element) {
        if (this.oneNameSet == null) {
            this.oneNameSet = new HashSet(1);
        } else {
            this.oneNameSet.clear();
        }
        this.oneNameSet.add(element);
        return this.oneNameSet;
    }

    private boolean containsNamedSubexpression(SimpleSearchQuery query, String name) {
        if (name.equals(query.getName())) {
            return true;
        }
        WhereExpression whereExpression = query.getWhereExpression();
        if (whereExpression == null) {
            return false;
        }
        WhereExpression subexpression = this.getNamedSubexpression(whereExpression, name);
        return subexpression != null;
    }
}

