/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.ReferenceTable;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.IPage;

public class ReferenceTableViewer
extends FilterTraceViewer
implements IContextViewer {
    protected Action _openSource;
    protected Action _referee;
    protected Action _referands;
    protected Action _chooseColumns;
    protected Action _sortByColumn;
    protected ContextSelectionMenuListener _contextSelectionMenuListener;
    protected String _context;
    protected boolean _contextChanged;
    protected final String _title = TraceUIMessages._104;

    public TraceViewerPage createPage(EObject mofObject) {
        if (this._fi != null) {
            this._fi.restore();
        }
        return new ReferenceTablePage(mofObject, (TraceViewer)this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof ReferenceTablePage)) continue;
            ((ReferenceTablePage)page).dispose();
        }
        this._referands = null;
        this._referee = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        String referandsStr = TraceUIMessages._108;
        this._referands = new Action(referandsStr){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("obj_ref_display", 0);
                TraceUIPlugin.getDefault().notifyRefChangedEventListener();
            }
        };
        this._referands.setText(referandsStr);
        this._referands.setDescription(referandsStr);
        this._referands.setToolTipText(referandsStr);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        this._referands.setChecked(ref == 0);
        String refereeStr = TraceUIMessages._109;
        this._referee = new Action(refereeStr){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("obj_ref_display", 1);
                TraceUIPlugin.getDefault().notifyRefChangedEventListener();
            }
        };
        this._referee.setText(refereeStr);
        this._referee.setDescription(refereeStr);
        this._referee.setToolTipText(refereeStr);
        this._referee.setChecked(ref == 1);
        String openSourceStr = TraceUIMessages._74;
        this._openSource = new Action(openSourceStr){

            public void run() {
                ReferenceTablePage page = (ReferenceTablePage)ReferenceTableViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        this._openSource.setEnabled(false);
        String strChooseColumns = TraceUIMessages._56;
        this._chooseColumns = new Action(strChooseColumns){

            public void run() {
                ReferenceTablePage page = (ReferenceTablePage)ReferenceTableViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                ReferenceTable view = page.getView();
                view.getChooseColumnsAction(view.getColumnDataList(), view.getColumnsPreferencesKey()).run();
            }
        };
        this._chooseColumns.setText(strChooseColumns);
        TracePluginImages.setImageDescriptors((IAction)this._chooseColumns, "lcl16", "choosecolumn_co.gif");
        this._chooseColumns.setDescription(strChooseColumns);
        this._chooseColumns.setToolTipText(strChooseColumns);
        this._chooseColumns.setEnabled(true);
        String strSortByColumn = TraceUIMessages._58;
        this._sortByColumn = new Action(strSortByColumn){

            public void run() {
                ReferenceTablePage page = (ReferenceTablePage)ReferenceTableViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                ReferenceTable view = page.getView();
                view.getSortByColumnAction().run();
            }
        };
        this._sortByColumn.setText(strSortByColumn);
        TracePluginImages.setImageDescriptors((IAction)this._sortByColumn, "lcl16", "alphab_sort_co.gif");
        this._sortByColumn.setDescription(strSortByColumn);
        this._sortByColumn.setToolTipText(strSortByColumn);
        this._sortByColumn.setEnabled(true);
        IMenuManager menum = this.getViewSite().getActionBars().getMenuManager();
        menum.add((IAction)this._referands);
        menum.add((IAction)this._referee);
        menum.add((IContributionItem)new Separator());
        menum.add((IAction)this._chooseColumns);
        menum.add((IAction)this._sortByColumn);
        MenuManager submenu = new MenuManager(TraceUIMessages._222);
        submenu.addMenuListener((IMenuListener)this.getContextSelectionMenuListener());
        submenu.add((IAction)new Action(){});
        menum.add((IContributionItem)submenu);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._openSource);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public ContextSelectionMenuListener getContextSelectionMenuListener() {
        if (this._contextSelectionMenuListener == null) {
            this._contextSelectionMenuListener = new ContextSelectionMenuListener();
        }
        return this._contextSelectionMenuListener;
    }

    public Action openSource() {
        return this._openSource;
    }

    public Action referands() {
        return this._referands;
    }

    public Action referee() {
        return this._referee;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((ReferenceTablePage)this.getCurrentPage()).setFocus();
        }
        ContextUpdaterHelper.setCurrentFocusContextLanguage(this.getSelectedContext());
    }

    public void showPage(IPage page) {
        super.showPage(page);
        this.getContextSelectionMenuListener().setViewer(this);
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)object).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return this._title;
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"ProfilingAgentScope"};
        return scope;
    }

    public void filterUpdated() {
        TraceViewerPage page = (TraceViewerPage)this.getCurrentPage();
        if (page != null) {
            if (this.fPartVisible) {
                page.refreshPage();
            } else {
                this.fForceRefresh = true;
            }
        }
    }

    public Object[] getViewerControls() {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof ReferenceTablePage) {
            return new Object[]{((ReferenceTablePage)this.getCurrentPage()).getView().getTree()};
        }
        return null;
    }

    public Viewer[] getExportViewer() {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof ReferenceTablePage) {
            return new Viewer[]{((ReferenceTablePage)this.getCurrentPage()).getView().getTreeViewer()};
        }
        return null;
    }

    public void updateContext() {
        ContextUpdaterHelper.setCurrentFocusContextLanguage(this.getSelectedContext());
        this._contextChanged = false;
    }

    public String getSelectedContext() {
        return this._context;
    }

    public boolean contextChanged() {
        return this._contextChanged;
    }

    public void setSelectedContext(String context) {
        this.setSelectedContext(context, true);
    }

    public void setSelectedContext(String context, boolean refresh) {
        this._contextChanged = context == null ? this._context != null : !context.equals(this._context);
        this._context = context;
        if (this._contextChanged && refresh && this.getCurrentPage() != null) {
            ((TraceViewerPage)this.getCurrentPage()).refreshPage();
        }
    }

    public String getDefaultPageMessage() {
        return TraceMessages._23;
    }
}

