/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTabItem;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.MethodInvocationDetails;
import org.eclipse.hyades.trace.views.internal.MethodInvocationStatistic;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SinglePatternTab
extends ExecutionStatisticTabItem {
    protected MethodInvocationDetails _view;
    private final String _title = TraceUIPlugin.getString("5");
    private boolean _stdSelect = true;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;

    protected SinglePatternTab(ExecutionStatisticPage2 page) {
        super(page);
    }

    public void createControl(Composite parent) {
        this._view = new MethodInvocationDetails(parent, this);
        this._view.initialize();
        this._page.setContextMenu((Control)this._view.getCanvas().canvas(), this._view.getInvocationGraph());
        this._page.setContextMenu((Control)this._view.getInvocationStatistic().getTree(), (ISelectionProvider)this._view.getInvocationStatistic().getTreeViewer());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), String.valueOf(TraceUIPlugin.getPluginId()) + ".mthi0000");
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this._view != null) {
            this._view.menuAboutToShow(menu);
        }
    }

    public Control getControl() {
        if (this._view != null) {
            return this._view.getControl();
        }
        return null;
    }

    public String getViewTitle() {
        return this._title;
    }

    public boolean isEmpty() {
        return !PerftraceUtil.hasFullMethodInvocationInfo((EObject)this._page.getMOFObject());
    }

    public void refresh() {
        if (this._view != null) {
            this._view.refresh();
        }
    }

    public boolean isTimeMenuEnabled() {
        return true;
    }

    public void runShowPercentAction() {
        if (this._view != null) {
            this._view.getInvocationStatistic().getShowPercentAction().run();
        }
    }

    public void selectionChanged() {
        if (this._view != null) {
            this._view.selectionChanged();
        }
    }

    public void setFocus() {
        if (this._view != null) {
            this._view.getControl().setFocus();
        }
    }

    public void update(boolean newPage) {
        if (this._view != null) {
            this._view.update(true);
        }
    }

    public void dispose() {
        super.dispose();
        if (this._view != null) {
            this._view.dispose();
            this._view = null;
        }
    }

    public MultiLevelStatisticView getStatisticView() {
        return this._view != null ? this._view.getInvocationStatistic() : null;
    }

    public Action previous() {
        return this._page.getViewer()._previous;
    }

    public Action next() {
        return this._page.getViewer()._next;
    }

    public Action caller() {
        return this._page.getViewer()._caller;
    }

    public Action callee() {
        return this._page.getViewer()._callee;
    }

    public Action update() {
        return this._page.getViewer()._update;
    }

    public Action openSource() {
        return this._page.openSource();
    }

    public Action baseTime() {
        return this._page.getViewer()._showCompensatedTime;
    }

    public Action rawTime() {
        return this._page.getViewer()._showRawTime;
    }

    public Action percentMode() {
        return this._page.percentMode();
    }

    public void runStdSelectAction() {
        this._stdSelect = true;
        this._zoomIn = !this._stdSelect;
        this._zoomOut = !this._stdSelect;
        this._page.getViewer()._stdSelectAction.setChecked(true);
        this._page.getViewer()._zoomInAction.setChecked(false);
        this._page.getViewer()._zoomOutAction.setChecked(false);
        this._view.zoomIn(this._zoomIn);
        this._view.zoomOut(this._zoomOut);
    }

    public void runZoomInAction() {
        this._zoomIn = this._page.getViewer()._zoomInAction.isChecked();
        if (!this._zoomIn) {
            this._stdSelect = true;
        } else {
            this._stdSelect = !this._zoomIn;
            boolean bl = this._zoomOut = !this._zoomIn;
        }
        if (this._zoomIn) {
            this._page.getViewer()._stdSelectAction.setChecked(false);
            this._page.getViewer()._zoomOutAction.setChecked(false);
        } else {
            this._page.getViewer()._stdSelectAction.setChecked(true);
        }
        this._view.zoomIn(this._zoomIn);
    }

    public void runZoomOutAction() {
        this._zoomOut = this._page.getViewer()._zoomOutAction.isChecked();
        if (!this._zoomOut) {
            this._stdSelect = true;
        } else {
            this._stdSelect = !this._zoomOut;
            boolean bl = this._zoomIn = !this._zoomOut;
        }
        if (this._zoomOut) {
            this._page.getViewer()._stdSelectAction.setChecked(false);
            this._page.getViewer()._zoomInAction.setChecked(false);
        } else {
            this._page.getViewer()._stdSelectAction.setChecked(true);
        }
        this._view.zoomOut(this._zoomOut);
    }

    public void runShowCalleeAction() {
        if (this._view != null) {
            this._view.showCallee();
        }
    }

    public void runHomeAction() {
        if (this._view != null) {
            this._view.update();
        }
    }

    public void runShowCallerAction() {
        if (this._view != null) {
            this._view.showCaller();
        }
    }

    public void runPreviousAction() {
        if (this._view != null) {
            this._view.previous();
        }
    }

    public void runNextAction() {
        if (this._view != null) {
            this._view.next();
        }
    }

    public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = this._page.getViewer();
        return new IAction[]{viewer.getReportAction(), viewer._callee, viewer._caller, viewer._update, viewer._next, viewer._previous, viewer._openSource, viewer._openColorDialog, viewer._zoomInAction, viewer._zoomOutAction, viewer._stdSelectAction};
    }

    public Object[] getViewerControls() {
        return new Object[]{this._view.getInvocationStatistic().getTree()};
    }

    protected void handleHidden() {
        SinglePattern p;
        MethodInvocationStatistic v = this._view.getInvocationStatistic();
        if (v != null) {
            v.setHidden();
        }
        if ((p = this._view.getInvocationGraph()) != null) {
            p.setHidden();
        }
    }

    protected void handleVisible() {
        SinglePattern p;
        MethodInvocationStatistic v = this._view.getInvocationStatistic();
        if (v != null) {
            v.setVisible();
        }
        if ((p = this._view.getInvocationGraph()) != null) {
            p.setVisible();
        }
    }
}

