/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;

public abstract class AbstractLazyHandler
implements IViewSelectionChangedListener {
    private boolean isVisible;
    private boolean lazyDisabled;
    private boolean lazyMode;
    protected static final int LAZY_UPDATE = 1;
    protected static final int LAZY_UPDATE_BUTTONS = 2;
    protected static final int LAZY_HANDLE_SELECTION_EVENT = 4;
    protected static final int LAZY_HANDLE_VIEWER_SELECTION_EVENT = 8;
    protected static final int LAZY_UPDATE_WITH_REFRESH = 17;
    protected static final int LAZY_UPDATE_UI = 17;
    protected static final int LAZY_REFRESH = 32;
    protected int lazyOperations;
    protected Object lazySelectionEventSource;

    public AbstractLazyHandler(boolean lazyMode) {
        this.lazyMode = lazyMode;
    }

    protected final boolean checkSetLazyViewerSelectionOperation(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (!this.checkSetLazyOperation(8)) {
            return false;
        }
        this.addPostponedSelectionEventSource(source);
        return true;
    }

    protected void addPostponedSelectionEventSource(Object source) {
        if (this.isHandleSelectionEventNeeded(source)) {
            this.lazySelectionEventSource = source;
        } else if (this.lazySelectionEventSource == null || !this.isHandleSelectionEventNeeded(this.lazySelectionEventSource)) {
            this.lazySelectionEventSource = source;
        }
    }

    protected boolean isHandleSelectionEventNeeded(Object source) {
        return source != this;
    }

    protected Object nextPostponedSelectionEventSource() {
        if (this.lazySelectionEventSource == null) {
            return null;
        }
        Object o = this.lazySelectionEventSource;
        this.lazySelectionEventSource = null;
        return o;
    }

    protected boolean lazyHandlesOpType(int opType) {
        return true;
    }

    protected final boolean checkSetLazyOperation(int opType) {
        if (!this.lazyMode || !this.lazyHandlesOpType(opType)) {
            return false;
        }
        if (this.lazyDisabled || this.isVisible()) {
            this.lazyOperations &= ~opType;
            return false;
        }
        this.lazyOperations |= opType;
        return true;
    }

    public boolean isLazyMode() {
        return this.lazyMode;
    }

    public void setLazyMode(boolean lazy) {
        if (this.lazyMode == lazy) {
            return;
        }
        if (!lazy) {
            this.processLazyPostponedOperations();
        }
        this.lazyMode = lazy;
    }

    protected final void processLazyPostponedOperations() {
        boolean oldLazy = this.lazyDisabled;
        this.lazyDisabled = true;
        try {
            this.doProcessLazyPostponedOperations();
        }
        finally {
            this.lazyDisabled = oldLazy;
        }
    }

    protected void doProcessLazyPostponedOperations() {
        int processedOps = 0;
        if ((this.lazyOperations & 1) != 0) {
            int updateOp = this.lazyOperations & 0xFFFFFFEE;
            this.lazyOperations &= 0xFFFFFFEE;
            this.doUpdate((updateOp & 0x11) == 17, true, processedOps);
            processedOps |= updateOp;
        }
        if ((this.lazyOperations & 0x11) != 0) {
            this.lazyOperations &= 0xFFFFFFEE;
            this.doUpdateUI(true, processedOps);
            processedOps |= 0x11;
        }
        if ((this.lazyOperations & 0x20) != 0) {
            this.lazyOperations &= 0xFFFFFFDF;
            this.doUpdateUI(true, processedOps);
            processedOps |= 0x20;
        }
        if ((this.lazyOperations & 2) != 0) {
            this.lazyOperations &= 0xFFFFFFFD;
            this.doUpdateButtons(true, processedOps);
            processedOps |= 2;
        }
        if ((this.lazyOperations & 8) != 0) {
            this.lazyOperations &= 0xFFFFFFF7;
            Object src = this.nextPostponedSelectionEventSource();
            while (src != null) {
                ViewSelectionChangedEvent event = TraceUIManager.getTraceUIManager().getViewSelectionChangedEvent();
                event.setSource(src);
                this.doHandleViewSelectionChangedEvent(event, true, processedOps);
                src = this.nextPostponedSelectionEventSource();
            }
            processedOps |= 8;
        }
        if ((this.lazyOperations & 4) != 0) {
            this.lazyOperations &= 0xFFFFFFFB;
            this.doHandleSelectionEvent(true, processedOps);
            processedOps |= 4;
        }
        this.lazyOperations = 0;
    }

    protected final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible() {
        if (this.isVisible) {
            return;
        }
        this.isVisible = true;
        this.handleVisible();
    }

    public final void setHidden() {
        if (!this.isVisible) {
            return;
        }
        this.isVisible = false;
        this.handleHidden();
    }

    protected void handleVisible() {
        this.processLazyPostponedOperations();
    }

    protected void handleHidden() {
    }

    protected final boolean checkSetLazyUpdateOperation(boolean refresh) {
        return this.checkSetLazyOperation(refresh ? 17 : 1);
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean refresh) {
        if (this.checkSetLazyUpdateOperation(refresh)) {
            return;
        }
        this.doUpdate(refresh, false, 0);
    }

    protected void updateButtons() {
        if (this.checkSetLazyOperation(2)) {
            return;
        }
        this.doUpdateButtons(false, 0);
    }

    protected void handleSelectionEvent() {
        if (this.checkSetLazyOperation(4)) {
            return;
        }
        this.doHandleSelectionEvent(false, 0);
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        if (this.checkSetLazyViewerSelectionOperation(event)) {
            return;
        }
        this.doHandleViewSelectionChangedEvent(event, false, 0);
    }

    public void updateUI() {
        if (this.checkSetLazyOperation(17)) {
            return;
        }
        this.doUpdateUI(false, 0);
    }

    public void refresh() {
        if (this.checkSetLazyOperation(32)) {
            return;
        }
        this.doRefresh(false, 0);
    }

    protected abstract void doUpdate(boolean var1, boolean var2, int var3);

    protected abstract void doUpdateButtons(boolean var1, int var2);

    protected abstract void doHandleSelectionEvent(boolean var1, int var2);

    protected abstract void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent var1, boolean var2, int var3);

    protected abstract void doUpdateUI(boolean var1, int var2);

    protected abstract void doRefresh(boolean var1, int var2);
}

