/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.AggregatedExecutionStatisticsTab;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.AggregatedExecutionStatistic;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AggregatedCumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodQualifiedNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PerThreadPercentColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class AggregatedCallStack
extends StatisticView {
    protected CallStackInfoProvider _infoProvider = new CallStackInfoProvider();
    protected ColumnLabelAdapter _methodNameCol;
    protected ColumnLabelAdapter _percentCol;
    protected ColumnLabelAdapter _cumulativeTimeCol;
    protected Button _prevButton;
    protected Button _nextButton;
    protected Label _stackCountInfo;

    public AggregatedCallStack(Composite parent, AggregatedExecutionStatisticsTab tabItem, boolean initializeContent) {
        super(true, parent, tabItem.getPage(), initializeContent);
        this.createColumnsLabelProviders();
    }

    public AggregatedCallStack(Composite parent, AggregatedExecutionStatisticsTab tabItem) {
        this(parent, tabItem, true);
    }

    public void createColumnsLabelProviders() {
        this._methodNameCol = new MethodQualifiedNameColumnLabel();
        this._percentCol = new PerThreadPercentColumnLabel();
        this._cumulativeTimeCol = new AggregatedCumulativeTimeColumnLabel();
    }

    public Object getSelectedElement() {
        if (this._page instanceof ExecutionStatisticPage2) {
            return ((ExecutionStatisticPage2)this._page).getAggregatedExecutionStatisticsTab().getView().getCurrentSelection();
        }
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (selModel.size() > 0) {
            return selModel.getFirstElement();
        }
        return null;
    }

    public String getDefaultColumnsTemplate() {
        return "method.qualified.name:0:" + String.valueOf(1) + ":left:500," + "method.percent.thread" + ":1:" + String.valueOf(1) + ":right:120," + "method.cumul.time" + ":2:" + String.valueOf(1) + ":right:120";
    }

    public String getColumnsPreferencesKey() {
        return "AggrCallStack";
    }

    public IContentProvider getContentProvider() {
        return new CallStacksContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new CallStacksLabelProvider(this);
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        this._methodNameCol.resetMap();
        this._percentCol.resetMap();
        this._cumulativeTimeCol.resetMap();
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
    }

    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    protected Composite createControl(Composite parent, ArrayList cols) {
        this._viewContainer = this._toolkit.createComposite(parent, 0x800000);
        this._viewContainer.setLayout((Layout)new GridLayout(1, false));
        this._viewContainer.setLayoutData((Object)GridUtil.createFill());
        Composite callStackTable = this._toolkit.createComposite(this._viewContainer, 0x800000);
        callStackTable.setLayout((Layout)new GridLayout(1, false));
        callStackTable.setLayoutData((Object)GridUtil.createFill());
        this._viewComp = this._toolkit.createComposite(callStackTable, 0x800000);
        this._viewComp.setLayout((Layout)new GridLayout(1, false));
        this._viewComp.setLayoutData((Object)GridUtil.createFill());
        this._dataPane = this._toolkit.createViewForm(this._viewComp);
        this._dataPane.setContent(this.createTableViewer((Composite)this._dataPane, cols));
        this._dataPane.setLayoutData((Object)GridUtil.createFill());
        callStackTable.addControlListener((ControlListener)this);
        Composite buttonsPanel = this._toolkit.createComposite(this._viewContainer);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        buttonsPanel.setLayoutData((Object)GridUtil.createHorizontalFill());
        buttonsPanel.setLayout((Layout)gridLayout);
        this._prevButton = this._toolkit.createButton(buttonsPanel, " < " + TraceUIMessages._271 + " ", 0x800000);
        this._prevButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        this._prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AggregatedCallStack.this._infoProvider.selectPrevious()) {
                    AggregatedCallStack.this.updateColumns();
                }
            }
        });
        this._nextButton = this._toolkit.createButton(buttonsPanel, " " + TraceUIMessages._272 + " > ", 0x800000);
        this._nextButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        this._nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AggregatedCallStack.this._infoProvider.selectNext()) {
                    AggregatedCallStack.this.updateColumns();
                }
            }
        });
        this._stackCountInfo = this._toolkit.createLabel(buttonsPanel, "");
        this._stackCountInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return this._viewContainer;
    }

    protected Composite createTree(Composite parent, int options) {
        Tree tree = this._toolkit.createTree(parent, options);
        tree.addListener(40, AggregatedExecutionStatistic.getBarGraphPainter(tree, 1));
        return tree;
    }

    protected StructuredViewer createTreeViewer(Composite tree) {
        TreeViewer tv = this.getTreeViewer((Tree)tree);
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object node;
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty() && (node = ((IStructuredSelection)selection).getFirstElement()) instanceof TRCFullMethodInvocation) {
                    AggregatedCallStack.this.openSourceForSelection(selection);
                }
            }
        });
        return tv;
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new TreeViewer(tree);
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".mthid0000";
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new CallStacksSorter();
    }

    protected String getViewTypeStr() {
        return "viewoption.callstacks";
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new StatisticView.StatisticFilter(this);
    }

    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
    }

    protected void openSourceForSelection(ISelection selection) {
        TraceViewer traceViewer;
        TraceViewerPage page;
        if (selection != null && (page = this.getTraceViewerPage()) != null && (traceViewer = page.getTraceViewer()) instanceof ExecutionStatisticViewer2) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    ((ExecutionStatisticViewer2)traceViewer).openSource().run();
                }
            });
        }
    }

    protected void updateColumns() {
        this.updateUI(this.getColumnDataList());
        String label = "";
        int count = this._infoProvider.getInvocationCount();
        if (count > 1) {
            label = NLS.bind((String)TraceUIMessages._273, (Object)new Integer(this._infoProvider.getSelectedIndex() + 1), (Object)new Integer(count));
        }
        this._stackCountInfo.setText(label);
    }

    private Control createTableViewer(Composite parent, ArrayList cols) {
        Composite tree = this.createTree(parent, 8454148);
        this._viewer = this.createTreeViewer(tree);
        int idx = 0;
        while (idx < cols.size()) {
            ColumnData data = (ColumnData)cols.get(idx);
            data.setContext(this.getContext());
            if (data.visible()) {
                new StatisticTableColumnInfo(this, data, this._deltaColumns);
            }
            ++idx;
        }
        Tree tre = this.getTree();
        tre.setLinesVisible(true);
        tre.setHeaderVisible(true);
        tre.setLayout(this.getLayout());
        tre.setLayoutData((Object)new GridData(1808));
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        if (tree instanceof Tree) {
            ((Tree)tree).addSelectionListener(this.getSelectionListener());
        }
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this._viewer.getControl();
    }

    public void updateCallStackInfoProvider() {
        Object selection = this.getSelectedElement();
        if (selection instanceof AggregatedInvocation) {
            this._infoProvider.setAggregatedInvocation((AggregatedInvocation)selection);
        }
        boolean enabled = this._infoProvider.getInvocationCount() > 1;
        this._prevButton.setEnabled(enabled);
        this._nextButton.setEnabled(enabled);
        this.updateColumns();
    }

    protected void firstTimeUpdate() {
        super.firstTimeUpdate();
        this.redrawTable();
    }

    public void redrawTable() {
        this.getTree().setRedraw(false);
        ArrayList<ColumnData> list = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        this.resetColumns(list);
        this._currentColumns = list;
        this.getTree().setRedraw(true);
        this.refresh();
    }

    public void dispose() {
        super.dispose();
        this._infoProvider.dispose();
        this._prevButton.dispose();
        this._nextButton.dispose();
        this._stackCountInfo.dispose();
        this._infoProvider = null;
        this._methodNameCol = null;
        this._percentCol = null;
        this._cumulativeTimeCol = null;
        this._prevButton = null;
        this._nextButton = null;
        this._stackCountInfo = null;
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new CallStacksCellLabelProvider(colData);
    }

    public class CallStackInfoProvider {
        protected AggregatedInvocation _aggregatedInv;
        protected int _selItem = 0;

        public void setAggregatedInvocation(AggregatedInvocation aggregatedInv) {
            if (this._aggregatedInv != aggregatedInv) {
                this._aggregatedInv = aggregatedInv;
                this._selItem = 0;
            }
        }

        public int getInvocationCount() {
            return this._aggregatedInv != null ? this._aggregatedInv.getAllInvocations().size() : 0;
        }

        public boolean selectNext() {
            int count = this.getInvocationCount();
            if (this._selItem < count - 1) {
                ++this._selItem;
                return true;
            }
            if (count > 1) {
                this._selItem = 0;
                return true;
            }
            return false;
        }

        public boolean selectPrevious() {
            if (this._selItem > 0) {
                --this._selItem;
                return true;
            }
            int count = this.getInvocationCount();
            if (this._selItem == 0 && count > 1) {
                this._selItem = count - 1;
                return true;
            }
            return false;
        }

        public int getSelectedIndex() {
            return this._selItem;
        }

        public AggregatedInvocation.Item getSelectedInvocation() {
            if (this._aggregatedInv == null) {
                return null;
            }
            List allInvocations = this._aggregatedInv.getAllInvocations();
            if (this._selItem >= 0 && this._selItem < allInvocations.size()) {
                return (AggregatedInvocation.Item)allInvocations.get(this._selItem);
            }
            return null;
        }

        public void dispose() {
            this._aggregatedInv = null;
        }

        public Object getAggregatedInvocation() {
            return this._aggregatedInv;
        }
    }

    public class CallStacksCellLabelProvider
    extends StatisticCellLabelProvider {
        public CallStacksCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((CallStacksLabelProvider)AggregatedCallStack.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((CallStacksLabelProvider)AggregatedCallStack.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class CallStacksContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            AggregatedInvocation.Item invocation = AggregatedCallStack.this._infoProvider.getSelectedInvocation();
            ArrayList<AggregatedInvocation.Item> stack = new ArrayList<AggregatedInvocation.Item>();
            while (invocation != null) {
                stack.add(invocation);
                AggregatedInvocation.Item invokedBy = invocation.getInvokedBy();
                if (invokedBy == null) break;
                invocation = invokedBy;
            }
            return stack.toArray();
        }

        public Object[] getChildren(Object element) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }
    }

    public class CallStacksLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView viewer;

        public CallStacksLabelProvider(StatisticView viewer) {
            this.viewer = viewer;
        }

        public String getColumnText(Object obj, int col) {
            if (obj == null) {
                return "";
            }
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this.viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (pos == 0) {
                return AggregatedCallStack.this.getElementColumnText(obj, AggregatedCallStack.this._methodNameCol, info.isDeltaColumn());
            }
            if (pos == 1) {
                return AggregatedCallStack.this.getElementColumnText(obj, AggregatedCallStack.this._percentCol, false);
            }
            if (pos == 2) {
                return AggregatedCallStack.this.getElementColumnText(obj, AggregatedCallStack.this._cumulativeTimeCol, info.isDeltaColumn());
            }
            return "";
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this.viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj != null && pos == 0) {
                return AggregatedCallStack.this.getElementColumnImage(obj, AggregatedCallStack.this._methodNameCol, info.isDeltaColumn());
            }
            return null;
        }
    }

    public class CallStacksSorter
    extends StatisticView.StatisticSorter {
        public CallStacksSorter() {
            super(AggregatedCallStack.this);
        }

        public void sort(Viewer viewer, Object[] elements) {
        }

        public int compare(Viewer viewer, Object _e1, Object _e2) {
            return 0;
        }

        public void setSortedColumn(TreeColumn newSortColumn) {
        }

        public void setSortedColumn(int sortSequence, TreeColumn newSortColumn) {
        }
    }
}

