/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ContextInfoContainer {
    protected Composite _statusContainer;
    protected Composite _statusSelItemContainer;
    protected Composite _statusSelHeaderContainer;
    protected Label _statusIcon;
    protected Label _statusText;
    protected Combo _contextCombo;
    private GridData _visibleLayoutData;
    private GridData _nonVisibleLayoutData;
    private Vector _contextInfoContainerListeners;
    HyadesFormToolkit _toolkit;
    private EObject mofObject;
    private IContextViewer viewer;

    public void setViewer(IContextViewer viewer_) {
        this.viewer = viewer_;
    }

    public void setMOFObject(EObject mofObject_) {
        this.mofObject = mofObject_;
        this.resetComboListings(this._contextCombo);
    }

    public Composite createControl(Composite parent) {
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this._statusContainer = this._toolkit.createComposite(parent, 0);
        this._statusContainer.setLayoutData((Object)GridUtil.createFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        this._statusContainer.setLayout((Layout)layout);
        Label selectedItemContext = new Label(this._statusContainer, 0);
        selectedItemContext.setBackground(this._statusContainer.getBackground());
        selectedItemContext.setText(TraceUIMessages._223);
        selectedItemContext.setLayoutData((Object)GridUtil.createFill());
        this._statusIcon = new Label(this._statusContainer, 0x1000000);
        this._statusIcon.setBackground(this._statusContainer.getBackground());
        GridData data = GridUtil.createFill();
        this._statusIcon.setLayoutData((Object)data);
        this._statusText = new Label(this._statusContainer, 0);
        this._statusText.setBackground(this._statusContainer.getBackground());
        data = GridUtil.createFill();
        this._statusText.setLayoutData((Object)data);
        this._statusIcon.setImage(null);
        this._statusText.setText("");
        Label selectedHeaderContext = new Label(this._statusContainer, 0);
        selectedHeaderContext.setLayoutData((Object)GridUtil.createFill());
        selectedHeaderContext.setBackground(this._statusContainer.getBackground());
        selectedHeaderContext.setText(TraceUIMessages._224);
        data = GridUtil.createFill();
        data.horizontalSpan = 2;
        this._contextCombo = new Combo(this._statusContainer, 8);
        this._contextCombo.setLayoutData((Object)data);
        this._contextCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String[] contexts = ContextUpdaterHelper.getContexts(ContextInfoContainer.this.mofObject);
                ContextInfoContainer.this.viewer.setSelectedContext(contexts[ContextInfoContainer.this._contextCombo.getSelectionIndex()]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this._statusContainer;
    }

    public void updateStatusContext(IContextLanguage language) {
        if (language == null || language.name().equals(this._statusText.getText())) {
            return;
        }
        if (this._statusIcon.getImage() != null) {
            this._statusIcon.getImage().dispose();
        }
        if (language.icon() != null) {
            this._statusIcon.setImage(language.icon().createImage());
        } else {
            this._statusIcon.setImage(null);
        }
        this._statusText.setText(language.name());
        this._statusContainer.pack(true);
        this.notifyContextInfoContainerListeners(this._statusContainer.getVisible());
    }

    private void resetComboListings(Combo combo) {
        combo.removeAll();
        String[] contexts = ContextUpdaterHelper.getContexts(this.mofObject);
        String selectedContext = ContextUpdaterHelper.getCurrentContext(contexts, this.viewer);
        int selectedIndex = -1;
        int i = 0;
        while (i < contexts.length) {
            IContextLanguage language = ContextManager.getContextLanguage((String)contexts[i]);
            if (language != null) {
                combo.add(language.name());
                if (selectedContext != null && selectedContext.equals(contexts[i])) {
                    selectedIndex = i;
                }
            }
            ++i;
        }
        if (selectedIndex >= 0) {
            combo.select(selectedIndex);
        }
        if (combo.getItemCount() > 1) {
            this.setVisibleLayoutDataForStatusContainer();
        } else {
            this.setNonVisibleLayoutDataForStatusContainer();
        }
    }

    private void setVisibleLayoutDataForStatusContainer() {
        if (this._visibleLayoutData == null) {
            this._visibleLayoutData = new GridData();
        }
        if (this._statusContainer.getLayoutData() != this._visibleLayoutData) {
            this._statusContainer.setLayoutData((Object)this._visibleLayoutData);
            this._statusContainer.setVisible(true);
            this.notifyContextInfoContainerListeners(true);
        }
    }

    private void setNonVisibleLayoutDataForStatusContainer() {
        if (this._nonVisibleLayoutData == null) {
            this._nonVisibleLayoutData = new GridData();
            this._nonVisibleLayoutData.heightHint = 0;
            this._nonVisibleLayoutData.widthHint = 0;
        }
        if (this._statusContainer.getLayoutData() != this._nonVisibleLayoutData) {
            this._statusContainer.setLayoutData((Object)this._nonVisibleLayoutData);
            this._statusContainer.setVisible(false);
            this.notifyContextInfoContainerListeners(false);
        }
    }

    private Vector getContextInfoContainerListeners() {
        if (this._contextInfoContainerListeners == null) {
            this._contextInfoContainerListeners = new Vector();
        }
        return this._contextInfoContainerListeners;
    }

    private void notifyContextInfoContainerListeners(boolean isVisible) {
        Vector contextInfoContainerListeners = this.getContextInfoContainerListeners();
        int i = 0;
        while (i < contextInfoContainerListeners.size()) {
            ((IContextInfoContainerListener)contextInfoContainerListeners.get(i)).visibilityChanged(isVisible);
            ++i;
        }
    }

    public void addContextInfoContainerListener(IContextInfoContainerListener listener) {
        this.getContextInfoContainerListeners().add(listener);
    }
}

