/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.ContextInfoContainer;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.fragment.ContentProviderNewLazyAdaptor;
import org.eclipse.hyades.trace.views.internal.fragment.FragmentedTreeViewer;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodInvocationEntryTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ThreadNameColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ExecutionStatistic
extends StatisticView
implements ITimeChangedListener {
    protected String tmpString;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    protected ContextInfoContainer _contextInfo;
    protected ColumnLabelAdapter _threadNameCol;
    protected ColumnLabelAdapter _methodNameCol;
    protected ColumnLabelAdapter _instanceNameCol;
    protected ColumnLabelAdapter _methodInvocationEntryTimeCol;
    protected ColumnLabelAdapter _cumulativeTimeCol;

    protected Composite createTree(Composite parent, int options) {
        return this._toolkit.createTree(parent, options | 0x10000000);
    }

    public ExecutionStatistic(Composite parent, TraceViewerPage page) {
        super(true, parent, page);
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        this._viewerFilter = new ExecutionStatisticFilter();
        this.createColumnsLabelProviders();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".exef0008";
    }

    public void createColumnsLabelProviders() {
        this._threadNameCol = new ThreadNameColumnLabel();
        this._methodNameCol = new MethodNameColumnLabel();
        this._instanceNameCol = new InstanceNameColumnLabel();
        this._methodInvocationEntryTimeCol = new MethodInvocationEntryTimeColumnLabel();
        this._cumulativeTimeCol = new CumulativeTimeColumnLabel();
    }

    public String getColumnsPreferencesKey() {
        return "Exec51";
    }

    public String getDefaultColumnsTemplate() {
        String executionColumn = "thread.name:0:" + String.valueOf(7) + ":left:200," + "object.name" + ":1:" + String.valueOf(1) + ":left:200," + "method.start.time" + ":2:" + String.valueOf(1) + ":right:100," + "method.cumul.time" + ":3:" + String.valueOf(1) + ":right:100";
        return executionColumn;
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new ExecutionTreeViewer(tree);
    }

    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
        Object sel;
        if (this._page == null) {
            return;
        }
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
            this.select(sel);
            this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
        }
    }

    private void select(Object obj) {
        TRCClass cls = null;
        TRCPackage pack = null;
        TRCMethod meth = null;
        TRCObject trcObj = null;
        if (this.adaptor == null) {
            Tree tree = (Tree)this.getTreeViewer().getControl();
            TreeItem[] items = tree.getItems();
            if (items.length != 0) {
                if (obj instanceof TRCPackage) {
                    pack = (TRCPackage)obj;
                } else if (obj instanceof TRCClass) {
                    cls = (TRCClass)obj;
                    pack = cls.getPackage();
                } else if (obj instanceof TRCMethod) {
                    meth = (TRCMethod)obj;
                    cls = meth.getDefiningClass();
                    pack = cls.getPackage();
                } else if (obj instanceof TRCObject) {
                    cls = ((TRCObject)obj).getIsA();
                    pack = cls.getPackage();
                    trcObj = (TRCObject)obj;
                } else if (obj instanceof TRCMethodInvocation) {
                    meth = ((TRCMethodInvocation)obj).getMethod();
                }
                this.searchInLevel(tree, this.getItemsRoot(tree), pack, cls, meth, trcObj);
            }
        } else if (obj instanceof TRCMethod) {
            IStructuredSelection curSel = (IStructuredSelection)this._viewer.getSelection();
            Object[] sel = curSel.toArray();
            if (sel.length != 0) {
                int i = sel.length - 1;
                while (i >= 0) {
                    Object s = sel[i];
                    if (s instanceof TRCMethodInvocation && ((TRCMethodInvocation)s).getMethod() == obj) {
                        return;
                    }
                    --i;
                }
            }
            TRCMethod method = (TRCMethod)obj;
            ExecutionStatisticContentProvider p = (ExecutionStatisticContentProvider)this.adaptor.getWrappedContentProvider();
            Object[] path = p.search(method, null);
            if (path != null) {
                int i = 0;
                while (i < path.length) {
                    Object ve = this.adaptor.toViewerElement(path[i]);
                    if (ve == null) {
                        return;
                    }
                    path[i] = ve;
                    ++i;
                }
                TreeSelection newSel = new TreeSelection(new TreePath(path));
                this._viewer.setSelection((ISelection)newSel, true);
            }
        } else if (obj instanceof TRCMethodInvocation) {
            IStructuredSelection curSel = (IStructuredSelection)this._viewer.getSelection();
            Object[] sel = curSel.toArray();
            if (sel.length != 0) {
                int i = sel.length - 1;
                while (i >= 0) {
                    Object s = sel[i];
                    if (s == obj) {
                        return;
                    }
                    --i;
                }
            }
            TRCMethodInvocation inv = (TRCMethodInvocation)obj;
            ExecutionStatisticContentProvider p = (ExecutionStatisticContentProvider)this.adaptor.getWrappedContentProvider();
            Object[] path = p.search(null, inv);
            if (path != null) {
                int i = 0;
                while (i < path.length) {
                    Object ve = this.adaptor.toViewerElement(path[i]);
                    if (ve == null) {
                        return;
                    }
                    path[i] = ve;
                    ++i;
                }
                TreeSelection newSel = new TreeSelection(new TreePath(path));
                this._viewer.setSelection((ISelection)newSel, true);
            }
        }
    }

    protected TreeItem getItemsRoot(Tree tree) {
        return null;
    }

    protected TreeItem searchItem(TreeItem[] items, Object obj) {
        TreeItem item = null;
        int j = 0;
        while (j < items.length) {
            TreeItem item1;
            item = items[j];
            if (item != null && !item.isDisposed()) {
                if (item.getData() != null && obj == this.getItemModelData(item)) {
                    return item;
                }
                if (item.getData() != null && item.getData() instanceof TRCMethodInvocation && obj instanceof TRCMethod && ((TRCMethodInvocation)item.getData()).getMethod().equals(obj)) {
                    return item;
                }
            }
            if ((item1 = this.searchItem(item.getItems(), obj)) != null) {
                return item1;
            }
            ++j;
        }
        return null;
    }

    protected Object getItemModelData(TreeItem item) {
        return this.adaptor != null ? ContentProviderNewLazyAdaptor.getObject(item.getData()) : item.getData();
    }

    protected void searchInLevel(Tree tree, TreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        TreeItem[] objItems = null;
        objItems = item != null ? item.getItems() : tree.getItems();
        TreeItem objItem = this.searchItem(objItems, trcObj);
        if (objItem == null) {
            objItem = this.searchItem(objItems, meth);
        }
        if (objItem == null) {
            objItem = this.searchItem(objItems, cls);
        }
        if (objItem == null) {
            objItem = this.searchItem(objItems, pack);
        }
        if (objItem != null) {
            tree.setSelection(new TreeItem[]{objItem});
            return;
        }
        if (item != null) {
            tree.setSelection(new TreeItem[]{item});
            return;
        }
        tree.deselectAll();
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
    }

    protected void updateDetailsPane() {
        int selCount = this.getTree().getSelectionCount();
        if (selCount != 1) {
            return;
        }
        TreeItem item = this.getTree().getSelection()[0];
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TreeItem) {
            itemData = ((TreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (this.adaptor != null) {
                sel = ContentProviderNewLazyAdaptor.getObject(sel);
            }
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ExecutionStatisticSorter();
    }

    protected void firstTimeUpdate() {
        super.firstTimeUpdate();
        this.handleTimeChangedEvent();
    }

    protected int updateTableGetColumnNumber() {
        if (this.getTree().getColumnCount() < 3) {
            return 0;
        }
        return 2;
    }

    public void handleTimeChangedEvent() {
        Action base = ((PatternPage)this.getTraceViewerPage()).baseTime();
        Action raw = ((PatternPage)this.getTraceViewerPage()).rawTime();
        this._drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (base != null) {
            base.setChecked(this._drawMode == 0);
        }
        if (raw != null) {
            raw.setChecked(this._drawMode == 1);
        }
        String newKey = this._drawMode == 0 ? "method.cumul.time" : "method.raw.cumul.time";
        String oldKey = newKey.equals("method.cumul.time") ? "method.raw.cumul.time" : "method.cumul.time";
        Tree tree = this.getTree();
        int idx = tree.getColumnCount();
        while (idx > 0) {
            TreeColumn col = tree.getColumn(idx - 1);
            StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)col.getData();
            String columnKey = staticTblColInfo.getColumnData().key();
            if (columnKey.equals(oldKey)) {
                staticTblColInfo.getColumnData().key(newKey);
                String newName = staticTblColInfo.getColumnData().name();
                if (staticTblColInfo.isSortColumn()) {
                    newName = String.valueOf(col.getText().substring(0, 1)) + newName;
                }
                col.setText(newName);
            }
            --idx;
        }
        this.getTreeViewer().refresh();
    }

    public void dispose() {
        super.dispose();
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
    }

    public IContentProvider getContentProvider() {
        return new ExecutionStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return this.adaptor != null ? this.wrappedLp : new ExecutionStatisticLableProvider(this);
    }

    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        } else {
            Object sel;
            ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
            if (model.size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllThreads((EObject)this._page.getMOFObject()).length <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.execution";
    }

    public int getDrawMode() {
        return this._drawMode;
    }

    public void setDrawMode(int mode) {
        this._drawMode = mode;
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCumulativeTime = PerftraceUtil.getTotalCumulativeTime((EObject)this._page.getMOFObject());
            if (this._totalCumulativeTime == 0.0) {
                this._totalCumulativeTime = 1.0;
            }
        }
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._cumulativeTimeCol) {
            return ContextUpdaterHelper.updateCumulTime(col, isDeltaColumn, this.isShowPercent(), this.getDrawMode(), this._totalCumulativeTime);
        }
        return super.getColumnDisplayInfo(col, isDeltaColumn);
    }

    protected Composite createControl(Composite parent, ArrayList cols) {
        final Composite vc = super.createControl(parent, cols);
        this._contextInfo = new ContextInfoContainer();
        this._contextInfo.setViewer((IContextViewer)this._page.getTraceViewer());
        this._contextInfo.createControl(vc);
        this._contextInfo.addContextInfoContainerListener(new IContextInfoContainerListener(){

            public void visibilityChanged(boolean isVisible) {
                vc.layout(true, true);
            }
        });
        return vc;
    }

    protected void updateStatusContext(IContextLanguage language) {
        if (this._contextInfo != null) {
            this._contextInfo.updateStatusContext(language);
        }
    }

    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        this.resetColumns();
        if (this._page instanceof PatternPage && this._contextInfo != null) {
            this._contextInfo.setMOFObject(this._page.getMOFObject());
        }
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
    }

    protected void resetColumns() {
        this._threadNameCol.resetMap();
        this._methodNameCol.resetMap();
        this._instanceNameCol.resetMap();
        this._methodInvocationEntryTimeCol.resetMap();
        this._cumulativeTimeCol.resetMap();
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new ExecutionStatisticCellLableProvider(colData);
    }

    public class ExecutionStatisticCellLableProvider
    extends StatisticCellLabelProvider {
        public ExecutionStatisticCellLableProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((ITableLabelProvider)ExecutionStatistic.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((ITableLabelProvider)ExecutionStatistic.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class ExecutionStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCMethodInvocation) {
                TRCMethodInvocation mi = (TRCMethodInvocation)element;
                TRCMethodInvocation parent = mi.getInvokedBy();
                if (parent == null) {
                    return mi.getThread();
                }
                return parent;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PerftraceUtil.getAllThreads((EObject)ExecutionStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object element) {
            ExecutionStatistic.this.tmpList.clear();
            if (element instanceof TRCThread) {
                return ((TRCThread)element).getInitialInvocations().toArray();
            }
            TRCMethodInvocation inv = (TRCMethodInvocation)element;
            Object[] segments = inv.getInvokes().toArray();
            int idx = 0;
            while (idx < segments.length) {
                ExecutionStatistic.this.tmpList.add((TRCMethodInvocation)segments[idx]);
                ++idx;
            }
            return ExecutionStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TRCThread) {
                return true;
            }
            return ((TRCMethodInvocation)element).getInvokes().size() > 0;
        }

        public Object[] search(TRCMethod method, TRCMethodInvocation inv) {
            Object[] threads = this.getElements(ExecutionStatistic.this._page.getMOFObject());
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < threads.length) {
                if (this.search(threads[i], method, inv, list)) {
                    Object[] result = new Object[list.size() + 1];
                    result[0] = threads[i];
                    int k = 1;
                    while (k < result.length) {
                        result[k] = list.get(result.length - k - 1);
                        ++k;
                    }
                    return result;
                }
                ++i;
            }
            return null;
        }

        private boolean search(Object parent, TRCMethod method, TRCMethodInvocation inv, List result) {
            Object[] children = this.getChildren(parent);
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                if (inv != null && inv == child) {
                    result.add(child);
                    return true;
                }
                if (child instanceof TRCMethodInvocation && ((TRCMethodInvocation)child).getMethod() == method) {
                    result.add(child);
                    return true;
                }
                if (this.search(child, method, inv, result)) {
                    result.add(child);
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(ExecutionStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCThread)) {
                return true;
            }
            String compareText = "";
            compareText = ((TRCThread)element).getName();
            if (compareText.equals("")) {
                compareText = TraceUIMessages._87;
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class ExecutionStatisticLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ExecutionStatisticLableProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCThread && pos == 0) {
                return ExecutionStatistic.this.getElementColumnText(obj, ExecutionStatistic.this._threadNameCol, info.isDeltaColumn());
            }
            if (obj instanceof TRCMethodInvocation) {
                switch (pos) {
                    case 0: {
                        return ExecutionStatistic.this.getElementColumnText(obj, ExecutionStatistic.this._methodNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return ExecutionStatistic.this.getElementColumnText(obj, ExecutionStatistic.this._instanceNameCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return ExecutionStatistic.this.getElementColumnText(obj, ExecutionStatistic.this._methodInvocationEntryTimeCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return ExecutionStatistic.this.getElementColumnText(obj, ExecutionStatistic.this._cumulativeTimeCol, info.isDeltaColumn());
                    }
                }
            }
            return "";
        }
    }

    public class ExecutionStatisticSorter
    extends StatisticView.StatisticSorter {
        public ExecutionStatisticSorter() {
            super(ExecutionStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCThread && e2 instanceof TRCThread && this._pos == 0) {
                return this._sortSequence * ExecutionStatistic.this.compareElements(e1, e2, ExecutionStatistic.this._threadNameCol, false);
            }
            if (e1 instanceof TRCFullMethodInvocation && e2 instanceof TRCFullMethodInvocation) {
                if (this._pos == 0) {
                    return this._sortSequence * ExecutionStatistic.this.compareElements(e1, e2, ExecutionStatistic.this._methodNameCol, false);
                }
                if (this._pos == 1) {
                    return this._sortSequence * ExecutionStatistic.this.compareElements(e1, e2, ExecutionStatistic.this._instanceNameCol, false);
                }
                if (this._pos == 2) {
                    return this._sortSequence * ExecutionStatistic.this.compareElements(e1, e2, ExecutionStatistic.this._methodInvocationEntryTimeCol, false);
                }
                if (this._pos == 3) {
                    return this._sortSequence * ExecutionStatistic.this.compareElements(e1, e2, ExecutionStatistic.this._cumulativeTimeCol, this._info.isDeltaColumn());
                }
            }
            return 0;
        }
    }

    class ExecutionTreeViewer
    extends FragmentedTreeViewer {
        public ExecutionTreeViewer(Composite parent) {
            super(parent);
        }

        public ExecutionTreeViewer(Tree tree) {
            super(tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }
}

