/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.DynamicFilter;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AvgBaseTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.BaseTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CPUTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CallsColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ClassNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InheritedBaseTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InheritedCallsColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InheritedCumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.NewItemColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PackageNameColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExecutionStatisticView
extends MultiLevelStatisticMethodView {
    private static final int[] _numberOfColumns = new int[]{20, 20, 20, 20};
    private static int _level = 1;
    public static final int INSTANCE_LEVEL = 4;
    protected double _totalPackageCPUtime = 0.0;
    private TRCPackageImpl.TRCPackageSnapshot packageSnapshot = new TRCPackageImpl.TRCPackageSnapshot();
    private TRCClassImpl.TRCClassSnapshot classSnapshot = new TRCClassImpl.TRCClassSnapshot();
    private TRCMethodImpl.TRCMethodSnapshot methodSnapshot = new TRCMethodImpl.TRCMethodSnapshot();
    protected ColumnLabelAdapter _packageNameCol;
    protected ColumnLabelAdapter _classNameCol;
    protected ColumnLabelAdapter _methodNameCol;
    protected ColumnLabelAdapter _instanceNameCol;
    protected ColumnLabelAdapter _newItemCol;
    protected ColumnLabelAdapter _baseTimeCol;
    protected ColumnLabelAdapter _avgBaseTimeCol;
    protected ColumnLabelAdapter _inheritedBaseTimeCol;
    protected ColumnLabelAdapter _cumulativeTimeCol;
    protected ColumnLabelAdapter _inheritedCumulativeTimeCol;
    protected ColumnLabelAdapter _callsCol;
    protected ColumnLabelAdapter _inheritedCallsCol;
    protected ColumnLabelAdapter _CPUTimeCol;

    public ExecutionStatisticView(Composite parent, TraceViewerPage page) {
        this(parent, page, true);
    }

    public ExecutionStatisticView(Composite parent, TraceViewerPage page, boolean initializeContent) {
        super(true, parent, page, initializeContent);
        this.createColumnsLabelProviders();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".clst0000";
    }

    public void createColumnsLabelProviders() {
        this._packageNameCol = new PackageNameColumnLabel();
        this._classNameCol = new ClassNameColumnLabel();
        this._methodNameCol = new MethodNameColumnLabel();
        this._instanceNameCol = new InstanceNameColumnLabel();
        this._newItemCol = new NewItemColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._newItemCol, this.packageSnapshot, this.classSnapshot, this.methodSnapshot);
        this._baseTimeCol = new BaseTimeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._baseTimeCol, this.packageSnapshot, this.classSnapshot, this.methodSnapshot);
        this._avgBaseTimeCol = new AvgBaseTimeColumnLabel();
        this._inheritedBaseTimeCol = new InheritedBaseTimeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._inheritedBaseTimeCol, this.packageSnapshot, this.classSnapshot, null);
        this._cumulativeTimeCol = new CumulativeTimeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._cumulativeTimeCol, this.packageSnapshot, this.classSnapshot, this.methodSnapshot);
        this._inheritedCumulativeTimeCol = new InheritedCumulativeTimeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._inheritedCumulativeTimeCol, this.packageSnapshot, this.classSnapshot, null);
        this._callsCol = new CallsColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._callsCol, this.packageSnapshot, this.classSnapshot, this.methodSnapshot);
        this._inheritedCallsCol = new InheritedCallsColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._inheritedCallsCol, this.packageSnapshot, this.classSnapshot, null);
        this._CPUTimeCol = new CPUTimeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._CPUTimeCol, this.packageSnapshot, this.classSnapshot, this.methodSnapshot);
    }

    protected int getClassPosForLevel(int pos) {
        if (this.getLevel() == 1) {
            switch (pos) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 9;
                }
                case 9: {
                    return 10;
                }
            }
        } else if (this.getLevel() == 4) {
            switch (pos) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 6;
                }
                case 5: {
                    return 8;
                }
                case 6: {
                    return 10;
                }
            }
        }
        return pos;
    }

    protected int getMethodPosForLevel(int pos) {
        if (this.getLevel() == 1) {
            switch (pos) {
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return -1;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return -1;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return -1;
                }
                case 9: {
                    return 8;
                }
            }
        } else if (this.getLevel() == 2) {
            switch (pos) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return -1;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return -1;
                }
                case 8: {
                    return 7;
                }
                case 9: {
                    return -1;
                }
                case 10: {
                    return 8;
                }
            }
        }
        return pos;
    }

    public boolean isEmptyUpdate() {
        return (double)PerftraceUtil.getTotalCalls((EObject)this._page.getMOFObject()) <= 0.0;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return "package.name:0:" + String.valueOf(7) + ":left:200," + ":1:" + String.valueOf(47) + ":20," + "package.base.time" + ":2:" + String.valueOf(17) + ":right:100," + "package.avg.base.time" + ":3:" + String.valueOf(1) + ":right:100," + "package.inh.base.time" + ":4:" + String.valueOf(16) + ":right:100," + "package.cumul.time" + ":5:" + String.valueOf(17) + ":right:100," + "package.inh.cumul.time" + ":6:" + String.valueOf(16) + ":right:100," + "package.calls" + ":7:" + String.valueOf(17) + ":right:50," + "package.inh.calls" + ":8:" + String.valueOf(16) + ":right:100," + "package.cpu.time" + ":9:" + String.valueOf(16) + ":right:100";
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return "class.name:0:" + String.valueOf(7) + ":200," + ":1:" + String.valueOf(47) + ":20," + "package.name" + ":2:" + String.valueOf(1) + ":left:100," + "class.base.time" + ":3:" + String.valueOf(17) + ":right:100," + "class.avg.base.time" + ":4:" + String.valueOf(1) + ":right:100," + "class.inh.base.time" + ":5:" + String.valueOf(16) + ":right:100," + "class.cumul.time" + ":6:" + String.valueOf(17) + ":right:100," + "class.inh.cumul.time" + ":7:" + String.valueOf(16) + ":right:100," + "class.calls" + ":8:" + String.valueOf(17) + ":right:50," + "class.inh.calls" + ":9:" + String.valueOf(16) + ":right:100," + "class.cpu.time" + ":10:" + String.valueOf(16) + ":right:100";
    }

    protected String getDefaultColumnsTemplateMethodLevel() {
        return "method.name:0:" + String.valueOf(7) + ":left:200," + ":1:" + String.valueOf(47) + ":20," + "class.name" + ":2:" + String.valueOf(1) + ":left:100," + "package.name" + ":3:" + String.valueOf(1) + ":left:100," + "method.base.time" + ":4:" + String.valueOf(17) + ":right:100," + "method.avg.base.time" + ":5:" + String.valueOf(1) + ":right:100," + "method.cumul.time" + ":6:" + String.valueOf(17) + ":right:100," + "method.calls" + ":7:" + String.valueOf(17) + ":right:55," + "method.cpu.time" + ":8:" + String.valueOf(16) + ":right:100";
    }

    protected String getDefaultColumnsTemplateInstanceLevel() {
        return "class.name:0:" + String.valueOf(7) + ":left:200," + ":1:" + String.valueOf(47) + ":20," + "package.name" + ":2:" + String.valueOf(1) + ":left:100," + "object.base.time" + ":3:" + String.valueOf(1) + ":right:100," + "object.cumul.time" + ":4:" + String.valueOf(1) + ":right:100," + "object.calls" + ":5:" + String.valueOf(1) + ":right:50," + "object.cpu.time" + ":6:" + "0:right:100";
    }

    public String getDefaultColumnsTemplate() {
        String columns = super.getDefaultColumnsTemplate();
        if (columns == null) {
            columns = this.getLevel() == 4 ? this.getDefaultColumnsTemplateInstanceLevel() : "";
        }
        columns = String.valueOf(columns) + this.getColumnsTemplateExtensions(_numberOfColumns[_level - 1], "org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2", false);
        return columns;
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    public String getColumnsPreferencesKey() {
        this.setLevel(this.getLevel());
        if (this.getLevel() == 1) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "ExecStatsPack60";
        }
        if (this.getLevel() == 2) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "ExecStatsClass60";
        }
        if (this.getLevel() == 3) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "ExecStatsMethod60";
        }
        if (this.getLevel() == 4) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "ExecStatsInstance60";
        }
        return "";
    }

    public IContentProvider getContentProvider() {
        return new ExecutionStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ExecutionStatisticLabelProvider((StatisticView)this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ExecutionStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new ExecutionStatisticFilter();
    }

    protected String getViewTypeStr() {
        return "viewoption.execution2";
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
        super.doUpdateButtons(isPostponedOperation, processedOperations);
        ((ExecutionStatisticPage2)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
        if (this.getLevel() == 4) {
            ((ExecutionStatisticPage2)this.getTraceViewerPage()).deltaColumns().setChecked(false);
        } else {
            ((ExecutionStatisticPage2)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        }
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls((EObject)this._page.getMOFObject());
            if (this._totalCalls == 0) {
                this._totalCalls = 1;
            }
            this._maxTime = PerftraceUtil.getMaximumTime((EObject)this._page.getMOFObject());
            if (this._maxTime == 0.0) {
                this._maxTime = 1.0;
            }
            this._totalPackagesCumulativeTime = PerftraceUtil.getTotalPackagesCumulativeTime((EObject)this._page.getMOFObject());
            if (this._totalPackagesCumulativeTime == 0.0) {
                this._totalPackagesCumulativeTime = 1.0;
            }
            this._totalBaseTime = PerftraceUtil.getTotalBaseTime((EObject)this._page.getMOFObject());
            if (this._totalBaseTime == 0.0) {
                this._totalBaseTime = 1.0;
            }
            this._totalCumulativeTime = PerftraceUtil.getTotalCumulativeTime((EObject)this._page.getMOFObject());
            if (this._totalCumulativeTime == 0.0) {
                this._totalCumulativeTime = 1.0;
            }
            this._totalInheritedBaseTime = PerftraceUtil.getTotalInheritedBaseTime((EObject)this._page.getMOFObject());
            if (this._totalInheritedBaseTime == 0.0) {
                this._totalInheritedBaseTime = 1.0;
            }
            this._totalInheritedCumulativeTime = PerftraceUtil.getTotalInheritedCumulativeTime((EObject)this._page.getMOFObject());
            if (this._totalInheritedCumulativeTime == 0.0) {
                this._totalInheritedCumulativeTime = 1.0;
            }
            this._totalPackageCPUtime = this.getTotalPackageCPUtime();
            if (this._totalPackageCPUtime == 0.0) {
                this._totalPackageCPUtime = 1.0;
            }
        }
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._packageNameCol) {
            return ContextUpdaterHelper.updatePackageName(col, this._page.getMOFObject());
        }
        if (col == this._baseTimeCol) {
            return ContextUpdaterHelper.updateBaseTime(col, isDeltaColumn, this.isShowPercent(), this._totalBaseTime);
        }
        if (col == this._avgBaseTimeCol) {
            return ContextUpdaterHelper.updateAvgBaseTime(col, this.isShowPercent(), this._totalBaseTime);
        }
        if (col == this._inheritedBaseTimeCol) {
            return ContextUpdaterHelper.updateInhBaseTime(col, isDeltaColumn, this.isShowPercent(), this._totalInheritedBaseTime);
        }
        if (col == this._cumulativeTimeCol) {
            return ContextUpdaterHelper.updateCumulTime(col, isDeltaColumn, this.isShowPercent(), 0, this._totalPackagesCumulativeTime);
        }
        if (col == this._inheritedCumulativeTimeCol) {
            return ContextUpdaterHelper.updateInhCumulTime(col, isDeltaColumn, this.isShowPercent(), this._totalInheritedCumulativeTime);
        }
        if (col == this._callsCol) {
            return ContextUpdaterHelper.updateCalls(col, isDeltaColumn, this.isShowPercent(), true, this._totalCalls);
        }
        if (col == this._inheritedCallsCol) {
            return ContextUpdaterHelper.updateInhCalls(col, isDeltaColumn, this.isShowPercent(), this._totalCalls);
        }
        if (col == this._CPUTimeCol) {
            return ContextUpdaterHelper.updateCPUTime(col, isDeltaColumn, this.isShowPercent(), this._totalPackageCPUtime);
        }
        return super.getColumnDisplayInfo(col, isDeltaColumn);
    }

    protected double getTotalPackageCPUtime() {
        double totalPackageCPUtime = 0.0;
        List<TRCPackage> packagelist = null;
        packagelist = FilteringUtil.getFilteredPackages(this.getCurrentFilter(), FilteringUtil.getProcessList(this._page.getMOFObject()));
        int i = 0;
        while (i < packagelist.size()) {
            TRCPackage pack = packagelist.get(i);
            totalPackageCPUtime += pack.getTotalCpuTime();
            ++i;
        }
        return totalPackageCPUtime;
    }

    protected void searchInLevel(Tree tree, TreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        super.searchInLevel(tree, item, pack, cls, meth, trcObj);
        switch (this.getLevel()) {
            case 4: {
                if (cls == null) break;
                this.searchInClassLevel(tree, item, cls, null, trcObj);
            }
        }
    }

    protected void firstTimeUpdate() {
        super.firstTimeUpdate();
        this.redrawTable();
    }

    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        this._packageNameCol.resetMap();
        this._classNameCol.resetMap();
        this._methodNameCol.resetMap();
        this._instanceNameCol.resetMap();
        this._baseTimeCol.resetMap();
        this._avgBaseTimeCol.resetMap();
        this._inheritedBaseTimeCol.resetMap();
        this._cumulativeTimeCol.resetMap();
        this._inheritedCumulativeTimeCol.resetMap();
        this._callsCol.resetMap();
        this._inheritedCallsCol.resetMap();
        this._CPUTimeCol.resetMap();
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new ExecutionStatisticCellLabelProvider(colData);
    }

    public class ExecutionStatisticCellLabelProvider
    extends StatisticCellLabelProvider {
        public ExecutionStatisticCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((ExecutionStatisticLabelProvider)ExecutionStatisticView.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((ExecutionStatisticLabelProvider)ExecutionStatisticView.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class ExecutionStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        public ExecutionStatisticContentProvider() {
            super(ExecutionStatisticView.this);
        }

        public Object[] getChildren(Object element) {
            ExecutionStatisticView.this.tmpList.clear();
            if (element instanceof TRCPackage) {
                return FilteringUtil.getFilteredClasses(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCPackage)element)).toArray();
            }
            if (element instanceof TRCClass) {
                if (ExecutionStatisticView.this.getLevel() == 4) {
                    Object[] elements = FilteringUtil.getFilteredFullTraceObjects(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                    if (elements.length > 0) {
                        return elements;
                    }
                    return FilteringUtil.getFilteredHeapObjects(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                }
                return FilteringUtil.getFilteredMethods(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
            }
            return ExecutionStatisticView.this.tmpList.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            SimpleSearchQuery currentFilter = ExecutionStatisticView.this.getCurrentFilter();
            currentFilter = this.updateDynamicFilters(currentFilter, ExecutionStatisticView.this._page.getMOFObject());
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return FilteringUtil.getFilteredPackages(currentFilter, FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return FilteringUtil.getFilteredClasses(currentFilter, FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return FilteringUtil.getFilteredMethods(currentFilter, FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return FilteringUtil.getFilteredClasses(currentFilter, FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
            }
            return new ArrayList().toArray();
        }

        private SimpleSearchQuery updateDynamicFilters(SimpleSearchQuery filter, EObject object) {
            if (!DynamicFilter.containsDynamicFilters(filter)) {
                return filter;
            }
            return DynamicFilter.updateDynamicFilters(filter, object);
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(ExecutionStatisticView.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            String compareText = "";
            switch (ExecutionStatisticView.this.getLevel()) {
                case 1: {
                    if (!(element instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)element).getName().length() == 0) {
                        compareText = TraceUIMessages._87;
                        break;
                    }
                    compareText = ((TRCPackage)element).getName();
                    break;
                }
                case 2: {
                    if (!(element instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)element).getName();
                    break;
                }
                case 3: {
                    if (!(element instanceof TRCMethod)) {
                        return true;
                    }
                    compareText = ((TRCMethod)element).getName();
                    break;
                }
                case 4: {
                    if (!(element instanceof TRCClass)) break;
                    compareText = ((TRCClass)element).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class ExecutionStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public ExecutionStatisticLabelProvider(StatisticView viewer) {
            super(ExecutionStatisticView.this, viewer);
        }

        protected String getColumnTextPackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCPackage) {
                switch (pos) {
                    case 0: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._avgBaseTimeCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._inheritedBaseTimeCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._inheritedCumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 7: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                    }
                    case 8: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._inheritedCallsCol, info.isDeltaColumn());
                    }
                    case 9: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                    return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
                }
            } else {
                return this.getColumnTextClassLevel(obj, col);
            }
            return "";
        }

        protected String getColumnTextClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = ExecutionStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._classNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._avgBaseTimeCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._inheritedBaseTimeCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 7: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._inheritedCumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 8: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                    }
                    case 9: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._inheritedCallsCol, info.isDeltaColumn());
                    }
                    case 10: {
                        return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                    return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
                }
            } else {
                return this.getColumnTextMethodLevel(obj, col);
            }
            return "";
        }

        protected String getColumnTextMethodLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = ExecutionStatisticView.this.getMethodPosForLevel(info.getColumnData().getInitalPos());
            switch (pos) {
                case 0: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._methodNameCol, info.isDeltaColumn());
                }
                case 1: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                }
                case 2: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._classNameCol, info.isDeltaColumn());
                }
                case 3: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                }
                case 4: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                }
                case 5: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._avgBaseTimeCol, info.isDeltaColumn());
                }
                case 6: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                }
                case 7: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                }
                case 8: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                }
            }
            if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }

        protected String getColumnTextInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                return this.getColumnTextClassLevel(obj, col);
            }
            if (info.isDeltaColumn()) {
                return "";
            }
            switch (pos) {
                case 0: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._instanceNameCol, info.isDeltaColumn());
                }
                case 1: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                }
                case 2: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                }
                case 3: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                }
                case 4: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                }
                case 5: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                }
                case 6: {
                    return ExecutionStatisticView.this.getElementColumnText(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                }
            }
            if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }

        public String getColumnText(Object obj, int col) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return this.getColumnTextPackageLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return this.getColumnTextClassLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return this.getColumnTextMethodLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return this.getColumnTextInstanceLevel(obj, col);
            }
            return "";
        }

        protected Image getColumnImagePackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCPackage) {
                switch (pos) {
                    case 0: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._avgBaseTimeCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._inheritedBaseTimeCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._inheritedCumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 7: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                    }
                    case 8: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._inheritedCallsCol, info.isDeltaColumn());
                    }
                    case 9: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                    }
                }
            } else {
                return this.getColumnImageClassLevel(obj, col);
            }
            return null;
        }

        protected Image getColumnImageClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = ExecutionStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._classNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._avgBaseTimeCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._inheritedBaseTimeCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 7: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._inheritedCumulativeTimeCol, info.isDeltaColumn());
                    }
                    case 8: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                    }
                    case 9: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._inheritedCallsCol, info.isDeltaColumn());
                    }
                    case 10: {
                        return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                    }
                }
            } else {
                return this.getColumnImageMethodLevel(obj, col);
            }
            return null;
        }

        protected Image getColumnImageMethodLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = ExecutionStatisticView.this.getMethodPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            switch (pos) {
                case 0: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._methodNameCol, info.isDeltaColumn());
                }
                case 1: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                }
                case 2: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._classNameCol, info.isDeltaColumn());
                }
                case 3: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                }
                case 4: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                }
                case 5: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._avgBaseTimeCol, info.isDeltaColumn());
                }
                case 6: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                }
                case 7: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                }
                case 8: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                }
            }
            return null;
        }

        protected Image getColumnImageInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCClass) {
                return this.getColumnImageClassLevel(obj, col);
            }
            switch (pos) {
                case 0: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._instanceNameCol, info.isDeltaColumn());
                }
                case 1: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._newItemCol, info.isDeltaColumn());
                }
                case 2: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._packageNameCol, info.isDeltaColumn());
                }
                case 3: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._baseTimeCol, info.isDeltaColumn());
                }
                case 4: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._cumulativeTimeCol, info.isDeltaColumn());
                }
                case 5: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._callsCol, info.isDeltaColumn());
                }
                case 6: {
                    return ExecutionStatisticView.this.getElementColumnImage(obj, ExecutionStatisticView.this._CPUTimeCol, info.isDeltaColumn());
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int col) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return this.getColumnImagePackageLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return this.getColumnImageClassLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return this.getColumnImageMethodLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return this.getColumnImageInstanceLevel(obj, col);
            }
            return null;
        }
    }

    public class ExecutionStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public ExecutionStatisticSorter() {
            super(ExecutionStatisticView.this);
        }

        protected int comparePackageLevel(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCPackage && e2 instanceof TRCPackage) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                    }
                    case 1: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._newItemCol, this._info.isDeltaColumn());
                    }
                    case 2: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._baseTimeCol, this._info.isDeltaColumn());
                    }
                    case 3: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._avgBaseTimeCol, this._info.isDeltaColumn());
                    }
                    case 4: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._inheritedBaseTimeCol, this._info.isDeltaColumn());
                    }
                    case 5: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._cumulativeTimeCol, this._info.isDeltaColumn());
                    }
                    case 6: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._inheritedCumulativeTimeCol, this._info.isDeltaColumn());
                    }
                    case 7: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._callsCol, this._info.isDeltaColumn());
                    }
                    case 8: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._inheritedCallsCol, this._info.isDeltaColumn());
                    }
                    case 9: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._CPUTimeCol, this._info.isDeltaColumn());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            } else {
                return this.compareClassLevel(viewer, e1, e2);
            }
            return 0;
        }

        protected int compareClassLevel(Viewer viewer, Object e1, Object e2) {
            int pos = ExecutionStatisticView.this.getClassPosForLevel(this._pos);
            if (e1 instanceof TRCClass && e2 instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._classNameCol, this._info.isDeltaColumn());
                    }
                    case 1: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._newItemCol, this._info.isDeltaColumn());
                    }
                    case 2: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                    }
                    case 3: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._baseTimeCol, this._info.isDeltaColumn());
                    }
                    case 4: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._avgBaseTimeCol, this._info.isDeltaColumn());
                    }
                    case 5: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._inheritedBaseTimeCol, this._info.isDeltaColumn());
                    }
                    case 6: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._cumulativeTimeCol, this._info.isDeltaColumn());
                    }
                    case 7: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._inheritedCumulativeTimeCol, this._info.isDeltaColumn());
                    }
                    case 8: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._callsCol, this._info.isDeltaColumn());
                    }
                    case 9: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._inheritedCallsCol, this._info.isDeltaColumn());
                    }
                    case 10: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._CPUTimeCol, this._info.isDeltaColumn());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            } else {
                return this.compareMethodLevel(viewer, e1, e2);
            }
            return 0;
        }

        protected int compareMethodLevel(Viewer viewer, Object e1, Object e2) {
            int pos = ExecutionStatisticView.this.getMethodPosForLevel(this._pos);
            if (e1 instanceof TRCMethod && e2 instanceof TRCMethod) {
                switch (pos) {
                    case 0: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._methodNameCol, this._info.isDeltaColumn());
                    }
                    case 1: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._newItemCol, this._info.isDeltaColumn());
                    }
                    case 2: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._classNameCol, this._info.isDeltaColumn());
                    }
                    case 3: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                    }
                    case 4: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._baseTimeCol, this._info.isDeltaColumn());
                    }
                    case 5: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._avgBaseTimeCol, this._info.isDeltaColumn());
                    }
                    case 6: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._cumulativeTimeCol, this._info.isDeltaColumn());
                    }
                    case 7: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._callsCol, this._info.isDeltaColumn());
                    }
                    case 8: {
                        return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._CPUTimeCol, this._info.isDeltaColumn());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            }
            return 0;
        }

        protected int compareInstanceLevel(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCClass) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._instanceNameCol, this._info.isDeltaColumn());
                }
                case 1: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._newItemCol, this._info.isDeltaColumn());
                }
                case 2: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                }
                case 3: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._baseTimeCol, this._info.isDeltaColumn());
                }
                case 4: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._cumulativeTimeCol, this._info.isDeltaColumn());
                }
                case 5: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._callsCol, this._info.isDeltaColumn());
                }
                case 6: {
                    return this._sortSequence * ExecutionStatisticView.this.compareElements(e1, e2, ExecutionStatisticView.this._CPUTimeCol, this._info.isDeltaColumn());
                }
            }
            if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return this.comparePackageLevel(viewer, e1, e2);
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return this.compareMethodLevel(viewer, e1, e2);
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return this.compareInstanceLevel(viewer, e1, e2);
            }
            return 0;
        }
    }
}

