/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.internal.HierarchyXMIQueryEngine;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.models.trace.TRCLanguageElement;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringUtil {
    public static final boolean USE_ENGINE_FOR_HAS_CHILDREN = true;
    private static final boolean USE_NEW_IN_CONDITIONS = true;

    public static List<AbstractTRCProcess> getProcessList(EObject object) {
        int i;
        ArrayList<AbstractTRCProcess> processList = new ArrayList<AbstractTRCProcess>();
        if (object instanceof TRCMonitor) {
            i = 0;
            while (i < ((TRCMonitor)object).getNodes().size()) {
                processList.addAll(FilteringUtil.getProcessList((EObject)((TRCNode)((TRCMonitor)object).getNodes().get(i))));
                ++i;
            }
        }
        if (object instanceof TRCNode) {
            i = 0;
            while (i < ((TRCNode)object).getProcessProxies().size()) {
                processList.addAll(FilteringUtil.getProcessList((EObject)((TRCProcessProxy)((TRCNode)object).getProcessProxies().get(i))));
                ++i;
            }
        }
        if (object instanceof TRCProcessProxy) {
            i = 0;
            while (i < ((TRCProcessProxy)object).getAgentProxies().size()) {
                processList.addAll(FilteringUtil.getProcessList((EObject)((TRCAgentProxy)((TRCProcessProxy)object).getAgentProxies().get(i))));
                ++i;
            }
        }
        if (object instanceof TRCAgentProxy && "Profiler".equals(((TRCAgentProxy)object).getType())) {
            processList.add(((TRCAgentProxy)object).getAgent().getProcess());
        }
        if (object instanceof TRCProcess) {
            processList.add((AbstractTRCProcess)((TRCProcess)object));
        }
        return processList;
    }

    private static List<TRCLanguageElement> getFilteredElements(SimpleSearchQuery filter, EObject[] source, EClass outputEClass) {
        if (source == null) {
            return new ArrayList<TRCLanguageElement>();
        }
        if (source.length == 0) {
            return new ArrayList<TRCLanguageElement>();
        }
        if (filter == null) {
            return new ArrayList<TRCLanguageElement>();
        }
        filter.getSources().clear();
        Resource resource = null;
        int i = 0;
        while (i < source.length) {
            if (source[i] instanceof EObject) {
                filter.getSources().add((Object)EcoreUtil.getURI((EObject)source[i]).toString());
                if (resource == null) {
                    resource = source[i].eResource();
                }
            }
            ++i;
        }
        if (resource == null) {
            return new ArrayList<TRCLanguageElement>();
        }
        filter.getOutputElements().clear();
        SimpleOperand outputElement = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        outputElement.setType(outputEClass);
        filter.getOutputElements().add((Object)outputElement);
        HierarchyXMIQueryEngine engine = new HierarchyXMIQueryEngine();
        QueryResult result = engine.executeQuery((Query)filter, resource.getResourceSet(), (Collection)Collections.EMPTY_LIST);
        if (result == null) {
            return new ArrayList<TRCLanguageElement>();
        }
        List r = (List)((ResultEntry)result.getResultEntries().get(0)).getValue();
        return r;
    }

    private static SimpleSearchQuery getEmptyFilter() {
        SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        filter.setName("EmptyFilter");
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        filter.setWhereExpression((WhereExpression)logicalExpression);
        return filter;
    }

    public static List<TRCPackage> getFilteredPackages(SimpleSearchQuery filter, List source) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredPackages(filter, sourceEObjects);
    }

    public static List<TRCPackage> getFilteredPackages(SimpleSearchQuery filter, EObject source) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredPackages(filter, sourceEObjects);
    }

    public static List<TRCPackage> getFilteredPackages(SimpleSearchQuery filter, EObject[] source) {
        filter = filter == null ? FilteringUtil.getEmptyFilter() : (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCPackage());
        List<TRCLanguageElement> allPackages = FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCPackage());
        ArrayList<TRCPackage> list = new ArrayList<TRCPackage>();
        int i = 0;
        while (i < allPackages.size()) {
            TRCPackage pack = (TRCPackage)allPackages.get(i);
            if (pack.getClasses().size() > 0) {
                list.add(pack);
            }
            ++i;
        }
        return list;
    }

    public static List getFilteredClasses(SimpleSearchQuery filter, List source) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredClasses(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredClasses(SimpleSearchQuery filter, EObject source) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredClasses(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredClasses(SimpleSearchQuery filter, EObject[] source) {
        if (filter == null) {
            filter = FilteringUtil.getEmptyFilter();
        } else {
            filter = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
            FilteringUtil.replaceOrderByConditionToClasses(filter);
        }
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCClass());
        return FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCClass());
    }

    public static List<TRCLanguageElement> getFilteredMethods(SimpleSearchQuery filter, List source) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredMethods(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredMethods(SimpleSearchQuery filter, EObject source) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredMethods(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredMethods(SimpleSearchQuery filter, EObject[] source) {
        if (filter == null) {
            filter = FilteringUtil.getEmptyFilter();
        } else {
            filter = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
            FilteringUtil.replaceOrderByConditionToMethods(filter);
        }
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCMethod());
        return FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCMethod());
    }

    public static List<TRCLanguageElement> getFilteredObjects(SimpleSearchQuery filter, List source) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredObjects(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredObjects(SimpleSearchQuery filter, EObject source) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredObjects(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredObjects(SimpleSearchQuery filter, EObject[] source) {
        if (filter == null) {
            filter = FilteringUtil.getEmptyFilter();
        } else {
            filter = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
            FilteringUtil.replaceOrderByConditionToFullTraceObjects(filter);
        }
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCObject());
        HashSet<EClass> removeClasses = new HashSet<EClass>();
        removeClasses.add(TracePackage.eINSTANCE.getTRCMethod());
        filter = QueryUtils.removeClasses((SimpleSearchQuery)filter, removeClasses);
        return FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCObject());
    }

    public static List<TRCLanguageElement> getFilteredFullTraceObjects(SimpleSearchQuery filter, List source) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredFullTraceObjects(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredFullTraceObjects(SimpleSearchQuery filter, EObject source) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredFullTraceObjects(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredFullTraceObjects(SimpleSearchQuery filter, EObject[] source) {
        if (filter == null) {
            filter = FilteringUtil.getEmptyFilter();
        } else {
            filter = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
            FilteringUtil.replaceOrderByConditionToFullTraceObjects(filter);
        }
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCFullTraceObject());
        HashSet<EClass> removeClasses = new HashSet<EClass>();
        removeClasses.add(TracePackage.eINSTANCE.getTRCMethod());
        filter = QueryUtils.removeClasses((SimpleSearchQuery)filter, removeClasses);
        return FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCFullTraceObject());
    }

    public static List<TRCLanguageElement> getFilteredHeapObjects(SimpleSearchQuery filter, List source, boolean inClassObjects) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredHeapObjects(filter, sourceEObjects, inClassObjects);
    }

    public static List<TRCLanguageElement> getFilteredHeapObjects(SimpleSearchQuery filter, EObject source, boolean inClassObjects) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredHeapObjects(filter, sourceEObjects, inClassObjects);
    }

    public static List<TRCLanguageElement> getFilteredHeapObjects(SimpleSearchQuery filter, List source) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredHeapObjects(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredHeapObjects(SimpleSearchQuery filter, EObject source) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredHeapObjects(filter, sourceEObjects);
    }

    public static List<TRCLanguageElement> getFilteredHeapObjects(SimpleSearchQuery filter, EObject[] source) {
        return FilteringUtil.getFilteredHeapObjects(filter, source, false);
    }

    public static List<TRCLanguageElement> getFilteredHeapObjects(SimpleSearchQuery filter, EObject[] source, boolean inClassObjects) {
        if (filter == null) {
            filter = FilteringUtil.getEmptyFilter();
        } else {
            filter = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
            FilteringUtil.replaceOrderByConditionToHeapObjects(filter);
        }
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCHeapObject(), inClassObjects, false);
        HashSet<EClass> removeClasses = new HashSet<EClass>();
        removeClasses.add(TracePackage.eINSTANCE.getTRCMethod());
        filter = QueryUtils.removeClasses((SimpleSearchQuery)filter, removeClasses);
        return FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCHeapObject());
    }

    public static List<TRCLanguageElement> getFilteredObjectReferences(SimpleSearchQuery filter, List source, boolean owner) {
        EObject[] sourceEObjects = new EObject[source.size()];
        source.toArray(sourceEObjects);
        return FilteringUtil.getFilteredObjectReferences(filter, sourceEObjects, owner);
    }

    public static List<TRCLanguageElement> getFilteredObjectReferences(SimpleSearchQuery filter, EObject source, boolean owner) {
        EObject[] sourceEObjects = new EObject[]{source};
        return FilteringUtil.getFilteredObjectReferences(filter, sourceEObjects, owner);
    }

    public static List<TRCLanguageElement> getFilteredObjectReferences(SimpleSearchQuery filter, EObject[] source, boolean owner) {
        if (filter == null) {
            filter = FilteringUtil.getEmptyFilter();
        } else {
            filter = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
            FilteringUtil.replaceOrderByConditionToHeapObjects(filter);
        }
        FilteringUtil.addInConditions((LogicalExpression)filter.getWhereExpression(), source, TracePackage.eINSTANCE.getTRCObjectReference(), false, owner);
        HashSet removeClasses = new HashSet();
        filter = QueryUtils.removeClasses((SimpleSearchQuery)filter, removeClasses);
        return FilteringUtil.getFilteredElements(filter, source, TracePackage.eINSTANCE.getTRCObjectReference());
    }

    private static void addClassInPackageCondition(LogicalExpression logicalExpression) {
        FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCClass(), TracePackage.eINSTANCE.getTRCPackage_Classes());
    }

    private static void addMethodInClassCondition(LogicalExpression logicalExpression) {
        FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCMethod(), TracePackage.eINSTANCE.getTRCClass_Methods());
    }

    private static void addObjectInClassCondition(LogicalExpression logicalExpression) {
        FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCObject(), TracePackage.eINSTANCE.getTRCClass_Objects());
    }

    private static void addFullTraceObjectInClassCondition(LogicalExpression logicalExpression) {
        FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCFullTraceObject(), TracePackage.eINSTANCE.getTRCClass_Objects());
    }

    private static void addHeapObjectInClassCondition(LogicalExpression logicalExpression, boolean inClassObjects, boolean fromObject) {
        if (inClassObjects) {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCHeapObject(), TracePackage.eINSTANCE.getTRCClass_ClassObjects());
        } else if (fromObject) {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCClass(), TracePackage.eINSTANCE.getTRCObject_IsA());
        } else {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCHeapObject(), TracePackage.eINSTANCE.getTRCClass_Objects());
        }
    }

    private static void addObjectReferenceInHeapObjectCondition(LogicalExpression logicalExpression, boolean owner) {
        if (owner) {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCObjectReference(), TracePackage.eINSTANCE.getTRCHeapObject_RefOwner());
        } else {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCObjectReference(), TracePackage.eINSTANCE.getTRCHeapObject_RefTarget());
        }
    }

    private static void addInCondition(LogicalExpression logicalExpression, EClass left, EReference right) {
        BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand lhs = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        lhs.setType(left);
        binaryExpression.setOperator(RelationalOperators.IN_LITERAL);
        SimpleOperand rhs = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        rhs.setFeature((EStructuralFeature)right);
        binaryExpression.setLeftOperand((Operand)lhs);
        binaryExpression.getRightOperands().add((Object)rhs);
        logicalExpression.getArguments().add((Object)binaryExpression);
    }

    private static void addInConditions(LogicalExpression logicalExpression, EObject[] source, EClass outputEClass) {
        FilteringUtil.addInConditions(logicalExpression, source, outputEClass, false, false);
    }

    private static boolean mapHasHigherLevel(Map cp, EClass outputEClass) {
        EClass parent = FilteringUtil.getParent(outputEClass);
        if (parent == null) {
            return false;
        }
        if (cp.containsKey(parent)) {
            return true;
        }
        return FilteringUtil.mapHasHigherLevel(cp, parent);
    }

    private static void addInConditionsUpTree(List<EClass> outputToAdd, Map cp, EClass outputEClass) {
        if (FilteringUtil.mapHasHigherLevel(cp, outputEClass)) {
            FilteringUtil.addToList(outputToAdd, outputEClass);
            FilteringUtil.addInConditionsUpTree(outputToAdd, cp, FilteringUtil.getParent(outputEClass));
        }
    }

    private static boolean isInParent(EClass parent, EClass child) {
        if (parent.equals(child)) {
            return true;
        }
        if ((child = FilteringUtil.getParent(child)) == null) {
            return false;
        }
        return FilteringUtil.isInParent(parent, child);
    }

    private static void addInConditionsUpTreeToClass(List<EClass> outputToAdd, Map cp, EClass outputEClass, EClass toEClass, boolean addOutputEClass) {
        if (outputEClass == null || toEClass != null && FilteringUtil.isInParent(outputEClass, toEClass)) {
            return;
        }
        if (addOutputEClass || cp.containsKey(outputEClass)) {
            FilteringUtil.addToList(outputToAdd, outputEClass);
            FilteringUtil.addInConditionsUpTreeToClass(outputToAdd, cp, FilteringUtil.getParent(outputEClass), toEClass, true);
            return;
        }
        FilteringUtil.addInConditionsUpTreeToClass(outputToAdd, cp, FilteringUtil.getParent(outputEClass), toEClass, false);
    }

    private static void addToList(List<EClass> list, EClass toAdd) {
        if (!list.contains(toAdd)) {
            if (toAdd.equals(TracePackage.eINSTANCE.getTRCFullTraceObject()) || toAdd.equals(TracePackage.eINSTANCE.getTRCHeapObject())) {
                if (!list.contains(TracePackage.eINSTANCE.getTRCObject())) {
                    list.add(toAdd);
                }
            } else if (toAdd.equals(TracePackage.eINSTANCE.getTRCObject())) {
                if (list.contains(TracePackage.eINSTANCE.getTRCFullTraceObject())) {
                    list.remove(TracePackage.eINSTANCE.getTRCFullTraceObject());
                }
                if (list.contains(TracePackage.eINSTANCE.getTRCHeapObject())) {
                    list.remove(TracePackage.eINSTANCE.getTRCHeapObject());
                }
                list.add(toAdd);
            } else {
                list.add(toAdd);
            }
        }
    }

    private static void addInConditionsFromLeaves(List<EClass> outputToAdd, LogicalExpression logicalExpression, EClass outputEClass, boolean inClassObjects, boolean owner) {
        Map cp = QueryUtils.getClassPredicatesIndex((SimpleSearchQuery)logicalExpression.getSearchQuery());
        FilteringUtil.addInConditionsUpTreeToClass(outputToAdd, cp, TracePackage.eINSTANCE.getTRCMethod(), outputEClass, false);
        FilteringUtil.addInConditionsUpTreeToClass(outputToAdd, cp, TracePackage.eINSTANCE.getTRCObject(), outputEClass, false);
        FilteringUtil.addInConditionsUpTreeToClass(outputToAdd, cp, TracePackage.eINSTANCE.getTRCFullTraceObject(), outputEClass, false);
        FilteringUtil.addInConditionsUpTreeToClass(outputToAdd, cp, TracePackage.eINSTANCE.getTRCObjectReference(), outputEClass, false);
        int i = 0;
        while (i < outputToAdd.size()) {
            FilteringUtil.addInConditionForOutput(logicalExpression, outputToAdd.get(i), inClassObjects, owner, outputEClass.equals(TracePackage.eINSTANCE.getTRCObjectReference()));
            ++i;
        }
    }

    private static void addInConditionsNew(LogicalExpression logicalExpression, EObject[] source, EClass outputEClass, boolean inClassObjects, boolean owner) {
        Map cp = QueryUtils.getClassPredicatesIndex((SimpleSearchQuery)logicalExpression.getSearchQuery());
        ArrayList<EClass> outputToAdd = new ArrayList<EClass>();
        FilteringUtil.addInConditionsFromLeaves(outputToAdd, logicalExpression, outputEClass, inClassObjects, owner);
        int j = outputToAdd.size();
        if (cp.containsKey(TracePackage.eINSTANCE.getTRCThread())) {
            if (outputEClass.equals(TracePackage.eINSTANCE.getTRCFullTraceObject())) {
                FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCThread(), TracePackage.eINSTANCE.getTRCTraceObject_Thread());
            } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCClass()) || outputEClass.equals(TracePackage.eINSTANCE.getTRCPackage()) || outputEClass.equals(TracePackage.eINSTANCE.getTRCMethod())) {
                FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCThread(), TracePackage.eINSTANCE.getTRCClass_LoadedBy());
            }
            if (outputEClass.equals(TracePackage.eINSTANCE.getTRCPackage())) {
                FilteringUtil.addToList(outputToAdd, TracePackage.eINSTANCE.getTRCClass());
            }
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCFullTraceObject()) || outputEClass.equals(TracePackage.eINSTANCE.getTRCHeapObject()) || outputEClass.equals(TracePackage.eINSTANCE.getTRCObject()) || outputEClass.equals(TracePackage.eINSTANCE.getTRCObjectReference())) {
            FilteringUtil.addToList(outputToAdd, outputEClass);
        }
        FilteringUtil.addInConditionsUpTree(outputToAdd, cp, outputEClass);
        int i = j;
        while (i < outputToAdd.size()) {
            FilteringUtil.addInConditionForOutput(logicalExpression, (EClass)outputToAdd.get(i), inClassObjects, owner, outputEClass.equals(TracePackage.eINSTANCE.getTRCObjectReference()));
            ++i;
        }
    }

    private static EClass getParent(EClass outputEClass) {
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCMethod())) {
            return TracePackage.eINSTANCE.getTRCClass();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCFullTraceObject())) {
            return TracePackage.eINSTANCE.getTRCClass();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCHeapObject())) {
            return TracePackage.eINSTANCE.getTRCClass();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCObject())) {
            return TracePackage.eINSTANCE.getTRCClass();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCObjectReference())) {
            return TracePackage.eINSTANCE.getTRCHeapObject();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCClass())) {
            return TracePackage.eINSTANCE.getTRCPackage();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCPackage())) {
            return TracePackage.eINSTANCE.getTRCProcess();
        }
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCProcess())) {
            return HierarchyPackage.eINSTANCE.getTRCAgent();
        }
        if (outputEClass.equals(HierarchyPackage.eINSTANCE.getTRCAgent())) {
            return HierarchyPackage.eINSTANCE.getTRCAgentProxy();
        }
        if (outputEClass.equals(HierarchyPackage.eINSTANCE.getTRCAgentProxy())) {
            return HierarchyPackage.eINSTANCE.getTRCProcessProxy();
        }
        if (outputEClass.equals(HierarchyPackage.eINSTANCE.getTRCProcessProxy())) {
            return HierarchyPackage.eINSTANCE.getTRCNode();
        }
        return null;
    }

    private static void addInConditionForOutput(LogicalExpression logicalExpression, EClass outputEClass, boolean inClassObjects, boolean owner, boolean fromObj) {
        if (outputEClass.equals(TracePackage.eINSTANCE.getTRCMethod())) {
            FilteringUtil.addMethodInClassCondition(logicalExpression);
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCFullTraceObject())) {
            FilteringUtil.addFullTraceObjectInClassCondition(logicalExpression);
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCHeapObject())) {
            FilteringUtil.addHeapObjectInClassCondition(logicalExpression, inClassObjects, fromObj);
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCObject())) {
            FilteringUtil.addObjectInClassCondition(logicalExpression);
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCObjectReference())) {
            FilteringUtil.addObjectReferenceInHeapObjectCondition(logicalExpression, owner);
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCClass())) {
            FilteringUtil.addClassInPackageCondition(logicalExpression);
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCPackage())) {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCPackage(), TracePackage.eINSTANCE.getTRCProcess_Packages());
        } else if (outputEClass.equals(TracePackage.eINSTANCE.getTRCProcess())) {
            FilteringUtil.addInCondition(logicalExpression, TracePackage.eINSTANCE.getTRCProcess(), HierarchyPackage.eINSTANCE.getTRCAgent_Process());
        } else if (outputEClass.equals(HierarchyPackage.eINSTANCE.getTRCAgent())) {
            FilteringUtil.addInCondition(logicalExpression, HierarchyPackage.eINSTANCE.getTRCAgentProxy(), HierarchyPackage.eINSTANCE.getTRCAgent_AgentProxy());
        } else if (outputEClass.equals(HierarchyPackage.eINSTANCE.getTRCAgentProxy())) {
            FilteringUtil.addInCondition(logicalExpression, HierarchyPackage.eINSTANCE.getTRCProcessProxy(), HierarchyPackage.eINSTANCE.getTRCAgentProxy_ProcessProxy());
        } else if (outputEClass.equals(HierarchyPackage.eINSTANCE.getTRCProcessProxy())) {
            FilteringUtil.addInCondition(logicalExpression, HierarchyPackage.eINSTANCE.getTRCNode(), HierarchyPackage.eINSTANCE.getTRCProcessProxy_Node());
        }
    }

    private static void addInConditions(LogicalExpression logicalExpression, EObject[] source, EClass outputEClass, boolean inClassObjects, boolean owner) {
        FilteringUtil.addInConditionsNew(logicalExpression, source, outputEClass, inClassObjects, owner);
    }

    private static void replaceOrderByConditionToClasses(SimpleSearchQuery filter) {
        if (filter.getOrderByExpresions().size() == 1) {
            OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
            SimpleOperand operand = (SimpleOperand)orderByElement.getOperand();
            if (TracePackageImpl.init().getTRCPackage_BaseTime().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_BaseTime());
            } else if (TracePackageImpl.init().getTRCPackage_CumulativeTime().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_CumulativeTime());
            } else if (TracePackageImpl.init().getTRCPackage_Calls().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_Calls());
            } else if (TracePackageImpl.init().getTRCPackage_TotalSize().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_TotalSize());
            } else if (TracePackageImpl.init().getTRCPackage_CollectedSize().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_CollectedSize());
            } else if (TracePackageImpl.init().getTRCPackage_TotalInstances().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_TotalInstances());
            } else if (TracePackageImpl.init().getTRCPackage_CollectedInstances().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCClass_CollectedInstances());
            } else {
                filter.getOrderByExpresions().clear();
            }
        }
    }

    private static void replaceOrderByConditionToMethods(SimpleSearchQuery filter) {
        if (filter.getOrderByExpresions().size() == 1) {
            OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
            SimpleOperand operand = (SimpleOperand)orderByElement.getOperand();
            if (TracePackageImpl.init().getTRCPackage_BaseTime().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCMethod_BaseTime());
            } else if (TracePackageImpl.init().getTRCPackage_CumulativeTime().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCMethod_CumulativeTime());
            } else if (TracePackageImpl.init().getTRCPackage_Calls().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCMethod_Calls());
            } else {
                filter.getOrderByExpresions().clear();
            }
        }
    }

    private static void replaceOrderByConditionToFullTraceObjects(SimpleSearchQuery filter) {
        if (filter.getOrderByExpresions().size() == 1) {
            OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
            SimpleOperand operand = (SimpleOperand)orderByElement.getOperand();
            if (TracePackageImpl.init().getTRCPackage_BaseTime().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCFullTraceObject_BaseTime());
            } else if (TracePackageImpl.init().getTRCPackage_CumulativeTime().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCFullTraceObject_CumulativeTime());
            } else if (TracePackageImpl.init().getTRCPackage_Calls().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCFullTraceObject_Calls());
            } else {
                FilteringUtil.replaceOrderByConditionToObjects(filter);
            }
        }
    }

    private static void replaceOrderByConditionToHeapObjects(SimpleSearchQuery filter) {
        FilteringUtil.replaceOrderByConditionToObjects(filter);
    }

    private static void replaceOrderByConditionToObjects(SimpleSearchQuery filter) {
        if (filter.getOrderByExpresions().size() == 1) {
            OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
            SimpleOperand operand = (SimpleOperand)orderByElement.getOperand();
            if (TracePackageImpl.init().getTRCPackage_TotalSize().equals(operand.getFeature())) {
                operand.setFeature((EStructuralFeature)TracePackageImpl.init().getTRCObject_Size());
            } else {
                filter.getOrderByExpresions().clear();
            }
        }
    }
}

