/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.io.Serializable;
import org.eclipse.hyades.trace.views.internal.CategoricalClassification;
import org.eclipse.hyades.trace.views.internal.Classification;
import org.eclipse.hyades.trace.views.internal.ColorScheme;
import org.eclipse.hyades.trace.views.internal.QuantitativeClassification;
import org.eclipse.swt.graphics.Color;

public class Mapping
implements Serializable {
    private static final long serialVersionUID = 3545799887989061432L;
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_LINE = 1;
    private String _title;
    private String _description;
    private ColorScheme _colorScheme;
    private Classification _classification;
    private int _shape;
    private boolean _isLongValue = true;

    public Mapping(Classification classification, ColorScheme colorScheme, String title, int shape) {
        this.setClassification(classification);
        this.setColorScheme(colorScheme);
        this.setTitle(title);
        this.setShape(shape);
    }

    public Classification classification() {
        return this._classification;
    }

    public Color color(long value) {
        QuantitativeClassification classification = (QuantitativeClassification)this._classification;
        int bucket = classification.bucket(value);
        return this._colorScheme.color(bucket, classification.numBuckets());
    }

    public Color color(Object value) {
        CategoricalClassification classification = (CategoricalClassification)this._classification;
        int bucket = classification.bucket(value);
        return this._colorScheme.color(bucket, classification.numBuckets());
    }

    public ColorScheme colorScheme() {
        return this._colorScheme;
    }

    public String description() {
        return this._description;
    }

    public boolean isLongValue() {
        return this._isLongValue;
    }

    public void isLongValue(boolean value) {
        this._isLongValue = value;
    }

    public static Mapping load(String filename) {
        return null;
    }

    public void save(String filename) {
    }

    public void setClassification(Classification c) {
        this._classification = c;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this._colorScheme = colorScheme;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setShape(int shape) {
        this._shape = shape;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public int shape() {
        return this._shape;
    }

    public String title() {
        return this._title;
    }
}

