/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.MethodDetailsTab;
import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.MethodDetails;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class MethodDetailsStatistic
extends ExecutionStatisticView {
    protected MethodDetailsTab _tabItem;
    public static final int PARENT_DETAILS = 0;
    public static final int METHOD_DETAILS = 1;
    public static final int CHILDREN_DETAILS = 2;
    private static int _level = 3;
    protected int _methodDetailsType = 1;
    protected MethodDetails _container;

    public MethodDetailsStatistic(Composite parent, MethodDetailsTab tabItem, boolean initializeContent) {
        super(parent, tabItem.getPage(), initializeContent);
        this._tabItem = tabItem;
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".mthid0000";
    }

    public MethodDetailsStatistic(Composite parent, MethodDetailsTab tabItem) {
        this(parent, tabItem, true);
    }

    public String getDefaultColumnsTemplate() {
        StringBuffer buffer = new StringBuffer();
        switch (this._methodDetailsType) {
            case 2: {
                buffer.append(TraceUIMessages._173);
                break;
            }
            case 0: {
                buffer.append(TraceUIMessages._172);
                break;
            }
            case 1: {
                buffer.append("method.calls");
            }
        }
        buffer.append(":0:").append(String.valueOf(1)).append(":right:80,").append("method.name").append(":1:").append(String.valueOf(7)).append(":left:200,").append("").append(":2:").append(String.valueOf(47)).append(":20,").append("class.name").append(":3:").append(String.valueOf(1)).append(":left:100,").append("package.name").append(":4:").append(String.valueOf(1)).append(":left:100,").append("method.base.time").append(":5:").append(String.valueOf(17)).append(":right:100,").append("method.avg.base.time").append(":6:").append(String.valueOf(1)).append(":right:100,").append("method.cumul.time").append(":7:");
        if (this.getMethodDetailsType() != 1) {
            buffer.append(String.valueOf(17)).append(":right:100,").append("method.calls").append(":8:").append(String.valueOf(17)).append(":right:55,").append("method.cpu.time").append(":9:").append(String.valueOf(1)).append(":right:100");
        } else {
            buffer.append(String.valueOf(17)).append(":right:100,").append("method.cpu.time").append(":8:").append(String.valueOf(1)).append(":right:100");
        }
        return buffer.toString();
    }

    public String getColumnsPreferencesKey() {
        String key = "";
        switch (this._methodDetailsType) {
            case 2: {
                key = "MDet_Child49";
                break;
            }
            case 0: {
                key = "MDet_Parent49";
                break;
            }
            case 1: {
                key = "MDet_Method49";
            }
        }
        return key;
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
        this._tabItem.percentMode().setChecked(this.isShowPercent());
    }

    public int getMethodDetailsType() {
        return this._methodDetailsType;
    }

    public void setMethodDetailsType(int detailsType) {
        this._methodDetailsType = detailsType;
    }

    public IContentProvider getContentProvider() {
        return new MethodStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MethodStatisticLabelProvider((StatisticView)this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new MethodStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new MethodStatisticFilter();
    }

    public String printTitle() {
        String newLine = System.getProperties().getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<caption align=top><B>" + newLine);
        buffer.append(this._tabItem.getContentDescription()).append(newLine);
        buffer.append("</B></caption>").append(newLine);
        return buffer.toString();
    }

    protected void showPercentUpdate() {
        super.showPercentUpdate();
    }

    public MethodDetails getContainer() {
        return this._container;
    }

    public void setContainer(MethodDetails _container) {
        this._container = _container;
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    protected void firstTimeUpdate() {
        super.firstTimeUpdate();
        this.redrawTable();
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new MethodStatisticCellLabelProvider(colData);
    }

    public class MethodStatisticCellLabelProvider
    extends StatisticCellLabelProvider {
        public MethodStatisticCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((MethodStatisticLabelProvider)MethodDetailsStatistic.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((MethodStatisticLabelProvider)MethodDetailsStatistic.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class MethodStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        private HashMap tmpMap;

        public MethodStatisticContentProvider() {
            super(MethodDetailsStatistic.this);
            this.tmpMap = new HashMap();
        }

        public Object[] getChildren(Object element) {
            MethodDetailsStatistic.this.tmpList.clear();
            return MethodDetailsStatistic.this.tmpList.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            MethodDetailsStatistic.this.tmpList.clear();
            TRCMethod method = MethodDetailsStatistic.this._tabItem.getCurrentSelection();
            if (method != null) {
                switch (MethodDetailsStatistic.this._methodDetailsType) {
                    case 2: {
                        return this.getChildrenMethods(method);
                    }
                    case 0: {
                        return this.getParentMethods(method);
                    }
                    case 1: {
                        MethodDetailsStatistic.this.tmpList.add(method);
                    }
                }
            }
            return MethodDetailsStatistic.this.tmpList.toArray();
        }

        protected Object[] getObjectArray() {
            Object[] ret = MethodDetailsStatistic.this.tmpList.toArray();
            MethodDetailsStatistic.this.tmpList.clear();
            return ret;
        }

        protected Object[] getChildrenMethods(Object object) {
            MethodDetailsStatistic.this.tmpList.clear();
            this.tmpMap.clear();
            TRCMethod method = null;
            if (object instanceof TRCMethod) {
                method = (TRCMethod)object;
            } else if (object instanceof TRCMethodInvocation) {
                method = ((TRCMethodInvocation)object).getMethod();
            }
            if (method == null) {
                return this.getObjectArray();
            }
            for (TRCMethodInvocation inv : method.getInvocations()) {
                for (TRCMethodInvocation child_inv : inv.getInvokes()) {
                    Object value;
                    TRCMethod m = child_inv.getMethod();
                    int count = 1;
                    if (child_inv instanceof TRCAggregatedMethodInvocation) {
                        count = ((TRCAggregatedMethodInvocation)child_inv).getCount();
                    }
                    if ((value = this.tmpMap.get(m)) != null) {
                        this.tmpMap.put(m, new Integer((Integer)value + count));
                        continue;
                    }
                    this.tmpMap.put(m, new Integer(count));
                }
            }
            for (TRCMethod m : this.tmpMap.keySet()) {
                MethodDetailsStatistic.this.tmpList.add(new MethodCallDetails(m, (Integer)this.tmpMap.get(m)));
            }
            this.tmpMap.clear();
            return this.getObjectArray();
        }

        protected Object[] getParentMethods(Object object) {
            MethodDetailsStatistic.this.tmpList.clear();
            this.tmpMap.clear();
            TRCMethod method = null;
            if (object instanceof TRCMethod) {
                method = (TRCMethod)object;
            } else if (object instanceof TRCMethodInvocation) {
                method = ((TRCMethodInvocation)object).getMethod();
            }
            if (method == null) {
                return this.getObjectArray();
            }
            int methodCalls = method.getCalls();
            int parents = 0;
            for (TRCMethodInvocation inv : method.getInvocations()) {
                if (inv.getInvokedBy() == null) continue;
                TRCMethod m = inv.getInvokedBy().getMethod();
                int count = 1;
                if (inv instanceof TRCAggregatedMethodInvocation) {
                    count = ((TRCAggregatedMethodInvocation)inv).getCount();
                }
                parents += count;
                Object value = this.tmpMap.get(m);
                if (value != null) {
                    this.tmpMap.put(m, new Integer((Integer)value + count));
                    continue;
                }
                this.tmpMap.put(m, new Integer(count));
            }
            for (TRCMethod m : this.tmpMap.keySet()) {
                MethodDetailsStatistic.this.tmpList.add(new MethodCallDetails(m, (Integer)this.tmpMap.get(m)));
            }
            if (methodCalls > parents) {
                MethodDetailsStatistic.this.tmpList.add(new MethodCallDetails(null, methodCalls - parents));
            }
            this.tmpMap.clear();
            return this.getObjectArray();
        }
    }

    public class MethodStatisticFilter
    extends StatisticView.StatisticFilter {
        public MethodStatisticFilter() {
            super(MethodDetailsStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            String compareText = "";
            if (element instanceof TRCMethod) {
                compareText = ((TRCMethod)element).getName();
            } else if (element instanceof MethodCallDetails) {
                compareText = ((MethodCallDetails)element).getMethod().getName();
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class MethodStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public MethodStatisticLabelProvider(StatisticView viewer) {
            super(MethodDetailsStatistic.this, viewer);
        }

        public String getColumnText(Object obj, int col) {
            MethodCallDetails methodDetails;
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = MethodDetailsStatistic.this.getMethodPosForLevel(info.getColumnData().getInitalPos());
            TRCMethod m = null;
            if (obj instanceof TRCMethod) {
                m = (TRCMethod)obj;
            } else if (obj instanceof MethodCallDetails && (m = (methodDetails = (MethodCallDetails)obj).getMethod()) == null) {
                if (pos == 0) {
                    int calls = methodDetails.getCalls();
                    return MethodDetailsStatistic.this.isShowPercent() ? TString.formatAsPercentage((double)((double)calls / (double)MethodDetailsStatistic.this._totalCalls)) : String.valueOf(calls);
                }
                if (pos == 1) {
                    return TraceUIMessages._274;
                }
            }
            if (m == null) {
                return "";
            }
            TRCMethod selection = MethodDetailsStatistic.this._container.getCurrentSelection();
            int nb = 0;
            switch (pos) {
                case 0: {
                    switch (MethodDetailsStatistic.this._methodDetailsType) {
                        case 2: {
                            if (obj instanceof MethodCallDetails) {
                                nb = ((MethodCallDetails)obj).getCalls();
                            } else if (selection != null) {
                                for (TRCMethodInvocation childMi : m.getInvocations()) {
                                    TRCMethodInvocation mi = childMi.getInvokedBy();
                                    if (mi == null || !mi.getMethod().equals(selection)) continue;
                                    if (childMi instanceof TRCAggregatedMethodInvocation) {
                                        nb += ((TRCAggregatedMethodInvocation)childMi).getCount();
                                        continue;
                                    }
                                    ++nb;
                                }
                            }
                            if (MethodDetailsStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)nb / (double)MethodDetailsStatistic.this._totalCalls));
                            }
                            return String.valueOf(nb);
                        }
                        case 0: {
                            if (obj instanceof MethodCallDetails) {
                                nb = ((MethodCallDetails)obj).getCalls();
                            } else if (selection != null) {
                                for (TRCMethodInvocation mi : selection.getInvocations()) {
                                    if (mi == null || mi.getInvokedBy() == null || !mi.getInvokedBy().getMethod().equals(m)) continue;
                                    if (mi instanceof TRCAggregatedMethodInvocation) {
                                        nb += ((TRCAggregatedMethodInvocation)mi).getCount();
                                        continue;
                                    }
                                    ++nb;
                                }
                            }
                            if (MethodDetailsStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)nb / (double)MethodDetailsStatistic.this._totalCalls));
                            }
                            return String.valueOf(nb);
                        }
                        case 1: {
                            return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._callsCol, info.isDeltaColumn());
                        }
                    }
                }
                case 1: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._methodNameCol, info.isDeltaColumn());
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._classNameCol, info.isDeltaColumn());
                }
                case 4: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._packageNameCol, info.isDeltaColumn());
                }
                case 5: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._baseTimeCol, info.isDeltaColumn());
                }
                case 6: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._avgBaseTimeCol, info.isDeltaColumn());
                }
                case 7: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._cumulativeTimeCol, info.isDeltaColumn());
                }
                case 8: {
                    switch (MethodDetailsStatistic.this._methodDetailsType) {
                        case 0: {
                            return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._callsCol, info.isDeltaColumn());
                        }
                        case 2: {
                            return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._callsCol, info.isDeltaColumn());
                        }
                    }
                }
                case 9: {
                    return MethodDetailsStatistic.this.getElementColumnText(m, MethodDetailsStatistic.this._CPUTimeCol, info.isDeltaColumn());
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = MethodDetailsStatistic.this.getMethodPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            TRCMethod m = null;
            if (obj instanceof TRCMethod) {
                m = (TRCMethod)obj;
            } else if (obj instanceof MethodCallDetails) {
                m = ((MethodCallDetails)obj).getMethod();
            }
            if (m == null) {
                return null;
            }
            switch (pos) {
                case 0: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._callsCol, info.isDeltaColumn());
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._newItemCol, info.isDeltaColumn());
                }
                case 3: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._classNameCol, info.isDeltaColumn());
                }
                case 4: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._packageNameCol, info.isDeltaColumn());
                }
                case 5: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._baseTimeCol, info.isDeltaColumn());
                }
                case 6: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._avgBaseTimeCol, info.isDeltaColumn());
                }
                case 7: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._cumulativeTimeCol, info.isDeltaColumn());
                }
                case 9: {
                    return MethodDetailsStatistic.this.getElementColumnImage(m, MethodDetailsStatistic.this._CPUTimeCol, info.isDeltaColumn());
                }
            }
            return null;
        }
    }

    public class MethodStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public MethodStatisticSorter() {
            super(MethodDetailsStatistic.this);
        }

        public int compare(Viewer viewer, Object _e1, Object _e2) {
            int pos = MethodDetailsStatistic.this.getMethodPosForLevel(this._pos);
            TRCMethod e1 = null;
            TRCMethod e2 = null;
            if (_e1 instanceof MethodCallDetails) {
                e1 = ((MethodCallDetails)_e1).getMethod();
            } else if (_e1 instanceof TRCMethod) {
                e1 = (TRCMethod)_e1;
            }
            if (_e2 instanceof MethodCallDetails) {
                e2 = ((MethodCallDetails)_e2).getMethod();
            } else if (_e2 instanceof TRCMethod) {
                e2 = (TRCMethod)_e2;
            }
            if (e1 != null && e2 != null) {
                switch (pos) {
                    case 0: {
                        TRCMethod selection = MethodDetailsStatistic.this._container.getCurrentSelection();
                        int nb1 = 0;
                        int nb2 = 0;
                        if (MethodDetailsStatistic.this._methodDetailsType == 1) {
                            return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._callsCol, this._info.isDeltaColumn());
                        }
                        if (MethodDetailsStatistic.this._methodDetailsType == 2) {
                            TRCMethodInvocation mi;
                            if (_e1 instanceof MethodCallDetails) {
                                nb1 = ((MethodCallDetails)_e1).getCalls();
                            } else if (selection != null) {
                                Iterator i1 = e1.getInvocations().iterator();
                                while (i1.hasNext()) {
                                    mi = ((TRCMethodInvocation)i1.next()).getInvokedBy();
                                    if (mi == null || !mi.getMethod().equals(selection)) continue;
                                    if (mi instanceof TRCAggregatedMethodInvocation) {
                                        nb1 += ((TRCAggregatedMethodInvocation)mi).getCount();
                                        continue;
                                    }
                                    ++nb1;
                                }
                            }
                            if (_e2 instanceof MethodCallDetails) {
                                nb2 = ((MethodCallDetails)_e2).getCalls();
                            } else if (selection != null) {
                                Iterator i2 = e2.getInvocations().iterator();
                                while (i2.hasNext()) {
                                    mi = ((TRCMethodInvocation)i2.next()).getInvokedBy();
                                    if (mi == null || !mi.getMethod().equals(selection)) continue;
                                    if (mi instanceof TRCAggregatedMethodInvocation) {
                                        nb2 += ((TRCAggregatedMethodInvocation)mi).getCount();
                                        continue;
                                    }
                                    ++nb2;
                                }
                            }
                            return this._sortSequence * (nb1 - nb2);
                        }
                        if (MethodDetailsStatistic.this._methodDetailsType == 0) {
                            if (_e1 instanceof MethodCallDetails) {
                                nb1 = ((MethodCallDetails)_e1).getCalls();
                            } else if (selection != null) {
                                for (TRCMethodInvocation mi : selection.getInvocations()) {
                                    if (mi == null || mi.getInvokedBy() == null || !mi.getInvokedBy().getMethod().equals(e1)) continue;
                                    if (mi instanceof TRCAggregatedMethodInvocation) {
                                        nb1 += ((TRCAggregatedMethodInvocation)mi).getCount();
                                        continue;
                                    }
                                    ++nb1;
                                }
                            }
                            if (_e2 instanceof MethodCallDetails) {
                                nb2 = ((MethodCallDetails)_e2).getCalls();
                            } else if (selection != null) {
                                for (TRCMethodInvocation mi : selection.getInvocations()) {
                                    if (mi == null || mi.getInvokedBy() == null || !mi.getInvokedBy().getMethod().equals(e2)) continue;
                                    if (mi instanceof TRCAggregatedMethodInvocation) {
                                        nb2 += ((TRCAggregatedMethodInvocation)mi).getCount();
                                        continue;
                                    }
                                    ++nb2;
                                }
                            }
                            return this._sortSequence * (nb1 - nb2);
                        }
                    }
                    case 1: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._methodNameCol, this._info.isDeltaColumn());
                    }
                    case 2: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._newItemCol, this._info.isDeltaColumn());
                    }
                    case 3: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._classNameCol, this._info.isDeltaColumn());
                    }
                    case 4: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._packageNameCol, this._info.isDeltaColumn());
                    }
                    case 5: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._baseTimeCol, this._info.isDeltaColumn());
                    }
                    case 6: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._avgBaseTimeCol, this._info.isDeltaColumn());
                    }
                    case 7: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._cumulativeTimeCol, this._info.isDeltaColumn());
                    }
                    case 8: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._callsCol, this._info.isDeltaColumn());
                    }
                    case 9: {
                        return this._sortSequence * MethodDetailsStatistic.this.compareElements(e1, e2, MethodDetailsStatistic.this._CPUTimeCol, this._info.isDeltaColumn());
                    }
                }
            }
            return 0;
        }
    }
}

