/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternTab;
import org.eclipse.hyades.trace.views.internal.ContextInfoContainer;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CPUTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodInvocationColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodInvocationEntryTimeColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class MethodInvocationStatistic
extends MultiLevelStatisticView
implements ITimeChangedListener {
    protected String tmpString;
    protected SinglePatternTab _tabItem;
    protected ContextInfoContainer _contextInfo;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    protected ColumnLabelAdapter _methodInvocationCol;
    protected ColumnLabelAdapter _instanceNameCol;
    protected ColumnLabelAdapter _methodInvocationEntryTimeCol;
    protected ColumnLabelAdapter _cumulativeTimeCol;
    protected ColumnLabelAdapter _CPUTimeCol;

    protected Composite createTree(Composite parent, int options) {
        return this._toolkit.createTree(parent, options);
    }

    public MethodInvocationStatistic(Composite parent, SinglePatternTab tabItem) {
        super(true, parent, tabItem.getPage());
        this._tabItem = tabItem;
        this.createColumnsLabelProviders();
        this._viewerFilter = new StatisticView.StatisticFilter(this);
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        this._viewerFilter = new ExecutionStatisticFilter();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".mthi0000";
    }

    public void createColumnsLabelProviders() {
        this._methodInvocationCol = new MethodInvocationColumnLabel();
        this._instanceNameCol = new InstanceNameColumnLabel();
        this._methodInvocationEntryTimeCol = new MethodInvocationEntryTimeColumnLabel();
        this._cumulativeTimeCol = new CumulativeTimeColumnLabel();
        this._CPUTimeCol = new CPUTimeColumnLabel();
    }

    public String getColumnsPreferencesKey() {
        return "MInv51";
    }

    public String getDefaultColumnsTemplate() {
        String executionColumn = "method.invocations:0:" + String.valueOf(7) + ":left:200," + "object.name" + ":1:" + String.valueOf(1) + ":left:200," + "method.start.time" + ":2:" + String.valueOf(1) + ":right:100," + "method.cumul.time" + ":3:" + String.valueOf(1) + ":right:100," + "method.avg.base.time" + ":4:" + String.valueOf(1) + ":right:100";
        return executionColumn;
    }

    public IContentProvider getContentProvider() {
        return new MethodStatisticContentProvider();
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new MethodStatisticCellLabelProvider(colData);
    }

    public LabelProvider getTableLabelProvider() {
        return new MethodStatisticLabelProvider(this);
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new ExecutionTreeViewer(tree);
    }

    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
        Object sel;
        ITraceSelection model;
        if (this._page.getTraceViewer().isFPartVisible()) {
            Tree tree = (Tree)this.getTreeViewer().getControl();
            if (!(isPostponedOperation && (processedOperations & 1) != 0 || tree == null || tree.isDisposed() || tree.isFocusControl())) {
                this.update();
            }
        } else {
            this._page.getTraceViewer().setFRefreshView(true);
        }
        if ((model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject())).size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
            this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
        if (this._tabItem.percentMode() != null) {
            this._tabItem.percentMode().setChecked(this.isShowPercent());
        }
    }

    protected void updateDetailsPane() {
        int selCount = this.getTree().getSelectionCount();
        if (selCount != 1) {
            return;
        }
        TreeItem item = this.getTree().getSelection()[0];
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TreeItem) {
            itemData = ((TreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public void dispose() {
        super.dispose();
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
    }

    public void handleTimeChangedEvent() {
        Action base = this._tabItem.baseTime();
        Action raw = this._tabItem.rawTime();
        this._drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (base != null) {
            base.setChecked(this._drawMode == 0);
        }
        if (raw != null) {
            raw.setChecked(this._drawMode == 1);
        }
        String newKey = this._drawMode == 0 ? "method.cumul.time" : "method.raw.cumul.time";
        String oldKey = newKey.equals("method.cumul.time") ? "method.raw.cumul.time" : "method.cumul.time";
        Tree tree = this.getTree();
        int idx = tree.getColumnCount();
        while (idx > 0) {
            TreeColumn col = tree.getColumn(idx - 1);
            StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)col.getData();
            String columnKey = staticTblColInfo.getColumnData().key();
            if (columnKey.equals(oldKey)) {
                staticTblColInfo.getColumnData().key(newKey);
                String newName = staticTblColInfo.getColumnData().name();
                if (staticTblColInfo.isSortColumn()) {
                    newName = String.valueOf(col.getText().substring(0, 1)) + newName;
                }
                col.setText(newName);
            }
            --idx;
        }
        this.getTreeViewer().refresh();
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new MethodStatisticSorter();
    }

    protected void postUpdateEvents() {
    }

    protected boolean isHandleSelectionEventNeeded(Object source) {
        return !(source instanceof MethodInvocationStatistic) && !(source instanceof SinglePattern);
    }

    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
        Object source = event.getSource();
        if (!(source instanceof MethodInvocationStatistic) && !(source instanceof SinglePattern)) {
            this.handleSelectionEvent();
        } else {
            Object sel;
            ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
            if (model.size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    public boolean isEmpty() {
        int size = 0;
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (selModel.size() > 0) {
            Object obj = selModel.getFirstElement();
            if (obj instanceof TRCMethod) {
                size = ((TRCMethod)obj).getInvocations().toArray().length;
            }
            if (obj instanceof TRCMethodInvocation) {
                size = ((TRCMethodInvocation)obj).getMethod().getInvocations().toArray().length;
            }
        }
        return size <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.methodinvocation";
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._cumulativeTimeCol) {
            return ContextUpdaterHelper.updateCumulTime(col, isDeltaColumn, this.isShowPercent(), this.getDrawMode(), this._totalCumulativeTime);
        }
        if (col == this._CPUTimeCol) {
            return ContextUpdaterHelper.updateCPUTime(col, isDeltaColumn, this.isShowPercent(), 1.0);
        }
        return super.getColumnDisplayInfo(col, isDeltaColumn);
    }

    public int getDrawMode() {
        return this._drawMode;
    }

    public void setDrawMode(int mode) {
        this._drawMode = mode;
    }

    protected Composite createControl(Composite parent, ArrayList cols) {
        final Composite vc = super.createControl(parent, cols);
        this._contextInfo = new ContextInfoContainer();
        this._contextInfo.setViewer((IContextViewer)this._page.getTraceViewer());
        this._contextInfo.createControl(vc);
        this._contextInfo.addContextInfoContainerListener(new IContextInfoContainerListener(){

            public void visibilityChanged(boolean isVisible) {
                vc.layout(true, true);
            }
        });
        return vc;
    }

    protected void updateStatusContext(IContextLanguage language) {
        if (this._contextInfo != null) {
            this._contextInfo.updateStatusContext(language);
        }
    }

    protected void firstTimeUpdate() {
        super.firstTimeUpdate();
        this.redrawTable();
    }

    public void redrawTable() {
        this.getTree().setRedraw(false);
        ArrayList<ColumnData> list = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        this.resetColumns(list);
        this._currentColumns = list;
        this.getTree().setRedraw(true);
        this.refresh();
    }

    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        this.resetColumms();
        if (this._page instanceof ExecutionStatisticPage2 && this._contextInfo != null) {
            this._contextInfo.setMOFObject(this._page.getMOFObject());
        }
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
    }

    protected void resetColumms() {
        this._methodInvocationCol.resetMap();
        this._instanceNameCol.resetMap();
        this._methodInvocationEntryTimeCol.resetMap();
        this._cumulativeTimeCol.resetMap();
        this._CPUTimeCol.resetMap();
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return null;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return null;
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new ExecutionStatisticFilter();
    }

    public int getLevel() {
        return 0;
    }

    public boolean isEmptyUpdate() {
        return false;
    }

    public void setLevel(int i) {
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(MethodInvocationStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCMethodInvocation)) {
                return true;
            }
            String compareText = "";
            compareText = ((TRCMethodInvocation)element).getMethod().getName();
            if (compareText.equals("")) {
                compareText = TraceUIMessages._87;
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    class ExecutionTreeViewer
    extends TreeViewer {
        public ExecutionTreeViewer(Composite parent) {
            super(parent);
        }

        public ExecutionTreeViewer(Tree tree) {
            super(tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class MethodStatisticCellLabelProvider
    extends StatisticCellLabelProvider {
        public MethodStatisticCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((MethodStatisticLabelProvider)MethodInvocationStatistic.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((MethodStatisticLabelProvider)MethodInvocationStatistic.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class MethodStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            block2: {
                Object obj;
                block3: {
                    MethodInvocationStatistic.this.tmpList.clear();
                    ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(MethodInvocationStatistic.this._page.getMOFObject());
                    if (selModel.size() <= 0) break block2;
                    obj = selModel.getFirstElement();
                    if (!(obj instanceof TRCMethod)) break block3;
                    for (Object next : ((TRCMethod)obj).getInvocations()) {
                        if (!(next instanceof TRCFullMethodInvocation)) continue;
                        MethodInvocationStatistic.this.tmpList.add(next);
                    }
                    break block2;
                }
                if (!(obj instanceof TRCMethodInvocation)) break block2;
                for (Object next : ((TRCMethodInvocation)obj).getMethod().getInvocations()) {
                    if (!(next instanceof TRCFullMethodInvocation)) continue;
                    MethodInvocationStatistic.this.tmpList.add(next);
                }
            }
            return MethodInvocationStatistic.this.tmpList.toArray();
        }

        public Object[] getChildren(Object element) {
            MethodInvocationStatistic.this.tmpList.clear();
            Object[] segments = ((TRCMethodInvocation)element).getInvokes().toArray();
            int idx = 0;
            while (idx < segments.length) {
                if (segments[idx] instanceof TRCFullMethodInvocation) {
                    MethodInvocationStatistic.this.tmpList.add(segments[idx]);
                }
                ++idx;
            }
            return MethodInvocationStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            Iterator iter = ((TRCMethodInvocation)element).getInvokes().iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof TRCFullMethodInvocation)) continue;
                return true;
            }
            return false;
        }
    }

    public class MethodStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MethodStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col)).getColumnData().getInitalPos();
            switch (pos) {
                case 0: {
                    return MethodInvocationStatistic.this.getElementColumnText(obj, MethodInvocationStatistic.this._methodInvocationCol, false);
                }
                case 1: {
                    return MethodInvocationStatistic.this.getElementColumnText(obj, MethodInvocationStatistic.this._instanceNameCol, false);
                }
                case 2: {
                    return MethodInvocationStatistic.this.getElementColumnText(obj, MethodInvocationStatistic.this._methodInvocationEntryTimeCol, false);
                }
                case 3: {
                    return MethodInvocationStatistic.this.getElementColumnText(obj, MethodInvocationStatistic.this._cumulativeTimeCol, false);
                }
                case 4: {
                    return MethodInvocationStatistic.this.getElementColumnText(obj, MethodInvocationStatistic.this._CPUTimeCol, false);
                }
            }
            return "";
        }
    }

    public class MethodStatisticSorter
    extends StatisticView.StatisticSorter {
        public MethodStatisticSorter() {
            super(MethodInvocationStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * MethodInvocationStatistic.this.compareElements(e1, e2, MethodInvocationStatistic.this._methodInvocationCol, false);
                }
                case 1: {
                    return this._sortSequence * MethodInvocationStatistic.this.compareElements(e1, e2, MethodInvocationStatistic.this._instanceNameCol, false);
                }
                case 2: {
                    return this._sortSequence * MethodInvocationStatistic.this.compareElements(e1, e2, MethodInvocationStatistic.this._methodInvocationEntryTimeCol, false);
                }
                case 3: {
                    return this._sortSequence * MethodInvocationStatistic.this.compareElements(e1, e2, MethodInvocationStatistic.this._cumulativeTimeCol, false);
                }
                case 4: {
                    return this._sortSequence * MethodInvocationStatistic.this.compareElements(e1, e2, MethodInvocationStatistic.this._CPUTimeCol, false);
                }
            }
            return 0;
        }
    }
}

