/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.AbstractLazyHandler;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.PatternDrawStrategy;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Pattern
extends AbstractLazyHandler
implements ControlListener,
ITimeChangedListener,
ISelectionProvider,
IViewSelectionChangedListener {
    protected final float MAG_STEP = 2.0f;
    protected Label _status;
    protected JCanvas _canvas;
    protected PatternDrawStrategy _curDS;
    protected PatternDrawStrategy _patDS;
    protected boolean _initialized = false;
    protected PatternPage _page;
    protected Composite viewContainer;
    protected ViewForm dataPane;
    protected Composite viewComp;
    protected Action _updateAction;
    protected Action _openColorDialog;
    protected Separator fSeparator;

    public Pattern(Composite parent, PatternPage page) {
        this(parent, page, false);
    }

    public Pattern(Composite parent, PatternPage page, boolean lazyMode) {
        super(lazyMode);
        this._page = page;
        this.createControl(parent);
        this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        this._openColorDialog = new OpenColorDialog(TraceUIMessages._98);
        this.fSeparator = new Separator();
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
    }

    public PatternPage getPage() {
        return this._page;
    }

    public void close() {
        this.viewContainer.dispose();
        this._page.dispose();
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent event) {
        this.resizeContent();
    }

    public void createControl(Composite parent) {
        this.viewContainer = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.viewContainer.setLayout((Layout)layout);
        this.viewContainer.setLayoutData((Object)GridUtil.createFill());
        this.viewComp = new Composite(this.viewContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        this.viewComp.setLayout((Layout)layout);
        this.viewComp.setLayoutData((Object)GridUtil.createFill());
        this.dataPane = new ViewForm(this.viewComp, 0);
        this.dataPane.setLayoutData((Object)GridUtil.createFill());
        this._canvas = new JCanvas((Composite)this.dataPane, 768, 10);
        this.dataPane.setContent((Control)this._canvas.canvas());
        this.viewContainer.addControlListener((ControlListener)this);
        this._status = new Label(this.viewContainer, 2048);
        this._status.setLayoutData((Object)GridUtil.createHorizontalFill());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(TraceUIPlugin.getPluginId()) + ".exef0008");
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        if (this._patDS != null) {
            this._patDS.shutdown();
        }
        this._page = null;
        this._patDS = null;
        this._curDS = null;
        if (this._canvas != null) {
            this._canvas.dispose();
        }
        this._canvas = null;
        if (this.dataPane != null) {
            this.dataPane.dispose();
        }
        this.dataPane = null;
        if (this.viewComp != null) {
            this.viewComp.dispose();
        }
        this.viewComp = null;
        if (this.viewContainer != null) {
            this.viewContainer.dispose();
        }
        this.viewContainer = null;
        this._updateAction = null;
        this._openColorDialog = null;
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this._updateAction);
        menu.add((IAction)this._openColorDialog);
        menu.add((IContributionItem)this.fSeparator);
        this._canvas.fillContextMenu(menu);
    }

    public Control getControl() {
        return this.viewContainer;
    }

    public void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        this.initStrategies();
        this.setDrawStrategy(this._patDS);
        this.updateTitle();
    }

    private void initStrategies() {
        this._patDS = new PatternDrawStrategy(this);
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.fillContextMenu(menu);
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement());
    }

    public void resizeContent() {
        Rectangle viewContainerBounds = this.viewComp.getClientArea();
        this.dataPane.setBounds(viewContainerBounds.x, viewContainerBounds.y, viewContainerBounds.width, viewContainerBounds.height);
    }

    private void setDrawStrategy(PatternDrawStrategy ds) {
        if (this._curDS != null) {
            this._curDS.jcanvas(null);
        }
        this._curDS = ds;
        this._curDS.jcanvas(this._canvas);
        this._canvas.setDrawStrategy(this._curDS);
        this._canvas.zoomToFit();
    }

    public void update() {
        super.update(true);
    }

    protected void doUpdate(boolean redraw, boolean isPostponedOperation, int processedOperations) {
        if (!isPostponedOperation || (processedOperations & 1) == 0) {
            this._canvas.zoomToFill(1.0f, 1000.0f);
            this._canvas.redraw();
        }
    }

    protected void updateStatus(String status) {
        if (status.equals(this._status.getText())) {
            return;
        }
        this._status.setText(status);
    }

    protected void updateTitle() {
        this.dataPane.setToolTipText(this._curDS.title());
    }

    public void updateUI() {
        super.updateUI();
    }

    protected void doUpdateUI(boolean isPostponedOperation, int processedOperations) {
        if (!isPostponedOperation || (processedOperations & 1) == 0) {
            this._canvas.zoomToFill(1.0f, 1000.0f);
            this._canvas.redraw();
        }
    }

    public void zoomIn(boolean zoom) {
        this.initialize();
        this._canvas.isZoomIn(zoom);
        this._canvas.zoomIn();
    }

    public void zoomOut(boolean zoom) {
        this.initialize();
        this._canvas.isZoomOut(zoom);
        this._canvas.zoomOut();
    }

    public void updateButtons() {
        super.updateButtons();
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
    }

    public void handleTimeChangedEvent() {
        Action base = this._page.baseTime();
        Action raw = this._page.rawTime();
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (base != null) {
            base.setChecked(ref == 0);
        }
        if (raw != null) {
            raw.setChecked(ref == 1);
        }
        if (this._patDS != null) {
            this._patDS.setDrawMode(ref);
        }
    }

    public void refresh() {
        super.refresh();
    }

    protected void doRefresh(boolean isPostponedOperation, int processedOperations) {
        if (this._patDS != null && this._canvas != null && !this._canvas.canvas().isDisposed() && this._canvas.canvas().isVisible()) {
            this._patDS.redraw();
        }
    }

    public void selectionChanged() {
        this.handleSelectionEvent();
    }

    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
        if (!(isPostponedOperation && (processedOperations & 0x11) != 0 || this._canvas == null || this._canvas.canvas().isDisposed() || !this._canvas.canvas().isVisible() || this._canvas.canvas().isFocusControl())) {
            this._canvas.redraw();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        if (this._page == null) {
            return new StructuredSelection();
        }
        Object selection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement();
        if (selection != null) {
            return new StructuredSelection(selection);
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public JCanvas getCanvas() {
        return this._canvas;
    }

    public boolean isEmpty() {
        return this._patDS._visibleThreads.size() <= 0 && this._curDS._visibleThreads.size() <= 0;
    }

    public void openExecutionStatisticView() {
        IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage persp = UIPlugin.getActivePage();
            persp.showView("org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer");
        }
        catch (Exception e) {
            String msg = TraceUIMessages._100;
            Status err = new Status(2, "org.eclipse.core.resources", 566, e.toString(), null);
            ErrorDialog.openError((Shell)window.getShell(), (String)msg, (String)"", (IStatus)err);
            e.printStackTrace();
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        super.handleViewSelectionChangedEvent(event);
    }

    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
        Object source = event.getSource();
        if (!(source instanceof Pattern)) {
            this.selectionChanged();
        }
    }

    protected boolean isHandleSelectionEventNeeded(Object source) {
        return !(source instanceof Pattern);
    }

    class OpenColorDialog
    extends Action {
        public OpenColorDialog(String name) {
            super(name);
            TracePluginImages.setImageDescriptors((IAction)this, "tool16", "opengraphcolor_co.gif");
        }

        public void run() {
            GraphColorDialog dialog = new GraphColorDialog(Pattern.this.viewContainer.getShell(), TraceUIMessages._97, null);
            dialog.open();
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent((Object)Pattern.this._page.getMOFObject());
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }
}

