/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.actions.internal.OpenMethodDetailsAction;
import org.eclipse.hyades.trace.views.actions.internal.OpenSourceAction;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.AbstractLazyHandler;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.fragment.ContentProviderNewLazyAdaptor;
import org.eclipse.hyades.trace.views.internal.fragment.FragmentedTreeViewer;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelComparator;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnsDialog;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.trace.views.util.internal.SortByColumnDialog;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public abstract class StatisticView
extends AbstractLazyHandler
implements IViewSelectionChangedListener,
ControlListener {
    protected ArrayList tmpList;
    protected StructuredViewer _viewer;
    protected Layout _layout = null;
    protected Composite _viewContainer;
    protected Composite _filterContainer;
    protected ViewForm _dataPane;
    protected Composite _viewComp;
    protected boolean _initialized = false;
    protected TraceViewerPage _page;
    protected StatisticFilter _viewerFilter;
    protected StatisticSorter _viewerSorter;
    protected ArrayList _currentColumns = null;
    protected boolean _newSelection = false;
    protected boolean _isShowPercent = false;
    protected boolean _deltaColumns = false;
    protected boolean _refresh = false;
    protected Action _updateAction;
    protected Action _chooseColumnAction;
    protected Action _sortByColumnAction;
    protected Action _showPercent;
    protected Action _deltaColumnsAction;
    protected Action _chooseColumnsAction;
    protected Separator fSeparator;
    protected double _maxTime;
    protected double _totalPackagesCumulativeTime;
    protected double _totalBaseTime;
    protected double _totalCumulativeTime;
    protected double _totalInheritedBaseTime;
    protected double _totalInheritedCumulativeTime;
    protected int _totalInst;
    protected int _totalCalls;
    protected int _activeInst;
    protected long _totalSize;
    protected long _activeSize;
    protected int _collectedInst;
    protected ContentProviderNewLazyAdaptor adaptor;
    protected LabelProvider wrappedLp;
    protected ArrayList _listOfColumExtension = new ArrayList();
    protected String _templateOfColumExtension = "";
    protected HyadesFormToolkit _toolkit;
    protected static String _previousColumnText;
    protected static int _previousColumnIndex;
    protected static int _previousSequence;
    protected boolean _firstTime = true;

    protected StatisticView(Composite parent, TraceViewerPage page) {
        this(false, parent, page, true);
    }

    protected StatisticView(boolean lazyMode, Composite parent, TraceViewerPage page) {
        this(lazyMode, parent, page, true);
    }

    protected StatisticView(Composite parent, TraceViewerPage page, boolean initializeContent) {
        this(false, parent, page, true);
    }

    protected StatisticView(boolean lazyMode, Composite parent, TraceViewerPage page, boolean initializeContent) {
        super(lazyMode);
        this._page = page;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        if (initializeContent) {
            this.createContent(parent);
        }
    }

    public void createContent(Composite parent) {
        int delt;
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this._currentColumns = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        ArrayList list = this.parseExtensions();
        if (list != null && list.size() != 0) {
            this._currentColumns.addAll(list);
        }
        this.createControl(parent, this._currentColumns);
        int perc = TraceUIPlugin.getDefault().getPreferenceStore().getInt(this.buildPreferenceStoreSring("percent"));
        if (perc == 1) {
            this._isShowPercent = true;
        }
        if ((delt = TraceUIPlugin.getDefault().getPreferenceStore().getInt(this.buildPreferenceStoreSring("delta"))) == 1) {
            this._deltaColumns = true;
        }
        this.initialize();
        this.tmpList = new ArrayList();
        this.fSeparator = new Separator();
    }

    public abstract Tree getTree();

    protected abstract IContentProvider getContentProvider();

    protected abstract Composite createTree(Composite var1, int var2);

    protected abstract String getColumnsPreferencesKey();

    protected abstract String getDefaultColumnsTemplate();

    protected abstract TreeViewer getTreeViewer(Tree var1);

    protected void openSourceForSelection(ISelection selection) {
        OpenSourceAction action = new OpenSourceAction();
        action.selectionChanged((IAction)action, selection);
        action.run();
    }

    protected StructuredViewer createTreeViewer(Composite tree) {
        TreeViewer tv = this.getTreeViewer((Tree)tree);
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Object node;
                    TreeViewer tv = (TreeViewer)StatisticView.this.getTreeViewer();
                    Object element = node = ((IStructuredSelection)selection).getFirstElement();
                    if (StatisticView.this.adaptor != null) {
                        node = ContentProviderNewLazyAdaptor.getObject(node);
                    }
                    if (tv.isExpandable(element)) {
                        tv.setExpandedState(element, !tv.getExpandedState(element));
                    } else if (node instanceof TRCMethod || node instanceof TRCMethodInvocation || node instanceof MethodCallDetails) {
                        this.openMethodDetails(selection);
                    } else {
                        StatisticView.this.openSourceForSelection(selection);
                    }
                }
            }

            private void openMethodDetails(ISelection selection) {
                OpenMethodDetailsAction action = new OpenMethodDetailsAction();
                action.selectionChanged((IAction)action, selection);
                action.run();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tv);
        return tv;
    }

    protected Composite getViewComponent() {
        return this._viewComp;
    }

    protected TraceViewerPage getTraceViewerPage() {
        return this._page;
    }

    protected ViewForm getDataPane() {
        return this._dataPane;
    }

    public void showNewSelection() {
        if (this._newSelection) {
            this.getTree().showSelection();
            this._newSelection = false;
        }
    }

    public boolean showingDeltaColumns() {
        return this._deltaColumns;
    }

    protected void setNewSelection() {
        this._newSelection = true;
    }

    public Action getUpdateAction() {
        if (this._updateAction == null) {
            this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        }
        return this._updateAction;
    }

    public Action getDeltaColumnsAction() {
        if (this._deltaColumnsAction == null) {
            this._deltaColumnsAction = new DeltaColumnsAction(TraceUIMessages._84);
        }
        return this._deltaColumnsAction;
    }

    public Action getChooseColumnsAction(ArrayList cols, String key) {
        this._chooseColumnAction = new ChooseColumnsAction(TraceUIMessages._55, cols, key);
        return this._chooseColumnAction;
    }

    public Action getSortByColumnAction() {
        this._sortByColumnAction = new SortByColumnsAction(TraceUIMessages._57);
        return this._sortByColumnAction;
    }

    public Action getShowPercentAction() {
        if (this._showPercent == null) {
            this._showPercent = new ShowPercentAction(TraceUIMessages._13);
        }
        return this._showPercent;
    }

    public boolean isShowPercent() {
        return this._isShowPercent;
    }

    public Control getControl() {
        return this._viewContainer;
    }

    public ArrayList getColumnDataList() {
        return this._currentColumns;
    }

    public StructuredViewer getTreeViewer() {
        return this._viewer;
    }

    public StatisticSorter getViewerSorter() {
        return this._viewerSorter;
    }

    public StatisticFilter getViewerFilter() {
        return this._viewerFilter;
    }

    public Layout getLayout() {
        if (this._layout == null) {
            this._layout = new ColumnLayout();
            ((ColumnLayout)this._layout).maxNumColumns = 100;
        }
        return this._layout;
    }

    public abstract void updateModelSelection();

    public void controlMoved(ControlEvent arg0) {
    }

    public void controlResized(ControlEvent arg0) {
        Rectangle dataBounds = this.getViewComponent().getClientArea();
        this.getDataPane().setBounds(dataBounds.x, dataBounds.y, dataBounds.width, dataBounds.height);
        if (arg0.getSource() instanceof TableColumn) {
            ColumnData.setColumns(this.getColumnDataList(), this.getColumnsPreferencesKey());
        }
    }

    public void menuAboutToShow(IMenuManager arg0) {
    }

    protected void setRedrawTable(boolean redraw) {
        this._viewer.getControl().setRedraw(redraw);
    }

    public void refresh() {
        super.refresh();
    }

    protected void doRefresh(boolean isPostponedOperation, int processedOperations) {
        if (!(isPostponedOperation && (processedOperations & 1) != 0 || this.getTreeViewer().getControl().isDisposed())) {
            this.update();
        }
    }

    public void selectionChanged() {
        this.handleSelectionEvent();
    }

    public void updateUI(ArrayList cols) {
        this.updateUI();
    }

    protected void doUpdateUI(boolean isPostponedOperation, int processedOperations) {
        if (!isPostponedOperation) {
            this.update();
            this.updateButtons();
        } else {
            if ((processedOperations & 1) == 0) {
                this.update();
            }
            if ((processedOperations & 2) == 0) {
                this.updateButtons();
            }
        }
    }

    protected abstract StatisticSorter getViewerSorterInstance();

    protected void showPercentUpdate() {
    }

    protected void setLinesVisible(Tree tree) {
    }

    protected void firstTimeUpdate() {
        Tree tree = this.getTree();
        this.setLinesVisible(tree);
        this._viewerSorter = this.getViewerSorterInstance();
        this._firstTime = false;
        if (_previousColumnText != null) {
            int i = 0;
            while (i < tree.getColumnCount()) {
                if (tree.getColumn(i).getText().equals(_previousColumnText)) {
                    this._viewerSorter.setSortedColumn(_previousSequence, tree.getColumn(i));
                    return;
                }
                ++i;
            }
            String s1 = "package.base.time";
            String s2 = "class.base.time";
            String s3 = "method.base.time";
            int n = 0;
            while (n < tree.getColumnCount()) {
                if (tree.getColumn(n).getText().equals(s1) || tree.getColumn(n).getText().equals(s2) || tree.getColumn(n).getText().equals(s3)) {
                    this._viewerSorter.setSortedColumn(tree.getColumn(n));
                    this._viewer.setSorter((ViewerSorter)this._viewerSorter);
                    break;
                }
                ++n;
            }
        } else {
            _previousColumnText = "package.base.time";
            int k = 0;
            while (k < tree.getColumnCount()) {
                if (tree.getColumn(k).getText().equals(_previousColumnText)) {
                    this._viewerSorter.setSortedColumn(tree.getColumn(k));
                    this._viewer.setSorter((ViewerSorter)this._viewerSorter);
                }
                ++k;
            }
        }
    }

    protected int updateTableGetColumnNumber() {
        return 0;
    }

    protected void postUpdateEvents() {
        this.handleSelectionEvent();
    }

    protected void expandFirstElement() {
    }

    protected String getContext() {
        IContextViewer viewer = this.getContextViewer();
        if (viewer != null) {
            return viewer.getSelectedContext();
        }
        return null;
    }

    protected boolean contextChanged() {
        IContextViewer viewer = this.getContextViewer();
        if (viewer != null) {
            if (viewer.contextChanged()) {
                return true;
            }
            viewer.setSelectedContext(ContextUpdaterHelper.getCurrentContext(ContextUpdaterHelper.getContexts(this._page.getMOFObject()), viewer), false);
            return viewer.contextChanged();
        }
        return false;
    }

    protected void updateContext() {
        this.resetColumns(this._currentColumns);
        IContextViewer viewer = this.getContextViewer();
        if (viewer != null) {
            viewer.updateContext();
        }
    }

    private IContextViewer getContextViewer() {
        TraceViewer traceViewer;
        if (this._page != null && (traceViewer = this._page.getTraceViewer()) != null && traceViewer instanceof IContextViewer) {
            return (IContextViewer)traceViewer;
        }
        return null;
    }

    public void update() {
        super.update();
    }

    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        IContextViewer viewer;
        TreeViewer tv = (TreeViewer)this._viewer;
        Object[] expandedElements = tv.getExpandedElements();
        if (this._firstTime) {
            this.firstTimeUpdate();
        }
        if (this.contextChanged() || this._page.getTraceViewer().contextHandlerSelectionChanged()) {
            this.updateContext();
        }
        if ((viewer = this.getContextViewer()) != null) {
            viewer.getContextSelectionMenuListener().setMOFObject(this._page.getMOFObject());
        }
        this.showPercentUpdate();
        this.setRedrawTable(false);
        this.getTreeViewer().setInput((Object)this._page.getMOFObject());
        this.expandFirstElement();
        this.postUpdateEvents();
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (e != null) {
                tv.setExpandedState(e, true);
            }
            ++n2;
        }
        this.setRedrawTable(true);
    }

    protected void resetColumns(ArrayList list) {
        String sortedColumnKey = "";
        boolean isDeltaColumn = false;
        if (this._firstTime && this._viewerSorter == null) {
            this._viewerSorter = this.getViewerSorterInstance();
        }
        int sortSequence = this._viewerSorter.getSortSequence();
        Tree tree = this.getTree();
        this.setRedrawTable(false);
        int idx = tree.getColumnCount();
        while (idx > 0) {
            TreeColumn col = tree.getColumn(tree.getColumnCount() - 1);
            StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)col.getData();
            if (staticTblColInfo.isSortColumn()) {
                sortedColumnKey = staticTblColInfo.getColumnData().key();
                isDeltaColumn = staticTblColInfo.isDeltaColumn();
            }
            col.dispose();
            --idx;
        }
        idx = 0;
        while (idx < list.size()) {
            ColumnData data = (ColumnData)list.get(idx);
            data.setContext(this.getContext());
            if (data.visible()) {
                new StatisticTableColumnInfo(this, data, this._deltaColumns);
            }
            ++idx;
        }
        tree = this.getTree();
        idx = 0;
        while (idx < tree.getColumnCount()) {
            StatisticTableColumnInfo treeColumnInfo = this.getColumnInfo(tree.getColumn(idx));
            if (treeColumnInfo != null && sortedColumnKey.equals(treeColumnInfo.getColumnData().key()) && isDeltaColumn == treeColumnInfo.isDeltaColumn()) {
                treeColumnInfo.setSortColumn(true);
                break;
            }
            ++idx;
        }
        if (this._viewerSorter.resetSortColumn(this.getTree()) == null) {
            this._viewer.setSorter(null);
        } else {
            this._viewerSorter.setSortSequence(sortSequence * -1);
            this._viewerSorter.setSortedColumn(this._viewerSorter.resetSortColumn(this.getTree()));
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
        }
        this.setRedrawTable(true);
    }

    protected Composite createControl(Composite parent, ArrayList cols) {
        this._viewContainer = this._toolkit.createComposite(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this._viewContainer.setLayout((Layout)layout);
        this._viewContainer.setLayoutData((Object)GridUtil.createFill());
        this._viewComp = this._toolkit.createComposite(this._viewContainer, 0x800000);
        layout = new GridLayout();
        layout.numColumns = 1;
        this._viewComp.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this._viewComp.setLayoutData((Object)data);
        this._dataPane = this._toolkit.createViewForm(this._viewComp);
        Control table = this.createTableViewer((Composite)this._dataPane, cols);
        this._dataPane.setContent(table);
        this._dataPane.setLayoutData((Object)GridUtil.createFill());
        this._viewContainer.addControlListener((ControlListener)this);
        return this._viewContainer;
    }

    private Control createTableViewer(Composite parent, ArrayList cols) {
        IContentProvider cp;
        Composite tree = this.createTree(parent, 8454148);
        this._viewer = this.createTreeViewer(tree);
        int idx = 0;
        while (idx < cols.size()) {
            ColumnData data = (ColumnData)cols.get(idx);
            data.setContext(this.getContext());
            if (data.visible()) {
                new StatisticTableColumnInfo(this, data, this._deltaColumns);
            }
            ++idx;
        }
        Tree tre = this.getTree();
        tre.setLinesVisible(true);
        tre.setHeaderVisible(true);
        tre.setLayout(this.getLayout());
        tre.setLayoutData((Object)new GridData(1808));
        if ((tre.getStyle() & 0x10000000) != 0 && this._viewer instanceof FragmentedTreeViewer && (cp = this.getContentProvider()) instanceof ITreeContentProvider) {
            ITableLabelProvider lp = (ITableLabelProvider)this.getTableLabelProvider();
            ContentProviderNewLazyAdaptor adaptor = new ContentProviderNewLazyAdaptor((ITreeContentProvider)cp, null, null);
            this.wrappedLp = (LabelProvider)adaptor.wrapLableProvider(lp);
            this._viewer.setContentProvider((IContentProvider)adaptor);
            this.adaptor = adaptor;
        }
        if (this.adaptor == null) {
            this._viewer.setContentProvider(this.getContentProvider());
        }
        if (tree instanceof Tree) {
            ((Tree)tree).addSelectionListener(this.getSelectionListener());
        }
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this._viewer.getControl();
    }

    public void dispose() {
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this._page = null;
    }

    private void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
    }

    public abstract LabelProvider getTableLabelProvider();

    public abstract CellLabelProvider getCellLabelProvider(ColumnData var1);

    public void handlePercentChanged() {
        this._isShowPercent = !this._isShowPercent;
        TraceUIPlugin.getDefault().getPreferenceStore().setValue(this.buildPreferenceStoreSring("percent"), this._isShowPercent ? 1 : 0);
        this.refresh();
        this.updateButtons();
    }

    protected abstract String getViewTypeStr();

    public void handleDeltaChanged() {
        this._deltaColumns = !this._deltaColumns;
        TraceUIPlugin.getDefault().getPreferenceStore().setValue(this.buildPreferenceStoreSring("delta"), this._deltaColumns ? 1 : 0);
        this.resetColumns(this._currentColumns);
        this.refresh();
    }

    protected String buildPreferenceStoreSring(String str) {
        return String.valueOf(this.getViewTypeStr()) + "." + str;
    }

    protected ArrayList parseExtensions() {
        return null;
    }

    public void notifyViewSelectionChanged(Object source, Object selection) {
        UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(selection);
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource(source);
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    public HyadesFormToolkit getToolkit() {
        return this._toolkit;
    }

    protected StatisticTableColumnInfo getColumnInfo(TreeColumn treeColumn) {
        if (treeColumn.getData() != null && treeColumn.getData() instanceof StatisticTableColumnInfo) {
            return (StatisticTableColumnInfo)treeColumn.getData();
        }
        return null;
    }

    protected int compareElements(Object obj1, Object obj2, ColumnLabelAdapter col, boolean isDeltaColumn) {
        ColumnDisplayInfo info = this.getColumnDisplayInfo(col, isDeltaColumn);
        return ColumnLabelComparator.compare(obj1, obj2, col, info);
    }

    protected String getElementColumnText(Object obj, ColumnLabelAdapter col, boolean isDeltaColumn) {
        ColumnDisplayInfo info = this.getColumnDisplayInfo(col, isDeltaColumn);
        return col.getDisplayString(obj, info);
    }

    protected Image getElementColumnImage(Object obj, ColumnLabelAdapter col, boolean isDeltaColumn) {
        ColumnDisplayInfo info = this.getColumnDisplayInfo(col, isDeltaColumn);
        return col.getDisplayImage(obj, info);
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        return col.getColumnDisplayInfo();
    }

    protected String getContextHelpId() {
        return null;
    }

    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
    }

    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
    }

    public SelectionListener getSelectionListener() {
        return new StatViewSelectionListener();
    }

    class ChooseColumnsAction
    extends Action {
        private ArrayList _cols;
        private String _key;

        public ChooseColumnsAction(String name, ArrayList cols, String key) {
            super(name);
            this._cols = cols;
            this._key = key;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".ccol0000");
            TracePluginImages.setImageDescriptors((IAction)this, "lcl16", "choosecolumn_co.gif");
        }

        public void run() {
            ColumnsDialog dialog = new ColumnsDialog(StatisticView.this.getControl().getShell(), TraceUIMessages._56, null, this._cols, StatisticView.this.getDefaultColumnsTemplate(), StatisticView.this.getContextHelpId(), StatisticView.this.getContext());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                ColumnData.setColumns(dialog.getData(), this._cols, this._key);
                StatisticView.this.resetColumns(this._cols);
                StatisticView.this.refresh();
            }
        }
    }

    class DeltaColumnsAction
    extends Action {
        public DeltaColumnsAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".ccol0000");
        }

        public void setChecked(boolean value) {
            super.setChecked(value);
        }

        public void run() {
            StatisticView.this.handleDeltaChanged();
        }
    }

    class ShowPercentAction
    extends Action {
        public ShowPercentAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".clst0003");
        }

        public void setChecked(boolean value) {
            super.setChecked(value);
        }

        public void run() {
            StatisticView.this.handlePercentChanged();
        }
    }

    class SortByColumnsAction
    extends Action {
        public SortByColumnsAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".ccol0000");
            TracePluginImages.setImageDescriptors((IAction)this, "lcl16", "alphab_sort_co.gif");
        }

        private TreeColumn getTreeColumn(Tree tree, StatisticTableColumnInfo columnInfo) {
            int idx = 0;
            while (idx < tree.getColumnCount()) {
                StatisticTableColumnInfo treeColumnInfo = StatisticView.this.getColumnInfo(tree.getColumn(idx));
                if (treeColumnInfo != null && columnInfo != null && columnInfo.getColumnData().name().equals(treeColumnInfo.getColumnData().name()) && columnInfo.isDeltaColumn() == treeColumnInfo.isDeltaColumn()) {
                    return tree.getColumn(idx);
                }
                ++idx;
            }
            return null;
        }

        public void run() {
            ArrayList<StatisticTableColumnInfo> statisticTableColumnInfoList = new ArrayList<StatisticTableColumnInfo>();
            int i = 0;
            while (i < StatisticView.this.getTree().getColumnCount()) {
                StatisticTableColumnInfo ci = StatisticView.this.getColumnInfo(StatisticView.this.getTree().getColumn(i));
                if (ci != null) {
                    statisticTableColumnInfoList.add(ci);
                }
                ++i;
            }
            SortByColumnDialog dialog = new SortByColumnDialog(StatisticView.this.getControl().getShell(), TraceUIMessages._58, null, statisticTableColumnInfoList, StatisticView.this.getViewerSorter().getSortSequence());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                StatisticView.this.getViewerSorter().setSortedColumn(dialog.sortSequence(), this.getTreeColumn(StatisticView.this.getTree(), dialog.sortColumn()));
                StatisticView.this._viewer.refresh();
            }
        }
    }

    class StatViewSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent arg0) {
            if (arg0.widget instanceof TreeColumn) {
                StatisticView.this._viewerSorter.setSortedColumn((TreeColumn)arg0.widget);
                if (StatisticView.this.adaptor != null) {
                    StatisticView.this.adaptor.setViewerComparator((ViewerComparator)StatisticView.this._viewerSorter);
                } else {
                    StatisticView.this._viewer.setSorter((ViewerSorter)StatisticView.this._viewerSorter);
                }
                StatisticView.this._viewer.refresh();
            } else if (arg0.widget instanceof Table || arg0.widget instanceof Tree) {
                StatisticView.this.updateModelSelection();
            }
            StatisticView.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class StatisticFilter
    extends ViewerFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        public void setPattern(String pattern, boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
            this._pattern = this._caseSensitive ? pattern : pattern.toLowerCase();
            this._noPattern = pattern.equals("*") || pattern.equals("");
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer st = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (st.hasMoreTokens()) {
                this._textList.add(st.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (this._noPattern) {
                return true;
            }
            String compareText = "";
            if (element instanceof TRCPackage) {
                compareText = ((TRCPackage)element).getName();
                if (compareText.equals("")) {
                    compareText = TraceUIMessages._87;
                }
            } else if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            } else if (element instanceof TRCMethod) {
                compareText = String.valueOf(((TRCMethod)element).getName()) + ((TRCMethod)element).getSignature();
            } else if (element instanceof TRCObject) {
                TRCObject obj = (TRCObject)element;
                compareText = obj.getIsA().getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public abstract class StatisticSorter
    extends ViewerSorter {
        protected TreeColumn _sortColumn;
        protected int _sortSequence = -1;
        protected StatisticTableColumnInfo _info;
        protected int _pos = 0;

        public void setSortedColumn(TreeColumn newSortColumn) {
            TreeColumn currentColumn = this.getCurrentSortColumn(newSortColumn.getParent());
            this._sortSequence = currentColumn != null ? (currentColumn == newSortColumn ? -this._sortSequence : -1) : 1;
            _previousSequence = this._sortSequence;
            this.setSortedColumn(this._sortSequence, newSortColumn);
        }

        public void setSortedColumn(int sortSequence, TreeColumn newSortColumn) {
            String text;
            this._sortSequence = sortSequence;
            this._sortColumn = newSortColumn;
            TreeColumn currentColumn = this.getCurrentSortColumn(newSortColumn.getParent());
            if (currentColumn != null) {
                text = currentColumn.getText();
                if (text.startsWith(">") || text.startsWith("<")) {
                    text = text.substring(1);
                }
                currentColumn.setText(text);
                StatisticTableColumnInfo.getStatisticTableColumnInfo(currentColumn).setSortColumn(false);
            }
            text = newSortColumn.getText();
            _previousColumnText = new String(text);
            this._info = StatisticTableColumnInfo.getStatisticTableColumnInfo(newSortColumn);
            this._pos = this._info.getColumnData().getInitalPos();
            newSortColumn.setText(String.valueOf(this._sortSequence > 0 ? ">" : "<") + text);
            StatisticTableColumnInfo.getStatisticTableColumnInfo(newSortColumn).setSortColumn(true);
        }

        public int getSortSequence() {
            return this._sortSequence;
        }

        public String getPreviousSelection() {
            return _previousColumnText;
        }

        public void setSortSequence(int sortSequence) {
            this._sortSequence = sortSequence;
        }

        public TreeColumn getCurrentSortColumn(Tree tree) {
            int idx = 0;
            while (idx < tree.getColumnCount()) {
                if (StatisticTableColumnInfo.getStatisticTableColumnInfo(tree.getColumn(idx)).isSortColumn()) {
                    return tree.getColumn(idx);
                }
                ++idx;
            }
            return null;
        }

        public TreeColumn resetSortColumn(Tree tree) {
            this._sortColumn = this.getCurrentSortColumn(tree);
            return this._sortColumn;
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".uvew0000");
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent((Object)StatisticView.this._page.getMOFObject());
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }
}

