/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.ui.widgets.grapher.GraphSource;
import org.eclipse.swt.graphics.Color;

public class SummaryGraphSource
implements GraphSource {
    private final List dataList = new ArrayList();
    private final String name;
    private final Color color;
    private final GraphDataItem minValue = new GraphDataItem(0.0, 0.0);
    private final GraphDataItem maxValue = new GraphDataItem(0.0, 0.0);

    public SummaryGraphSource(String name, Color color) {
        this.name = name;
        this.color = color;
    }

    public final String getName() {
        return this.name;
    }

    public final Color getColor() {
        return this.color;
    }

    public void addData(GraphDataItem data) {
        this.dataList.add(data);
        if (this.minValue.x > data.x) {
            this.minValue.x = data.x;
        }
        if (this.maxValue.x < data.x) {
            this.maxValue.x = data.x;
        }
        if (this.minValue.y > data.y) {
            this.minValue.y = data.y;
        }
        if (this.maxValue.y < data.y) {
            this.maxValue.y = data.y;
        }
    }

    public double getValueMax() {
        return this.maxValue.y;
    }

    public double getValueMin() {
        return this.minValue.y;
    }

    public double getMax() {
        return this.maxValue.x;
    }

    public double getMin() {
        return this.minValue.x;
    }

    public double getAverageBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getCountBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getMaxBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getMinBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getSessionMax() {
        return 0.0;
    }

    public double getSessionMin() {
        return 0.0;
    }

    public double getStandardDeviationBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getSumBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getValueAt(double x) {
        if (x < this.minValue.x || x > this.maxValue.x || this.dataList.isEmpty()) {
            return 0.0;
        }
        int i = 0;
        while (i < this.dataList.size()) {
            GraphDataItem dataItem = (GraphDataItem)this.dataList.get(i);
            if (x >= dataItem.x) {
                return dataItem.y;
            }
            ++i;
        }
        return ((GraphDataItem)this.dataList.get((int)(this.dataList.size() - 1))).y;
    }

    public static class GraphDataItem {
        public double x;
        public double y;

        public GraphDataItem(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

