/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.fragment;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.trace.views.internal.fragment.IElementInfo;
import org.eclipse.hyades.trace.views.internal.fragment.RootExpansion;
import org.eclipse.jface.viewers.TreePath;

public class Expansion
implements IElementInfo,
Comparable {
    private int directChildSize;
    private int allChildSize;
    private Object element;
    private Expansion parent;
    private TreeMap indexToChildMap;
    private boolean isCollapsed;
    private Integer index;
    private Integer rootIndex;
    private RootExpansion rootExpansion;
    private boolean isVirtual;
    private boolean isOutOfRangeMarker;

    Expansion(Expansion parent, Expansion base) {
        this.copyFrom(parent, base);
    }

    private void copyFrom(Expansion parent, Expansion base) {
        this.directChildSize = base.directChildSize;
        this.allChildSize = base.allChildSize;
        this.element = base.element;
        this.parent = parent;
        if (base.indexToChildMap != null && base.indexToChildMap.size() != 0) {
            this.indexToChildMap = (TreeMap)base.indexToChildMap.clone();
            for (Map.Entry entry : this.indexToChildMap.entrySet()) {
                entry.setValue(new Expansion(this, (Expansion)entry.getValue()));
            }
        }
        this.isCollapsed = base.isCollapsed;
        this.index = base.index;
        this.rootIndex = base.rootIndex;
        this.rootExpansion = parent != null ? parent.getRoot() : (RootExpansion)parent;
        this.isVirtual = base.isVirtual;
        this.isOutOfRangeMarker = base.isOutOfRangeMarker;
    }

    Expansion(Object element, int size) {
        this.setInfo(element, size);
    }

    void IAmRoot() {
        if (this.getClass() == RootExpansion.class) {
            this.rootExpansion = (RootExpansion)this;
        }
    }

    public Expansion expandChild(int elementIndex, Object childElement, int childSize) {
        Integer i;
        Expansion exp;
        if (this.indexToChildMap != null && this.indexToChildMap.size() != 0 && (exp = (Expansion)this.indexToChildMap.get(i = new Integer(elementIndex))) != null) {
            if (exp.directChildSize == childSize && exp.element.equals(childElement) && exp.isCollapsed) {
                exp.expand();
                return exp;
            }
            Assert.isTrue((boolean)false);
        }
        return this.createChild(elementIndex, childElement, childSize, false, false, true);
    }

    public Object getData() {
        return this.element;
    }

    private Expansion createChild(int elementIndex, Object childElement, int childSize, boolean isOutOfRangeMarker, boolean virtual, boolean expanded) {
        this.validateChildIndex(elementIndex, isOutOfRangeMarker);
        if (isOutOfRangeMarker) {
            virtual = true;
        }
        if (!virtual) {
            Expansion.validateExpansionInfo(childElement, childSize);
        } else {
            expanded = false;
        }
        Integer i = new Integer(elementIndex);
        Expansion child = new Expansion(childElement, childSize);
        child.isOutOfRangeMarker = isOutOfRangeMarker;
        child.isVirtual = virtual;
        child.isCollapsed = !expanded;
        this.linkChild(i, child);
        Assert.isTrue((child.getParent() == this ? 1 : 0) != 0);
        return child;
    }

    public Expansion getCommonRelative(Expansion other) {
        return Expansion.getCommonRelative(this, other);
    }

    public static Expansion getCommonRelative(Expansion exp1, Expansion exp2) {
        int d;
        int i;
        int delta;
        int d2;
        if (exp1.equals(exp2)) {
            return exp1;
        }
        if (!exp1.getRoot().equals(exp2.getRoot())) {
            return null;
        }
        int d1 = exp1.getDepth();
        if (d1 > (d2 = exp2.getDepth())) {
            delta = d1 - d2;
            i = 0;
            while (i < delta) {
                exp1 = exp1.getParent();
                ++i;
            }
            d = d2;
        } else if (d2 > d1) {
            delta = d2 - d1;
            i = 0;
            while (i < delta) {
                ++i;
                exp2 = exp2.getParent();
            }
            d = d1;
        } else {
            d = d1;
        }
        if (d == 0) {
            return exp1;
        }
        int i2 = 0;
        while (i2 < d) {
            if (exp1.equals(exp2)) {
                return exp1;
            }
            ++i2;
            exp1 = exp1.getParent();
            exp2 = exp2.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private void validateChildIndex(int index, boolean isOutOfRangeMarker) {
        Assert.isTrue((index < (isOutOfRangeMarker ? this.directChildSize + 1 : this.directChildSize) && index >= 0 ? 1 : 0) != 0);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public int getDepth() {
        int i = 0;
        Expansion exp = this;
        while (!exp.equals(exp.getRoot())) {
            exp = exp.getParent();
            ++i;
        }
        return i;
    }

    public void materialize(Object element, int childSize, boolean expand) {
        Assert.isTrue((!this.isOutOfRangeMarker && this.isVirtual && this.directChildSize == 0 && this.allChildSize == 0 && (this.element == null || this.element.equals(element)) ? 1 : 0) != 0);
        Expansion.validateExpansionInfo(element, childSize);
        this.parent.validateChildIndex(this.index, false);
        this.setInfo(element, childSize);
        this.isCollapsed = !expand;
        this.isVirtual = false;
        this.parent.linkChild(this.index, this);
    }

    private void setInfo(Object element, int childSize) {
        this.directChildSize = childSize;
        this.allChildSize = childSize;
        this.element = element;
    }

    public void collapse(boolean preserveChildInfo) {
        Assert.isTrue((!this.isVirtual ? 1 : 0) != 0);
        if (this.isCollapsed) {
            return;
        }
        if (this.parent != null) {
            if (preserveChildInfo && this.hasChildExpansions()) {
                if (this.allChildSize != 0) {
                    this.parent.childSizeChanged(this, -this.allChildSize);
                }
                this.isCollapsed = true;
            } else {
                this.virtualize();
            }
        }
    }

    public void virtualize() {
        if (this.isVirtual) {
            return;
        }
        if (this.isCollapsed) {
            this.directChildSize = 0;
            this.allChildSize = 0;
        }
        Expansion curParent = this.parent;
        Integer curIndex = this.index;
        this.parent.unlinkChild(this);
        this.indexToChildMap = null;
        this.directChildSize = 0;
        this.allChildSize = 0;
        this.isVirtual = true;
        this.isCollapsed = true;
        this.parent = curParent;
        this.parent.linkChild(curIndex, this);
    }

    public void expand() {
        Assert.isTrue((!this.isVirtual ? 1 : 0) != 0);
        if (!this.isCollapsed) {
            return;
        }
        this.isCollapsed = false;
        if (this.parent != null && this.allChildSize != 0) {
            this.parent.childSizeChanged(this, this.allChildSize);
        }
    }

    private void unlinkChild(Expansion child) {
        Integer index = child.index;
        child.reverseUnlinkParent();
        this.rootExpansion.unlinkExpansion(child);
        this.getIndexToChildMap(false).remove(index);
    }

    public int getDirectChildSize(boolean checkExpanded) {
        return checkExpanded && this.isCollapsed ? 0 : this.directChildSize;
    }

    public int getDirectChildCount() {
        return this.getDirectChildSize(false);
    }

    public int getAllChildSize(boolean checkExpanded) {
        return checkExpanded && this.isCollapsed ? 0 : this.allChildSize;
    }

    public boolean hasChildExpansions() {
        return this.allChildSize != this.directChildSize;
    }

    public boolean hasDirectChildren(boolean expanded) {
        if (!this.hasChildExpansions()) {
            return false;
        }
        return this.hasDirectChildren(this.indexToChildMap, expanded);
    }

    public boolean hasDirectChildren(int startIndex, int stopIndex, boolean expanded) {
        if (!this.hasChildExpansions()) {
            return false;
        }
        SortedMap map = this.indexToChildMap.subMap(new Integer(startIndex), new Integer(stopIndex));
        return this.hasDirectChildren(map, expanded);
    }

    public boolean hasDirectChildren(SortedMap map, boolean expanded) {
        if (map == null || map.size() == 0) {
            return false;
        }
        for (Expansion child : map.values()) {
            if (child.isExpanded() != expanded) continue;
            return true;
        }
        return false;
    }

    private void reverseUnlinkParent() {
        if (this.parent != null) {
            if (!this.isCollapsed && this.allChildSize != 0) {
                this.parent.childSizeChanged(this, -this.allChildSize);
            }
            this.parent = null;
            this.index = null;
        }
    }

    public Expansion getDirectExistingChildByIndex(int index) {
        if (this.indexToChildMap == null || this.indexToChildMap.size() == 0) {
            return null;
        }
        return (Expansion)this.indexToChildMap.get(new Integer(index));
    }

    private void linkChild(Integer index, Expansion child) {
        if (!child.isCollapsed && !child.isVirtual) {
            TreeMap iMap = this.getIndexToChildMap(true);
            Assert.isTrue((iMap.get(index) == null ? 1 : 0) != 0);
            iMap.put(index, child);
        }
        if (!child.isVirtual()) {
            this.rootExpansion.linkExpansion(child);
        }
        child.reverseLinkParent(this, index, child.isVirtual ? null : new Integer(this.rootIndexOf(index)));
    }

    private void reverseLinkParent(Expansion parent, Integer index, Integer rootIndex) {
        this.parent = parent;
        this.index = index;
        this.rootIndex = rootIndex;
        this.rootExpansion = parent.rootExpansion;
        if (!this.isCollapsed) {
            parent.childSizeChanged(this, this.allChildSize);
        }
    }

    public boolean isRoot() {
        return this.rootExpansion == this;
    }

    public RootExpansion getRoot() {
        return this.rootExpansion;
    }

    private void childSizeChanged(Expansion directChild, int change) {
        if (change == 0) {
            return;
        }
        int newAllSize = this.allChildSize + change;
        Assert.isTrue((newAllSize >= 0 ? 1 : 0) != 0);
        this.allChildSize = newAllSize;
        SortedMap subMap = this.getIndexToChildMap(false).tailMap(new Integer(directChild.index + 1));
        this.changeGlobalIndexForChildren(subMap, change);
        if (this.parent != null && !this.isCollapsed) {
            this.parent.childSizeChanged(this, change);
        }
    }

    public int getRootIndex() {
        if (this.isVirtual) {
            return this.parent.rootIndexOf(this);
        }
        return this.rootIndex != null ? this.rootIndex : -1;
    }

    private void changeGlobalIndex(int change) {
        int newRootIndex = this.rootIndex + change;
        Assert.isTrue((newRootIndex >= 0 ? 1 : 0) != 0);
        if (change != 0) {
            this.rootIndex = new Integer(newRootIndex);
            TreeMap map = this.getIndexToChildMap(false);
            if (map != null) {
                this.changeGlobalIndexForChildren(map, change);
            }
        }
    }

    private int rootIndexOf(Expansion directChild) {
        return this.rootIndexOf(directChild.index);
    }

    private int rootIndexOf(Integer index) {
        int indexIntValue = index;
        if (this.indexToChildMap == null || this.indexToChildMap.size() == 0) {
            return this.getRootIndex() + indexIntValue + 1;
        }
        SortedMap subMap = this.indexToChildMap.headMap(index);
        if (subMap.isEmpty()) {
            return this.getRootIndex() + indexIntValue + 1;
        }
        Expansion exp = (Expansion)subMap.get(subMap.lastKey());
        int result = exp.rootIndex + indexIntValue - exp.index;
        return result += exp.getAllChildSize(true);
    }

    private void changeGlobalIndexForChildren(SortedMap map, int change) {
        for (Expansion exp : map.values()) {
            exp.changeGlobalIndex(change);
        }
    }

    private TreeMap getIndexToChildMap(boolean create) {
        if (this.indexToChildMap == null && create) {
            this.indexToChildMap = new TreeMap();
        }
        return this.indexToChildMap;
    }

    private static void validateExpansionInfo(Object element, int size) {
        Assert.isTrue((element != null && size >= 0 ? 1 : 0) != 0);
    }

    public Expansion getDirectChildByIndex(int index, boolean generateOutOfRangeMarker) {
        this.validateChildIndex(index, this.isOutOfRangeMarker);
        if (generateOutOfRangeMarker && index == this.directChildSize) {
            return this.createChild(index, null, 0, true, true, false);
        }
        Expansion result = null;
        if (this.indexToChildMap != null && this.indexToChildMap.size() != 0) {
            result = (Expansion)this.indexToChildMap.get(new Integer(index));
        }
        if (result != null) {
            return result;
        }
        return this.createChild(index, null, 0, false, true, false);
    }

    public Expansion getChildExpansionByOffset(int offset, boolean generateOutOfRangeMarker) {
        if (this.isCollapsed || this.isVirtual) {
            return null;
        }
        if (this.allChildSize <= offset) {
            if (generateOutOfRangeMarker && this.allChildSize == offset) {
                return this.createChild(this.directChildSize, null, 0, true, true, false);
            }
            return null;
        }
        TreeMap map = this.getIndexToChildMap(false);
        if (map == null || map.size() == 0) {
            return this.createChild(offset, null, 0, false, true, false);
        }
        int rootIndex = this.getRootIndex();
        int tailNonexpendedChildOffset = 0;
        int tailNonExpendedChildIndex = 0;
        for (Expansion child : map.values()) {
            int childOffset = child.getRootIndex() - rootIndex - 1;
            if (childOffset == offset) {
                return child;
            }
            if (childOffset >= offset) break;
            int childSize = child.getAllChildSize(true);
            if (childOffset + childSize >= offset) {
                return child.getChildExpansionByOffset(offset - childOffset - 1, false);
            }
            tailNonexpendedChildOffset = childOffset + childSize + 1;
            tailNonExpendedChildIndex = child.getIndex() + 1;
        }
        Assert.isTrue((offset >= tailNonexpendedChildOffset ? 1 : 0) != 0);
        return this.createChild(tailNonExpendedChildIndex + offset - tailNonexpendedChildOffset, null, 0, this.isOutOfRangeMarker, true, false);
    }

    public boolean isChildOf(Expansion exp) {
        Expansion p = this.parent;
        while (p != null) {
            if (p == exp) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isParentOf(Expansion exp) {
        return exp.isChildOf(this);
    }

    public Expansion getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isOutOfRangeMarker() {
        return this.isOutOfRangeMarker;
    }

    public Expansion getRelativeExpansion(int offset) {
        if (offset == 0) {
            return this;
        }
        if (offset > 0) {
            if (!this.isCollapsed && this.allChildSize >= offset) {
                return this.getChildExpansionByOffset(offset - 1, false);
            }
            if (this.parent != null) {
                return this.parent.getRelativeExpansion(offset + this.getRootIndex() - this.parent.getRootIndex());
            }
            return null;
        }
        if (this.getRootIndex() < -offset) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.getRelativeExpansion(offset + this.getRootIndex() - this.parent.getRootIndex());
        }
        return null;
    }

    public Expansion[] getParents(boolean includeThis, boolean bottomUp) {
        int depth = this.getDepth();
        Expansion[] parents = new Expansion[includeThis ? depth + 1 : depth];
        if (bottomUp) {
            int cursor = parents.length - 1;
            Expansion start = includeThis ? this : this.parent;
            while (start != null) {
                parents[cursor--] = start;
                start = start.parent;
            }
        } else {
            int cursor = 0;
            Expansion start = includeThis ? this : this.parent;
            while (start != null) {
                parents[cursor++] = start;
                start = start.parent;
            }
        }
        return parents;
    }

    public boolean isExpanded() {
        return !this.isCollapsed;
    }

    public boolean isVisible() {
        return this.parent != null ? !this.parent.isCollapsed && this.parent.isVisible() : true;
    }

    public Expansion[] getDirectChildren() {
        if (this.indexToChildMap == null || this.indexToChildMap.size() == 0) {
            return new Expansion[0];
        }
        Expansion[] result = new Expansion[this.indexToChildMap.size()];
        this.indexToChildMap.values().toArray(result);
        return result;
    }

    public Expansion[] getDirectChildren(int startIndex, int endIndex, boolean expanded) {
        this.assertStartEndIndex(startIndex, endIndex);
        if (this.indexToChildMap == null || this.indexToChildMap.size() == 0) {
            return new Expansion[0];
        }
        SortedMap map = this.indexToChildMap.subMap(new Integer(startIndex), new Integer(endIndex));
        return this.getDirectChildren(map, expanded);
    }

    public boolean isDirectChildExpanded(int index) {
        return this.indexToChildMap != null && this.indexToChildMap.size() != 0 && this.indexToChildMap.containsKey(new Integer(index));
    }

    private void assertStartEndIndex(int startIndex, int endIndex) {
        Assert.isTrue((startIndex >= 0 && startIndex <= endIndex && endIndex <= this.directChildSize ? 1 : 0) != 0);
    }

    public Expansion[] getDirectChildren(boolean expanded) {
        return this.getDirectChildren(this.indexToChildMap, expanded);
    }

    private Expansion[] getDirectChildren(SortedMap map, boolean expanded) {
        if (map == null || map.size() == 0) {
            return new Expansion[0];
        }
        Expansion[] result = new Expansion[map.size()];
        int cursor = 0;
        for (Expansion exp : map.values()) {
            if (exp.isExpanded() != expanded) continue;
            result[cursor++] = exp;
        }
        if (cursor < result.length) {
            if (cursor == 0) {
                result = new Expansion[]{};
            } else {
                Expansion[] tmp = new Expansion[cursor];
                System.arraycopy(result, 0, tmp, 0, cursor);
                result = tmp;
            }
        }
        return result;
    }

    public int hashCode() {
        if (!this.isVirtual) {
            return super.hashCode();
        }
        int result = 1;
        result = 31 * result + this.rootExpansion.hashCode();
        result = 31 * result + this.rootIndex.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!this.isVirtual) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expansion other = (Expansion)obj;
        if (!other.isVirtual) {
            return false;
        }
        if (!this.rootExpansion.equals(other.rootExpansion)) {
            return false;
        }
        return this.getRootIndex() == other.getRootIndex();
    }

    public TreePath toTreePath() {
        Assert.isTrue((this.element != null ? 1 : 0) != 0);
        Object[] path = new Object[this.getDepth()];
        int cursor = path.length - 1;
        Expansion start = this;
        while (!start.equals(this.rootExpansion)) {
            path[cursor--] = start.element;
            start = start.parent;
        }
        return new TreePath(path);
    }

    public int compareTo(Object o) {
        return this.getRootIndex() - ((Expansion)o).getRootIndex();
    }

    public void setData(Object data) {
        Assert.isTrue((this.isVirtual || this.element.equals(data) ? 1 : 0) != 0);
        this.element = data;
    }
}

