/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.fragment;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.trace.views.internal.fragment.Expansion;
import org.eclipse.hyades.trace.views.internal.fragment.IExpansionSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

class ExpansionSelection
extends TreeSelection
implements IExpansionSelection {
    private HashMap expansionMap;
    private Expansion[] expansions;
    static final Expansion[] EMPTY_EXPANSION_ARRAY = new Expansion[0];
    static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    public static final ExpansionSelection EMPTY = new ExpansionSelection();

    public ExpansionSelection() {
        this((Expansion[])null);
    }

    public ExpansionSelection(Expansion exp) {
        this(new Expansion[]{exp});
    }

    public ExpansionSelection(Expansion[] exps) {
        super(ExpansionSelection.expsToTreePaths(exps));
        if (exps != null && exps.length != 0) {
            this.expansions = (Expansion[])exps.clone();
            this.expansionMap = new HashMap();
            int i = 0;
            while (i < exps.length) {
                Expansion exp = exps[i];
                Assert.isTrue((exp.getData() != null ? 1 : 0) != 0);
                this.expansionMap.put(exp.getData(), exp);
                ++i;
            }
        }
    }

    private static TreePath[] expsToTreePaths(Expansion[] exps) {
        if (exps == null || exps.length == 0) {
            return EMPTY_TREEPATH_ARRAY;
        }
        TreePath[] paths = new TreePath[exps.length];
        int i = 0;
        while (i < exps.length) {
            paths[i] = exps[i].toTreePath();
            ++i;
        }
        return paths;
    }

    public Expansion[] getExpansions() {
        return this.expansions != null ? (Expansion[])this.expansions.clone() : EMPTY_EXPANSION_ARRAY;
    }

    public Expansion[] getExpansionsFor(Object element) {
        Object exp = this.expansionMap.get(element);
        if (exp == null) {
            return EMPTY_EXPANSION_ARRAY;
        }
        if (exp instanceof Expansion) {
            return new Expansion[]{(Expansion)exp};
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public boolean equals(Object obj) {
        Expansion[] otherExps;
        if (!(obj instanceof ExpansionSelection)) {
            return super.equals(obj);
        }
        ExpansionSelection other = (ExpansionSelection)obj;
        Expansion[] exps = this.getExpansions();
        if (exps.length != (otherExps = other.getExpansions()).length) {
            return false;
        }
        int i = 0;
        while (i < exps.length) {
            if (!exps[i].equals(otherExps[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int code = this.getClass().hashCode();
        if (this.expansions != null) {
            int i = 0;
            while (i < this.expansions.length) {
                code = code * 17 + this.expansions[i].hashCode();
                ++i;
            }
        }
        return code;
    }
}

