/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.fragment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.trace.views.internal.fragment.DbgUtil;
import org.eclipse.hyades.trace.views.internal.fragment.Expansion;
import org.eclipse.hyades.trace.views.internal.fragment.ExpansionRange;
import org.eclipse.hyades.trace.views.internal.fragment.ExpansionSelection;
import org.eclipse.hyades.trace.views.internal.fragment.IElementInfo;
import org.eclipse.hyades.trace.views.internal.fragment.IExpansionSelection;
import org.eclipse.hyades.trace.views.internal.fragment.ILazyFragmentTreeContentProvider;
import org.eclipse.hyades.trace.views.internal.fragment.ILazyFragmentTreeContentWithIndexProvider;
import org.eclipse.hyades.trace.views.internal.fragment.IProviderContext;
import org.eclipse.hyades.trace.views.internal.fragment.RootExpansion;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class FragmentedTreeViewer
extends TreeViewer {
    private boolean contentProviderIsLazyFragmented;
    private boolean contentProviderSupportsIndexInfo;
    private int numItemsInFragmentMode = 500;
    private int fragmentModeThreashold = 10000;
    private boolean preservingSelection;
    private ExpansionRange range;
    private MoveInfo movingInfo;
    private RootExpansion rootExpansion;
    private int itemHeight = -1;

    public FragmentedTreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public FragmentedTreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public FragmentedTreeViewer(Tree tree) {
        super(tree);
        this.setUseHashlookup(true);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree treeControl = (Tree)control;
        if ((treeControl.getStyle() & 0x10000000) != 0) {
            treeControl.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    if (FragmentedTreeViewer.this.contentProviderIsLazyFragmented) {
                        if (FragmentedTreeViewer.this.movingInfo != null) {
                            if (DbgUtil.DEBUG) {
                                DbgUtil.println("data event while move");
                            }
                            FragmentedTreeViewer.this.movingInfo.processItemRequestedWhileMove((TreeItem)event.item);
                            return;
                        }
                        TreeItem item = (TreeItem)event.item;
                        TreeItem parentItem = item.getParentItem();
                        int index = event.index;
                        FragmentedTreeViewer.this.virtualLazyUpdateWidget((Widget)(parentItem == null ? FragmentedTreeViewer.this.getTree() : parentItem), item, index, FragmentedTreeViewer.this.range, true);
                    }
                }
            });
            treeControl.getVerticalBar().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (FragmentedTreeViewer.this.contentProviderIsLazyFragmented) {
                        FragmentedTreeViewer.this.handleScroll(e);
                    }
                }
            });
            treeControl.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (FragmentedTreeViewer.this.contentProviderIsLazyFragmented) {
                        FragmentedTreeViewer.this.handleKey(e);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            treeControl.addMouseWheelListener(new MouseWheelListener(){

                public void mouseScrolled(MouseEvent e) {
                    if (FragmentedTreeViewer.this.contentProviderIsLazyFragmented) {
                        FragmentedTreeViewer.this.handleMouseWeel(e);
                    }
                }
            });
        }
    }

    protected void setExpanded(Item node, boolean expand) {
        if (this.contentProviderIsLazyFragmented) {
            TreeItem item = (TreeItem)node;
            if (expand) {
                item.setExpanded(true);
                this.handleTreeExpand(item, false);
            } else {
                item.setExpanded(false);
                this.handleTreeCollapse(item);
            }
            this.getControl().update();
        }
    }

    protected void setSelectionToWidget(List v, boolean reveal) {
        if (this.contentProviderIsLazyFragmented) {
            Expansion[] exps;
            MoveInfo info;
            if (v == null || v.size() == 0) {
                info = null;
                exps = ExpansionSelection.EMPTY_EXPANSION_ARRAY;
            } else {
                Expansion[] currentSel = this.getSelectedExpansions();
                if (currentSel.length == v.size()) {
                    HashSet<Object> curSel = new HashSet<Object>();
                    int i = 0;
                    while (i < currentSel.length) {
                        curSel.add(currentSel[i].getData());
                        ++i;
                    }
                    curSel.removeAll(v);
                    if (curSel.size() == 0) {
                        return;
                    }
                }
                if (reveal) {
                    info = new MoveInfo(this.rootExpansion, this.range);
                    info.skipTopInfoAdjustment = true;
                    exps = this.getExpansionsFromList(v, true, info);
                    if (info.newRange == null) {
                        info = null;
                    }
                } else {
                    info = null;
                    exps = this.getExpansionsFromList(v, false, null);
                }
            }
            this.setSelectionToWidget(info, exps);
            return;
        }
        super.setSelectionToWidget(v, reveal);
    }

    private void setSelectionToWidget(MoveInfo mInfo, Expansion[] exps) {
        if (mInfo != null) {
            mInfo.selection = exps;
            mInfo.apply();
        } else {
            this.setSelection(exps);
        }
    }

    private Expansion[] getExpansionsFromList(List list, boolean reveal, MoveInfo info) {
        int size = list.size();
        Expansion[] result = size != 0 ? new Expansion[size] : ExpansionSelection.EMPTY_EXPANSION_ARRAY;
        int cursor = 0;
        int i = 0;
        while (i < size) {
            Object elementOrTreePath = list.get(i);
            Expansion exp = this.findExpansion(info, elementOrTreePath, reveal);
            if (exp != null && (reveal || exp.isVisible() && this.range.getRelation(exp) != 0)) {
                result[cursor++] = exp;
            }
            ++i;
        }
        if (cursor < result.length) {
            if (cursor == 0) {
                result = ExpansionSelection.EMPTY_EXPANSION_ARRAY;
            } else {
                Expansion[] tmp = new Expansion[cursor];
                System.arraycopy(result, 0, tmp, 0, cursor);
                result = tmp;
            }
        }
        return result;
    }

    protected void setSelection(List items) {
        if (this.contentProviderIsLazyFragmented) {
            Assert.isTrue((boolean)false);
            return;
        }
        super.setSelection(items);
    }

    protected boolean isSameSelection(List items, Item[] current) {
        if (this.contentProviderIsLazyFragmented) {
            Assert.isTrue((boolean)false);
            return true;
        }
        return super.isSameSelection(items, current);
    }

    private Expansion materializeExpansionIfHasChildren(MoveInfo info, Expansion exp) {
        Assert.isTrue((boolean)exp.isVirtual());
        return new ExpansionMaterializationContext(info, exp).getMaterializedExpansion();
    }

    private Expansion findExpansion(MoveInfo mInfo, Object elementOrTreePath, boolean revealAndExpandParents) {
        Object element = this.getElementFromElementOrTreePath(elementOrTreePath);
        Expansion exp = this.rootExpansion.getExpansion(element);
        Expansion expandedRoot = null;
        if (exp == null && this.contentProviderSupportsIndexInfo) {
            ArrayList<SimpleMaterializationContext> elList = revealAndExpandParents ? new ArrayList<SimpleMaterializationContext>(5) : new ArrayList(1);
            Object childEl = element;
            Object parentElOrPath = this.getParentElement(elementOrTreePath);
            Expansion parentExp = null;
            while (parentElOrPath != null) {
                Object parentEl = this.getElementFromElementOrTreePath(parentElOrPath);
                Expansion e = this.rootExpansion.getExpansion(parentEl);
                if (e != null) {
                    parentExp = e;
                    elList.add(new SimpleMaterializationContext(e.getData(), -1, childEl));
                    break;
                }
                if (!revealAndExpandParents) break;
                elList.add(new SimpleMaterializationContext(parentEl, -1, childEl));
                childEl = parentEl;
                parentElOrPath = this.getParentElement(parentElOrPath);
            }
            if (parentExp != null) {
                SimpleMaterializationContext c;
                if (elList != null && elList.size() != 0) {
                    int i = elList.size() - 1;
                    while (i >= 0) {
                        c = (SimpleMaterializationContext)elList.get(i);
                        if (c.getIndex() < 0) {
                            return null;
                        }
                        --i;
                    }
                }
                if (elList != null && elList.size() != 0) {
                    int i = elList.size() - 1;
                    while (i >= 0) {
                        c = (SimpleMaterializationContext)elList.get(i);
                        parentExp = parentExp.getDirectChildByIndex(c.getIndex(), false);
                        parentExp.setData(c.getData());
                        if (i != 0) {
                            parentExp = mInfo.expandExpansion(parentExp, c.getData(), c.getDirectChildCount());
                            if (expandedRoot == null) {
                                expandedRoot = parentExp;
                            }
                        }
                        --i;
                    }
                    exp = parentExp;
                }
            }
        }
        if (exp != null) {
            if (expandedRoot != null) {
                Expansion forceExp = null;
                if (expandedRoot.isVisible()) {
                    forceExp = expandedRoot;
                } else {
                    Expansion[] parents = expandedRoot.getParents(false, true);
                    int k = 0;
                    while (k < parents.length) {
                        if (!parents[k].isExpanded()) {
                            forceExp = parents[k];
                            break;
                        }
                        ++k;
                    }
                    mInfo.makeVisible(forceExp);
                }
                Assert.isTrue((forceExp != null ? 1 : 0) != 0);
                mInfo.addForceExpansion(forceExp);
                mInfo.oldRange.clearCache();
                if (mInfo.newRange == null) {
                    mInfo.newRange = mInfo.oldRange;
                }
            }
            if (mInfo.newTopExpansion == null) {
                Expansion curTop = this.getTopVisibleExpansion();
                if (curTop == null) {
                    mInfo.newTopExpansion = exp;
                } else {
                    int newTopRoot;
                    int topRoot = curTop.getRootIndex();
                    if (topRoot >= (newTopRoot = exp.getRootIndex())) {
                        mInfo.setNewTopVisibleExpansion(exp);
                    } else {
                        int numVis = this.getNumVisibleItems();
                        if (topRoot + numVis <= newTopRoot) {
                            mInfo.setNewTopVisibleExpansion(exp);
                        } else {
                            mInfo.newTopExpansion = curTop;
                        }
                    }
                }
            }
        }
        return exp;
    }

    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }

    protected Item getChild(Widget widget, int index) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItem(index);
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItem(index);
        }
        return null;
    }

    protected void assertContentProviderType(IContentProvider provider) {
        if (provider instanceof ILazyFragmentTreeContentProvider) {
            return;
        }
        super.assertContentProviderType(provider);
    }

    protected Object[] getRawChildren(Object parent) {
        if (this.contentProviderIsLazyFragmented) {
            return new Object[0];
        }
        return super.getRawChildren(parent);
    }

    public void setChildCount(Object elOrTreePath, int c) {
        if (this.contentProviderIsLazyFragmented) {
            throw new UnsupportedOperationException();
        }
        super.setChildCount(elOrTreePath, c);
    }

    private int calcChildCount(ExpansionRange range, Expansion exp) {
        return Math.max(1, range.getDirectChildCount(exp));
    }

    private Object getElementFromElementOrTreePath(Object elOrTreePath) {
        if (elOrTreePath instanceof TreePath) {
            TreePath path = (TreePath)elOrTreePath;
            if (path.getSegmentCount() == 0) {
                return this.getInput();
            }
            return path.getLastSegment();
        }
        return elOrTreePath;
    }

    private int getMaxRangeSize(RootExpansion rootExpansion) {
        return rootExpansion.getAllChildSize(false) > this.fragmentModeThreashold ? this.numItemsInFragmentMode : rootExpansion.getAllChildSize(false);
    }

    private Object getData(Widget w, boolean access) {
        return w instanceof TreeItem ? this.getData((TreeItem)w, access) : this.getInput();
    }

    private Object getData(TreeItem item, boolean access) {
        if (access) {
            item.getText();
        }
        return item.getData();
    }

    private TreeItem getTreeItem(Expansion exp) {
        if (DbgUtil.DEBUG) {
            Assert.isTrue((this.movingInfo == null || this.range.equals(this.movingInfo.oldRange) ? 1 : 0) != 0);
        }
        if (exp.isRoot() || this.range.getRelation(exp) == 0) {
            return null;
        }
        Expansion[] exps = exp.getParents(true, true);
        int index = this.range.getIndex(exps[1]);
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        TreeItem item = this.getTree().getItem(index);
        int i = 2;
        while (i < exps.length) {
            index = this.range.getIndex(exps[i]);
            Assert.isTrue((index >= 0 ? 1 : 0) != 0);
            item = item.getItem(index);
            ++i;
        }
        return item;
    }

    private Expansion getExpansion(Widget w) {
        return w instanceof TreeItem ? this.getExpansion((TreeItem)w) : this.rootExpansion;
    }

    private Expansion getExpansion(TreeItem item) {
        int itemIndex;
        Expansion parentExpansion;
        TreeItem parentItem;
        Tree tree;
        if (DbgUtil.DEBUG) {
            Assert.isTrue((this.movingInfo == null || this.range.equals(this.movingInfo.oldRange) ? 1 : 0) != 0);
        }
        Tree tree2 = tree = (parentItem = item.getParentItem()) == null ? item.getParent() : null;
        if (parentItem != null) {
            Object parentElement = this.getData(parentItem, false);
            if (parentElement == null) {
                int parentIndex;
                TreeItem parentParent;
                Assert.isTrue((boolean)parentItem.getExpanded());
                Expansion parentExp = this.getExpansion(parentItem);
                if (parentExp == null || parentExp.isVirtual()) {
                    return null;
                }
                Assert.isTrue((boolean)parentExp.isExpanded());
                TreeItem parentParentItem = parentItem.getParentItem();
                if (parentParentItem != null) {
                    parentParent = parentParentItem;
                    parentIndex = parentParentItem.indexOf(parentItem);
                } else {
                    Tree ptree = parentItem.getParent();
                    parentParent = ptree;
                    parentIndex = ptree.indexOf(parentItem);
                }
                this.virtualLazyUpdateWidget((Widget)parentParent, parentItem, parentIndex, this.range, true);
                parentElement = this.getData(parentItem, false);
            }
            Assert.isTrue((parentElement != null ? 1 : 0) != 0);
            parentExpansion = this.rootExpansion.getExpansion(parentElement);
            Assert.isTrue((parentExpansion != null ? 1 : 0) != 0);
            itemIndex = parentItem.indexOf(item);
        } else {
            parentExpansion = this.rootExpansion;
            itemIndex = tree.indexOf(item);
        }
        int startOffset = this.range.getStartIndex(parentExpansion);
        Assert.isTrue((startOffset >= 0 ? 1 : 0) != 0);
        Expansion result = parentExpansion.getDirectChildByIndex(itemIndex + startOffset, false);
        if (result.getData() == null) {
            result.setData(item.getData());
        }
        Assert.isTrue((this.range.getRelation(result) != 0 ? 1 : 0) != 0);
        return result;
    }

    private void setChildCountToTree(final Tree tree, final int c) {
        this.preservingSelection(new Runnable(){

            public void run() {
                tree.setItemCount(c);
            }
        });
    }

    private void setChildCountToItem(final TreeItem item, final int c) {
        this.preservingSelection(new Runnable(){

            public void run() {
                item.setItemCount(c);
            }
        });
    }

    public void replace(Object parentElementOrTreePath, int index, Object element) {
        if (this.contentProviderIsLazyFragmented) {
            throw new UnsupportedOperationException();
        }
        super.replace(parentElementOrTreePath, index, element);
    }

    private void replace(Widget parent, int index, Object element) {
        ExpansionSelection sel;
        Item[] selItems;
        if (this.checkBusy()) {
            return;
        }
        if (this.preservingSelection) {
            selItems = null;
            sel = null;
        } else {
            selItems = this.getSelection(this.getControl());
            sel = (ExpansionSelection)this.getSelection();
        }
        Widget[] itemsToDisassociate = this.internalFindItems(element);
        if (parent instanceof Tree) {
            Tree tree = (Tree)parent;
            if (index < tree.getItemCount()) {
                TreeItem item = tree.getItem(index);
                if (!this.preservingSelection) {
                    sel = this.adjustSelectionForReplace(selItems, sel, item, element, this.getRoot());
                }
                int i = 0;
                while (i < itemsToDisassociate.length) {
                    TreeItem itemToDisassociate;
                    if (itemsToDisassociate[i] instanceof TreeItem && (itemToDisassociate = (TreeItem)itemsToDisassociate[i]) != item && itemToDisassociate.getParentItem() == null) {
                        int indexToDisassociate = this.getTree().indexOf(itemToDisassociate);
                        this.disassociate((Item)itemToDisassociate);
                        this.getTree().clear(indexToDisassociate, true);
                    }
                    ++i;
                }
                Object oldData = item.getData();
                this.updateItem((Widget)item, element);
                if (!this.equals(oldData, element)) {
                    item.clearAll(true);
                }
            }
        } else {
            TreeItem parentItem = (TreeItem)parent;
            if (index < parentItem.getItemCount()) {
                TreeItem item = parentItem.getItem(index);
                if (!this.preservingSelection) {
                    sel = this.adjustSelectionForReplace(selItems, sel, item, element, parentItem.getData());
                }
                int j = 0;
                while (j < itemsToDisassociate.length) {
                    TreeItem itemToDisassociate;
                    if (itemsToDisassociate[j] instanceof TreeItem && (itemToDisassociate = (TreeItem)itemsToDisassociate[j]) != item && itemToDisassociate.getParentItem() == parentItem) {
                        int indexToDisaccociate = parentItem.indexOf(itemToDisassociate);
                        this.disassociate((Item)itemToDisassociate);
                        parentItem.clear(indexToDisaccociate, true);
                    }
                    ++j;
                }
                Object oldData = item.getData();
                this.updateItem((Widget)item, element);
                if (!this.equals(oldData, element)) {
                    item.clearAll(true);
                }
            }
        }
        if (!this.preservingSelection) {
            this.setSelectionToWidget((ISelection)sel, false);
            ISelection newSelection = this.getSelection();
            if (!newSelection.equals(sel)) {
                this.handleInvalidSelection((ISelection)sel, newSelection);
            }
        }
    }

    private ExpansionSelection adjustSelectionForReplace(Item[] selectedItems, ExpansionSelection selection, TreeItem item, Object element, Object parentElement) {
        if (item.getData() != null || selectedItems.length == selection.size() || parentElement == null) {
            return selection;
        }
        int i = 0;
        while (i < selectedItems.length) {
            Expansion exp;
            if (item == selectedItems[i] && (exp = this.getExpansion(item)) != null) {
                if (exp.getData() == null) {
                    exp.setData(element);
                }
                Expansion[] originalExpansions = selection.getExpansions();
                int length = originalExpansions.length;
                Expansion[] exps = new Expansion[length + 1];
                System.arraycopy(originalExpansions, 0, exps, 0, length);
                exps[length] = exp;
                return new ExpansionSelection(exps);
            }
            ++i;
        }
        return selection;
    }

    public boolean isExpandable(Object element) {
        if (this.contentProviderIsLazyFragmented) {
            TreeItem treeItem = (TreeItem)this.internalExpand(element, false);
            if (treeItem == null) {
                return false;
            }
            this.virtualMaterializeItem(treeItem, this.range);
            return treeItem.getItemCount() > 0;
        }
        return super.isExpandable(element);
    }

    protected Object getParentElement(Object element) {
        boolean oldBusy = this.isBusy();
        this.setBusy(true);
        try {
            if (this.contentProviderIsLazyFragmented && !(element instanceof TreePath)) {
                ILazyFragmentTreeContentProvider lazyTreeContentProvider = (ILazyFragmentTreeContentProvider)this.getContentProvider();
                Object object = lazyTreeContentProvider.getParent(element);
                return object;
            }
            Object object = super.getParentElement(element);
            return object;
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createChildren(Widget widget) {
        if (this.contentProviderIsLazyFragmented) {
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                if (!item.getExpanded()) return;
                Expansion exp = this.getExpansion(item);
                if (!exp.isExpanded()) {
                    exp = this.handleTreeExpand(item, true);
                    if (exp.getDirectChildSize(false) == 0) {
                        return;
                    }
                    Assert.isTrue((boolean)exp.isExpanded());
                    widget = this.getTreeItem(exp);
                }
            } else if (widget.getData() == null) {
                return;
            }
            TreeItem[] children = (TreeItem[])this.getChildren(widget);
            int i = 0;
            while (i < children.length) {
                if (children[i].getData() == null) {
                    this.virtualLazyUpdateWidget(widget, children[i], i, this.range, true);
                }
                ++i;
            }
            return;
        }
        super.createChildren(widget);
    }

    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        if (this.contentProviderIsLazyFragmented) {
            if (widget instanceof TreeItem) {
                TreeItem ti = (TreeItem)widget;
                int count = ti.getItemCount() + childElements.length;
                ti.setItemCount(count);
                ti.clearAll(false);
            } else {
                Tree t = (Tree)widget;
                t.setItemCount(t.getItemCount() + childElements.length);
                t.clearAll(false);
            }
            return;
        }
        super.internalAdd(widget, parentElement, childElements);
    }

    private void virtualMaterializeItem(TreeItem treeItem, ExpansionRange range) {
        if (treeItem.getData() != null) {
            return;
        }
        if (!this.contentProviderIsLazyFragmented) {
            return;
        }
        this.virtualLazyUpdateWidget(treeItem, range, true);
    }

    private void virtualLazyUpdateWidget(TreeItem treeItem, ExpansionRange range, boolean fullUpdate) {
        Object parentElement;
        TreeItem parent = treeItem.getParentItem();
        if (parent == null) {
            parent = treeItem.getParent();
        }
        if ((parentElement = parent.getData()) != null) {
            int index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
            this.virtualLazyUpdateWidget((Widget)parent, treeItem, index, range, true);
        }
    }

    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        if (this.contentProviderIsLazyFragmented) {
            if (widget instanceof TreeItem) {
                throw new UnsupportedOperationException();
            }
            if (element == null) {
                ((Tree)widget).setItemCount(0);
                this.rootExpansion = null;
                return;
            }
            this.initializeTreeInfo((Tree)widget);
            RootExpansion expansion = this.rootExpansion;
            MoveInfo info = new MoveInfo(this.rootExpansion, this.range);
            info.skipTopInfoAdjustment = true;
            if (this.rootExpansion.getDirectChildSize(false) != 0) {
                this.range = this.adjustRangeOnRefresh(this.range);
            }
            info.newRange = this.range;
            if (expansion.isExpanded()) {
                info.addForceExpansion(expansion);
            }
            info.apply();
            return;
        }
        super.internalRefreshStruct(widget, element, updateLabels);
    }

    private ExpansionRange adjustRangeOnRefresh(ExpansionRange range) {
        range.assertValid();
        int numEls = this.rootExpansion.getAllChildSize(false);
        int numItemsAllowed = this.getMaxRangeSize(this.rootExpansion);
        if (numEls <= numItemsAllowed) {
            return ExpansionRange.createExpansionRange(this.rootExpansion, 0, numEls);
        }
        int oldSize = range.getSize(false);
        int oldStart = range.getStartOffset();
        int newSize = numItemsAllowed;
        int newStart = oldSize < numItemsAllowed ? (oldStart + newSize <= numEls ? oldStart : numEls - newSize) : oldStart;
        return ExpansionRange.createExpansionRange(this.rootExpansion, newStart, newSize);
    }

    protected void internalInitializeTree(Control widget) {
        if (this.contentProviderIsLazyFragmented && widget instanceof Tree && widget.getData() != null) {
            this.initializeTreeInfo((Tree)widget);
            return;
        }
        super.internalInitializeTree(widget);
    }

    private void initializeTreeInfo(Tree tree) {
        RootExpansionMaterializationContext context = new RootExpansionMaterializationContext(this.getInput());
        this.rootExpansion = context.getMaterializedRootExpansion();
        this.range = ExpansionRange.createExpansionRange(this.rootExpansion, 0, this.getMaxRangeSize(this.rootExpansion));
        this.setChildCountToTree(tree, this.range.getDirectChildCount(this.rootExpansion));
    }

    protected void updatePlus(Item item, Object element) {
        if (this.contentProviderIsLazyFragmented) {
            this.virtualLazyUpdateWidget((TreeItem)item, this.range, false);
        } else {
            super.updatePlus(item, element);
        }
    }

    public void remove(Object parentOrTreePath, int index) {
        if (this.checkBusy()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    protected void handleTreeExpand(TreeEvent event) {
        if (this.contentProviderIsLazyFragmented) {
            Expansion exp;
            if (!this.isExpandCollapseHandlingDisabled() && (exp = this.handleTreeExpand((TreeItem)event.item, false)) != null) {
                this.fireTreeExpanded(new TreeExpansionEvent((AbstractTreeViewer)this, exp.getData()));
            }
            return;
        }
        super.handleTreeExpand(event);
    }

    private Expansion handleTreeExpand(TreeItem item, boolean forceParentCreate) {
        Object data = item.getData();
        if (data != null || forceParentCreate) {
            Expansion exp;
            MoveInfo expandCollapseMoveInfo = new MoveInfo(this.rootExpansion, this.range);
            expandCollapseMoveInfo.selection = this.getSelectedExpansions();
            expandCollapseMoveInfo.newTopExpansion = this.getTopVisibleExpansion();
            expandCollapseMoveInfo.curTopExpansion = expandCollapseMoveInfo.newTopExpansion;
            Expansion expansion = exp = data != null ? this.rootExpansion.getExpansion(data) : null;
            if (exp == null) {
                exp = this.getExpansion(item);
                ExpansionMaterializationContext context = new ExpansionMaterializationContext(expandCollapseMoveInfo, exp, data);
                exp = context.getMaterializedExpansion();
            } else {
                expandCollapseMoveInfo.expandExpansion(exp, null, -1);
            }
            if (exp.getDirectChildSize(false) != 0) {
                expandCollapseMoveInfo.addForceExpansion(exp, item);
                Assert.isTrue((boolean)exp.isExpanded());
                expandCollapseMoveInfo.apply();
            } else {
                item.setItemCount(0);
            }
            return exp;
        }
        return null;
    }

    protected void handleTreeCollapse(TreeEvent event) {
        if (this.contentProviderIsLazyFragmented) {
            if (!this.isExpandCollapseHandlingDisabled() && event.item.getData() != null) {
                Object data = event.item.getData();
                this.handleTreeCollapse((TreeItem)event.item);
                this.fireTreeCollapsed(new TreeExpansionEvent((AbstractTreeViewer)this, data));
            }
            return;
        }
        super.handleTreeCollapse(event);
    }

    protected void handleTreeCollapse(TreeItem item) {
        if (item.getData() == null) {
            return;
        }
        MoveInfo expandCollapseMoveInfo = new MoveInfo(this.rootExpansion, this.range);
        expandCollapseMoveInfo.selection = this.getSelectedExpansions();
        expandCollapseMoveInfo.newTopExpansion = this.getTopVisibleExpansion();
        expandCollapseMoveInfo.curTopExpansion = expandCollapseMoveInfo.newTopExpansion;
        expandCollapseMoveInfo.itemCollapsed(item);
        expandCollapseMoveInfo.apply();
    }

    public void setContentProvider(IContentProvider provider) {
        this.contentProviderIsLazyFragmented = provider instanceof ILazyFragmentTreeContentProvider;
        this.contentProviderSupportsIndexInfo = provider instanceof ILazyFragmentTreeContentWithIndexProvider;
        super.setContentProvider(provider);
    }

    public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
        if (this.contentProviderIsLazyFragmented) {
            throw new UnsupportedOperationException();
        }
        super.setHasChildren(elementOrTreePath, hasChildren);
    }

    private void setHasChildrenToItem(final TreeItem item, final boolean hasChildren) {
        this.preservingSelection(new Runnable(){

            public void run() {
                if (!hasChildren) {
                    item.setItemCount(0);
                } else {
                    item.setItemCount(1);
                    TreeItem child = item.getItem(0);
                    if (child.getData() != null) {
                        FragmentedTreeViewer.this.disassociate((Item)child);
                    }
                    item.clear(0, true);
                }
            }
        });
    }

    private void setChildInfoToItem(Widget parent, TreeItem item, int itemIndex, ExpansionRange range, Expansion exp) {
        if (exp.isExpanded()) {
            this.setChildCountToItem(item, this.calcChildCount(range, exp));
        } else {
            this.setHasChildrenToItem(item, exp.getDirectChildSize(false) != 0);
        }
    }

    private void virtualLazyUpdateWidget(Widget parent, TreeItem child, int itemIndex, ExpansionRange range, boolean fullUpdate) {
        boolean oldBusy = this.isBusy();
        this.setBusy(false);
        try {
            Object parentData = this.getData(parent, false);
            if (parentData == null) {
                return;
            }
            Expansion parentExp = this.getExpansion(parent);
            int offset = range.getStartIndex(parentExp);
            Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
            int expIndex = itemIndex + offset;
            Expansion existingChild = parentExp.getDirectExistingChildByIndex(expIndex);
            if (existingChild != null) {
                if (child.getData() == null || fullUpdate) {
                    this.replace(parent, itemIndex, existingChild.getData());
                }
                this.setChildInfoToItem(parent, child, itemIndex, range, existingChild);
            } else {
                Object element;
                if (!fullUpdate) {
                    element = child.getData();
                    if (element == null) {
                        fullUpdate = true;
                    }
                } else {
                    element = null;
                }
                SimpleMaterializationContext context = new SimpleMaterializationContext(parentData, expIndex, element);
                if (fullUpdate) {
                    element = context.getElement();
                    this.replace(parent, itemIndex, element);
                }
                boolean hasChildren = context.getHashChildren();
                this.setHasChildrenToItem(child, hasChildren);
            }
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    protected void disassociate(Item item) {
        if (this.contentProviderIsLazyFragmented) {
            item.setText(" ");
        }
        super.disassociate(item);
    }

    private boolean isScrollDisabled() {
        return this.movingInfo != null;
    }

    private boolean isExpandCollapseHandlingDisabled() {
        return this.movingInfo != null;
    }

    private void handleScroll(SelectionEvent vScrolEvent) {
        if (!this.isScrollDisabled()) {
            boolean scrollMode;
            if (DbgUtil.DEBUG) {
                DbgUtil.println("scrolling type=" + vScrolEvent.detail);
            }
            switch (vScrolEvent.detail) {
                case 0: {
                    if (DbgUtil.DEBUG) {
                        DbgUtil.println("Scroll NONE, skipping ..");
                    }
                    return;
                }
                case 1: 
                case 0x1000007: 
                case 0x1000008: {
                    scrollMode = true;
                    break;
                }
                default: {
                    scrollMode = false;
                }
            }
            MoveInfo info = this.calcMoveInfoOnScroll(scrollMode);
            if (info != null) {
                info.apply();
            }
        }
    }

    private void handleKey(KeyEvent keyEvent) {
        if (!this.isScrollDisabled()) {
            MoveInfo info;
            if (DbgUtil.DEBUG) {
                DbgUtil.println("key code=" + keyEvent.keyCode);
            }
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000005: 
                case 0x1000006: {
                    info = this.calcMoveInfoOnScroll(false);
                    break;
                }
                case 0x1000007: {
                    info = this.calcMoveInfoOnHomeEnd(true);
                    break;
                }
                case 0x1000008: {
                    info = this.calcMoveInfoOnHomeEnd(false);
                    break;
                }
                default: {
                    return;
                }
            }
            if (info != null) {
                info.apply();
            }
        }
    }

    private void handleMouseWeel(MouseEvent e) {
        if (!this.isScrollDisabled()) {
            MoveInfo info;
            if (DbgUtil.DEBUG) {
                DbgUtil.println("mouse weel event");
            }
            if ((info = this.calcMoveInfoOnScroll(false)) != null) {
                info.apply();
            }
        }
    }

    private MoveInfo calcMoveInfoOnScroll(boolean scrollMode) {
        if (this.range.getSize(false) == this.rootExpansion.getAllChildSize(false)) {
            return null;
        }
        TreeInfo info = new TreeInfo();
        Expansion topExp = info.getTopVisibleExpansion();
        if (topExp == null) {
            return null;
        }
        if (this.range.getRelation(topExp) == 2) {
            if (DbgUtil.DEBUG) {
                DbgUtil.println("reference became visible, choose first expansion in range");
            }
            topExp = this.range.getStartExpansion();
        }
        if (DbgUtil.DEBUG) {
            DbgUtil.println("-----------------------");
        }
        MoveInfo mInfo = new MoveInfo(this.rootExpansion, this.range);
        mInfo.curTopExpansion = topExp;
        mInfo.calcNewRangeInfoOnScroll(scrollMode);
        return mInfo;
    }

    private MoveInfo calcMoveInfoOnHomeEnd(boolean home) {
        Expansion topExp;
        if (this.range.getSize(false) == this.rootExpansion.getAllChildSize(false)) {
            return null;
        }
        if (home) {
            topExp = this.rootExpansion.getChildExpansionByOffset(0, false);
        } else {
            int numVis = this.getNumVisibleItems();
            int offset = this.rootExpansion.getAllChildSize(false) - numVis;
            if (offset < 0) {
                offset = 0;
            }
            topExp = this.rootExpansion.getChildExpansionByOffset(offset, false);
        }
        if (topExp == null) {
            return null;
        }
        if (DbgUtil.DEBUG) {
            DbgUtil.println("-----------------------");
        }
        MoveInfo mInfo = new MoveInfo(this.rootExpansion, this.range);
        mInfo.curTopExpansion = topExp;
        mInfo.calcNewRangeInfoOnScroll(true);
        return mInfo;
    }

    private Expansion getTopVisibleExpansion() {
        TreeItem topItem = this.getTree().getTopItem();
        if (topItem == null) {
            return null;
        }
        Expansion exp = this.getExpansion(topItem);
        return exp;
    }

    private int getNumVisibleItems() {
        Tree tree = this.getTree();
        int height = tree.getClientArea().height;
        int headerHeight = tree.getHeaderHeight();
        if ((height -= headerHeight) < 0) {
            if (DbgUtil.DEBUG) {
                DbgUtil.println("height < 0");
            }
            height = 0;
        }
        int itemHeight = this.getItemHeight();
        int numVisibleItems = height / itemHeight;
        if (height % itemHeight != 0) {
            ++numVisibleItems;
        } else if (numVisibleItems == 0) {
            numVisibleItems = 1;
        }
        return numVisibleItems;
    }

    private int getItemHeight() {
        if (this.itemHeight == -1) {
            this.itemHeight = this.getTree().getItemHeight();
        }
        return this.itemHeight;
    }

    private Expansion getBottomVisibleExpansion(Expansion topExpansion, int numVisibleItems) {
        Expansion exp = topExpansion.getRelativeExpansion(numVisibleItems - 1);
        if (exp == null || this.range.getRelation(exp) == 0) {
            exp = this.range.getLastIncludedExpansion();
        }
        Assert.isTrue((this.range.getRelation(exp) != 0 ? 1 : 0) != 0);
        return exp;
    }

    protected void preservingSelection(Runnable updateCode) {
        if (this.preservingSelection) {
            updateCode.run();
            return;
        }
        try {
            this.preservingSelection = true;
            super.preservingSelection(updateCode);
        }
        finally {
            this.preservingSelection = false;
        }
    }

    public void setTopVisibleExpansion(Expansion exp) {
        Assert.isTrue((this.range.getRelation(exp) == 1 ? 1 : 0) != 0);
        TreeItem item = this.getTreeItem(exp);
        Assert.isTrue((item != null ? 1 : 0) != 0);
        this.getTree().setTopItem(item);
    }

    public ISelection getSelection() {
        if (this.contentProviderIsLazyFragmented) {
            Expansion[] exps = this.getSelectedExpansions();
            return exps.length != 0 ? new ExpansionSelection(exps) : ExpansionSelection.EMPTY;
        }
        return super.getSelection();
    }

    private Expansion[] getSelectedExpansions() {
        Tree tree = this.getTree();
        if (tree == null || tree.isDisposed()) {
            return ExpansionSelection.EMPTY_EXPANSION_ARRAY;
        }
        Item[] items = this.getSelection((Control)tree);
        if (items.length == 0) {
            return ExpansionSelection.EMPTY_EXPANSION_ARRAY;
        }
        Object[] exps = new Expansion[items.length];
        int cursor = 0;
        int i = 0;
        while (i < items.length) {
            Expansion exp;
            TreeItem item = (TreeItem)items[i];
            if (item.getData() != null && (exp = this.getExpansion((TreeItem)items[i])) != null) {
                exps[cursor++] = exp;
            }
            ++i;
        }
        if (cursor < exps.length) {
            if (cursor == 0) {
                exps = ExpansionSelection.EMPTY_EXPANSION_ARRAY;
            } else {
                Expansion[] tmp = new Expansion[cursor];
                System.arraycopy(exps, 0, tmp, 0, cursor);
                exps = tmp;
            }
        }
        Arrays.sort(exps);
        return exps;
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        if (selection instanceof IExpansionSelection) {
            this.setSelectionToWidget(null, ((IExpansionSelection)selection).getExpansions());
        } else {
            super.setSelectionToWidget(selection, reveal);
        }
    }

    private void setSelection(Expansion[] exps) {
        Arrays.sort(exps);
        Object[] curSelection = this.getSelectedExpansions();
        if (Arrays.equals(exps, curSelection)) {
            return;
        }
        TreeItem[] items = this.getItems(exps);
        this.getTree().setSelection(items);
    }

    private TreeItem[] getItems(Expansion[] exps) {
        TreeItem[] items = new TreeItem[exps.length];
        int cursor = 0;
        int i = 0;
        while (i < exps.length) {
            TreeItem item = this.getTreeItem(exps[i]);
            if (item != null) {
                items[cursor++] = item;
            }
            ++i;
        }
        if (cursor < items.length) {
            if (cursor == 0) {
                items = new TreeItem[]{};
            } else {
                TreeItem[] tmp = new TreeItem[cursor];
                System.arraycopy(items, 0, tmp, 0, cursor);
                items = tmp;
            }
        }
        return items;
    }

    private abstract class BaseExpansionMaterializationContext
    extends BaseMaterializationContext {
        public BaseExpansionMaterializationContext() {
        }

        public BaseExpansionMaterializationContext(Object element) {
            super(element);
        }

        public abstract Expansion getMaterializedExpansion();
    }

    private abstract class BaseMaterializationContext
    implements IProviderContext,
    IElementInfo {
        private int childCount;
        protected Object element;
        private Boolean hasChildren;

        BaseMaterializationContext() {
            this.childCount = -1;
        }

        BaseMaterializationContext(Object element) {
            this.element = element;
            this.childCount = -1;
        }

        public void replace(Object parent, int index, Object element) {
            if (this.getIndex() == index && this.getParent().equals(parent)) {
                if (this.element == null) {
                    this.element = element;
                } else {
                    Assert.isTrue((boolean)this.element.equals(element));
                }
            }
        }

        protected abstract Object getParent();

        public abstract int getIndex();

        public void setChildCount(Object element, int count) {
            if (element.equals(this.element)) {
                this.childCount = count;
            }
        }

        public void setHasChildren(Object element, boolean hasChildren) {
            if (element.equals(this.element)) {
                this.hasChildren = hasChildren;
            }
        }

        public Object getElement() {
            if (this.element == null) {
                ILazyFragmentTreeContentProvider provider = (ILazyFragmentTreeContentProvider)FragmentedTreeViewer.this.getContentProvider();
                provider.updateElement(this.getParent(), this.getIndex(), this);
                Assert.isTrue((this.element != null ? 1 : 0) != 0);
            }
            return this.element;
        }

        public Object getData() {
            return this.getElement();
        }

        public int getDirectChildCount() {
            return this.getChildCount();
        }

        public int getChildCount() {
            if (this.childCount < 0) {
                ILazyFragmentTreeContentProvider provider = (ILazyFragmentTreeContentProvider)FragmentedTreeViewer.this.getContentProvider();
                Object element = this.getElement();
                if (this.childCount < 0) {
                    if (element != null) {
                        provider.updateChildCount(element, 0, this);
                        if (this.childCount < 0) {
                            this.childCount = 0;
                        }
                    } else {
                        this.childCount = 0;
                    }
                }
            }
            return this.childCount;
        }

        public boolean getHashChildren() {
            if (this.hasChildren == null) {
                if (this.childCount < 0) {
                    this.getChildCount();
                }
                this.hasChildren = this.childCount > 0;
            }
            return this.hasChildren;
        }
    }

    private class ExpansionMaterializationContext
    extends BaseExpansionMaterializationContext {
        private MoveInfo moveInfo;
        private Expansion childExpansion;

        public ExpansionMaterializationContext(MoveInfo info, Expansion exp) {
            this(info, exp, null);
        }

        public ExpansionMaterializationContext(MoveInfo info, Expansion exp, Object element) {
            super(element);
            this.moveInfo = info;
            this.childExpansion = exp;
        }

        public Expansion getMaterializedExpansion() {
            if (!this.childExpansion.isVirtual()) {
                return this.childExpansion;
            }
            int childCount = this.getChildCount();
            Object element = this.getElement();
            if (childCount > 0) {
                this.childExpansion = this.moveInfo.expandExpansion(this.childExpansion, element, childCount);
            } else {
                this.childExpansion.setData(element);
            }
            return this.childExpansion;
        }

        public int getIndex() {
            return this.childExpansion.getIndex();
        }

        protected Object getParent() {
            return this.childExpansion.getParent().getData();
        }
    }

    private class MoveInfo {
        private ExpansionRange newRange;
        private ExpansionRange oldRange;
        private Expansion newTopExpansion;
        private Expansion curTopExpansion;
        private Map forceExpansionMap;
        private boolean skipTopInfoAdjustment;
        private RootExpansion rootExpansion;
        private Set itemsToClear;
        private Expansion[] selection;

        MoveInfo(RootExpansion rootExpansion, ExpansionRange range) {
            this.rootExpansion = rootExpansion;
            this.oldRange = range;
        }

        public void addForceExpansion(Expansion exp) {
            this.addForceExpansion(exp, null);
        }

        public void addForceExpansion(Expansion exp, TreeItem item) {
            Assert.isTrue((!exp.isVirtual() ? 1 : 0) != 0);
            this.forceExpansionMap = this.addExpansionToMap(this.forceExpansionMap, exp, item);
        }

        void processItemRequestedWhileMove(TreeItem item) {
            if (this.itemsToClear == null) {
                this.itemsToClear = new HashSet();
            }
            item.setText(" ");
            this.itemsToClear.add(item);
        }

        public Map addExpansionToMap(Map map, Expansion exp, Object value) {
            if (map == null) {
                map = new HashMap<Expansion, Object>();
                map.put(exp, value);
                return map;
            }
            if (!this.isExpansionInMap(map, exp)) {
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    if (!exp.isParentOf((Expansion)iter.next())) continue;
                    iter.remove();
                }
                map.put(exp, value);
            }
            return map;
        }

        public boolean isForceExpansion(Expansion exp) {
            return this.isExpansionInMap(this.forceExpansionMap, exp);
        }

        /*
         * Unable to fully structure code
         */
        public boolean isExpansionInMap(Map map, Expansion exp) {
            if (map != null) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                if (map.containsKey(exp)) {
                    return true;
                }
                exp = exp.getParent();
lbl6:
                // 2 sources

                ** while (exp != null)
            }
lbl7:
            // 1 sources

            return false;
        }

        public void validateMoveInfo() {
            if (this.newTopExpansion != null) {
                Assert.isTrue((this.newRange.getRelation(this.newTopExpansion) == 1 ? 1 : 0) != 0);
            }
        }

        public void makeVisible(Expansion exp) {
            if (exp.isVisible()) {
                return;
            }
            Expansion[] parents = exp.getParents(false, true);
            int i = 0;
            while (i < parents.length) {
                if (!parents[i].isExpanded()) {
                    this.expandExpansion(parents[i], null, -1);
                }
                ++i;
            }
            Assert.isTrue((boolean)exp.isVisible());
        }

        public void apply() {
            Assert.isTrue((FragmentedTreeViewer.this.movingInfo == null ? 1 : 0) != 0);
            this.validateMoveInfo();
            boolean oldPreserving = FragmentedTreeViewer.this.preservingSelection;
            try {
                FragmentedTreeViewer.this.preservingSelection = true;
                FragmentedTreeViewer.this.movingInfo = this;
                Assert.isTrue((this.newRange != null ? 1 : 0) != 0);
                boolean processForceExpansionsOnly = false;
                boolean processSynch = true;
                if (this.newRange.equals(this.oldRange) || this.oldRange.getStartOffset() == 0 && this.oldRange.getSize(false) == this.rootExpansion.getAllChildSize(false) && this.newRange.getStartOffset() == 0 && this.newRange.getSize(false) == this.rootExpansion.getAllChildSize(false)) {
                    if (this.forceExpansionMap == null || this.forceExpansionMap.size() == 0) {
                        processSynch = false;
                    } else {
                        processForceExpansionsOnly = true;
                    }
                }
                if (!oldPreserving) {
                    if (this.selection == null && processSynch) {
                        this.selection = FragmentedTreeViewer.this.getSelectedExpansions();
                    }
                } else {
                    this.selection = null;
                }
                FragmentedTreeViewer.this.range = this.newRange;
                if (processSynch) {
                    if (processForceExpansionsOnly) {
                        for (Map.Entry entry : this.forceExpansionMap.entrySet()) {
                            Expansion exp = (Expansion)entry.getKey();
                            TreeItem item = (TreeItem)entry.getValue();
                            if (item == null && !exp.isRoot()) {
                                item = FragmentedTreeViewer.this.getTreeItem(exp);
                                Assert.isTrue((item != null ? 1 : 0) != 0);
                            }
                            this.synchWithExpansion(item == null ? FragmentedTreeViewer.this.getTree() : null, item, exp, this.newRange, exp, this.oldRange);
                        }
                    } else {
                        this.synchWithExpansion(FragmentedTreeViewer.this.getTree(), null, this.rootExpansion, this.newRange, this.rootExpansion, this.oldRange);
                    }
                }
                FragmentedTreeViewer.this.movingInfo = null;
                if (this.selection != null) {
                    FragmentedTreeViewer.this.setSelection(this.selection);
                }
                if (this.newTopExpansion != null) {
                    FragmentedTreeViewer.this.setTopVisibleExpansion(this.newTopExpansion);
                }
            }
            finally {
                if (this.newRange != null) {
                    FragmentedTreeViewer.this.range = this.newRange;
                }
                FragmentedTreeViewer.this.movingInfo = null;
                FragmentedTreeViewer.this.preservingSelection = oldPreserving;
                this.postProcessItemsToClear();
            }
        }

        private void postProcessItemsToClear() {
            if (this.itemsToClear == null || this.itemsToClear.size() == 0) {
                return;
            }
            for (TreeItem item : this.itemsToClear) {
                if (item.isDisposed()) continue;
                TreeItem parentItem = item.getParentItem();
                if (parentItem != null) {
                    int index = parentItem.indexOf(item);
                    parentItem.clear(index, true);
                    continue;
                }
                Tree tree = item.getParent();
                int index = tree.indexOf(item);
                tree.clear(index, true);
            }
        }

        private boolean removeItemToClear(TreeItem item) {
            if (this.itemsToClear == null) {
                return false;
            }
            return this.itemsToClear.remove(item);
        }

        public Expansion itemExpanded(TreeItem item, Object data, int childCount) {
            Expansion exp = FragmentedTreeViewer.this.getExpansion(item);
            return this.expandExpansion(exp, data, childCount);
        }

        public Expansion expandExpansion(Expansion exp, Object data, int childCount) {
            Assert.isTrue((!exp.isExpanded() ? 1 : 0) != 0);
            if (!exp.isExpanded()) {
                this.oldRange = this.oldRange.expand(exp, data, childCount);
                if (!this.skipTopInfoAdjustment) {
                    int expRoot;
                    this.skipTopInfoAdjustment = true;
                    if (this.newTopExpansion.isChildOf(exp)) {
                        this.newTopExpansion = exp;
                        this.curTopExpansion = null;
                    }
                    if (this.newTopExpansion.equals(exp)) {
                        this.newTopExpansion = exp;
                        if (this.curTopExpansion != null) {
                            this.curTopExpansion = exp;
                        }
                    }
                    int numVisibleItems = FragmentedTreeViewer.this.getNumVisibleItems();
                    int topVisibleRoot = this.newTopExpansion.getRootIndex();
                    if (topVisibleRoot > (expRoot = exp.getRootIndex()) || topVisibleRoot + numVisibleItems < expRoot + exp.getAllChildSize(false)) {
                        this.newTopExpansion = exp;
                    }
                }
                if (this.newTopExpansion != null) {
                    this.calcNewRangeInfoPreservingTopVisible(this.newTopExpansion);
                } else {
                    Assert.isTrue((this.newRange == null ? 1 : 0) != 0);
                }
            }
            return exp;
        }

        public void setNewTopVisibleExpansion(Expansion exp) {
            this.newTopExpansion = exp;
            this.calcNewRangeInfoPreservingTopVisible(this.newTopExpansion);
        }

        public void itemCollapsed(TreeItem item) {
            Expansion exp = FragmentedTreeViewer.this.getExpansion(item);
            this.collapseExpansion(exp);
        }

        public void collapseExpansion(Expansion exp) {
            Assert.isTrue((boolean)exp.isExpanded());
            int rootIndex = exp.getRootIndex();
            Expansion invalidExp = exp;
            this.oldRange = this.oldRange.collapse(exp, true);
            exp = this.rootExpansion.getChildExpansionByOffset(rootIndex, false);
            Assert.isTrue((exp != null ? 1 : 0) != 0);
            if (this.newTopExpansion == invalidExp) {
                this.newTopExpansion = exp;
            }
            if (this.curTopExpansion == invalidExp) {
                this.curTopExpansion = exp;
            }
            if (!this.skipTopInfoAdjustment) {
                this.skipTopInfoAdjustment = true;
                if (this.newTopExpansion.isChildOf(exp)) {
                    this.newTopExpansion = exp;
                    this.curTopExpansion = null;
                }
            }
            if (this.newTopExpansion != null) {
                this.calcNewRangeInfoPreservingTopVisible(this.newTopExpansion);
                Assert.isTrue((this.newRange.getRelation(this.newTopExpansion) != 0 ? 1 : 0) != 0);
            } else {
                Assert.isTrue((this.newRange == null ? 1 : 0) != 0);
            }
        }

        public void calcNewRangeInfoOnScroll(boolean scaleMode) {
            if (scaleMode) {
                this.calcNewRangeInfoPreservingScale(this.oldRange, this.curTopExpansion);
            } else {
                this.newTopExpansion = this.curTopExpansion;
                this.calcNewRangeInfoPreservingTopVisible(this.newTopExpansion);
            }
        }

        private void calcNewRangeInfoPreservingTopVisible(Expansion topVisExp) {
            long Ni = FragmentedTreeViewer.this.getMaxRangeSize(this.rootExpansion);
            long Nivis = FragmentedTreeViewer.this.getNumVisibleItems();
            long Nel = this.rootExpansion.getAllChildSize(false);
            if (Nel == Ni) {
                this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, 0, (int)Nel);
                this.newTopExpansion = topVisExp;
            } else {
                Assert.isTrue((Nel > Ni ? 1 : 0) != 0);
                long topvis = topVisExp.getRootIndex();
                if (topvis >= Nel - Nivis) {
                    this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, (int)(Nel - Ni), (int)Ni);
                    this.newTopExpansion = topVisExp;
                } else if (topvis == 0L) {
                    this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, 0, (int)Ni);
                    this.newTopExpansion = topVisExp;
                } else {
                    long start = (long)((double)(topvis * (Nel - Ni)) / (double)(Nel - Nivis + 1L));
                    if (start != 0L) {
                        Assert.isTrue((topvis >= start ? 1 : 0) != 0);
                        int numItemsVisible = FragmentedTreeViewer.this.getNumVisibleItems();
                        if (topvis - start < (long)numItemsVisible) {
                            start = topvis - (long)numItemsVisible;
                            if (start < 0L) {
                                start = 0L;
                            }
                        } else if (topvis - start >= Ni - Nivis) {
                            start = topvis - Ni + Nivis + 1L;
                        }
                        if (start > Nel - Ni) {
                            start = Nel - Ni;
                        }
                    }
                    this.newTopExpansion = topVisExp;
                    this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, (int)start, (int)Ni);
                }
            }
        }

        private void calcNewRangeInfoPreservingScale(ExpansionRange range, Expansion topVisible) {
            long Ni;
            long Nivis = FragmentedTreeViewer.this.getNumVisibleItems();
            long Nel = this.rootExpansion.getAllChildSize(false);
            if (Nel == (Ni = (long)range.getSize(false))) {
                Assert.isTrue((range.getStartOffset() == 0 ? 1 : 0) != 0);
                this.newRange = range;
                this.newTopExpansion = topVisible;
            } else {
                Assert.isTrue((Nel > Ni ? 1 : 0) != 0);
                int start = range.getStartOffset();
                int topvis = topVisible.getRootIndex();
                int topVisibleOffset = topvis - start;
                if (topVisibleOffset < 0) {
                    topVisibleOffset = 0;
                }
                if ((long)topVisibleOffset >= Ni - Nivis - 4L) {
                    if ((long)this.oldRange.getStartOffset() == Nel - Nivis) {
                        this.newRange = this.oldRange;
                        this.newTopExpansion = topVisible;
                    } else {
                        int newIndex = (int)(Nel - Nivis);
                        this.newTopExpansion = this.rootExpansion.getChildExpansionByOffset(newIndex, false);
                        this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, (int)(Nel - Ni), (int)Ni);
                    }
                } else if (topvis <= start) {
                    this.newTopExpansion = this.rootExpansion.getChildExpansionByOffset(0, false);
                    this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, 0, (int)Ni);
                } else {
                    long newTopVis = (long)((double)((long)topVisibleOffset * (Nel - Nivis)) / (double)(Ni - Nivis));
                    if (newTopVis >= Nel - Nivis) {
                        newTopVis = Nel - Nivis;
                        this.newTopExpansion = this.rootExpansion.getChildExpansionByOffset((int)newTopVis, false);
                        this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, (int)(Nel - Ni), (int)Ni);
                    } else if (newTopVis == 0L) {
                        this.newTopExpansion = this.rootExpansion.getChildExpansionByOffset(0, false);
                        this.newRange = ExpansionRange.createExpansionRange(this.rootExpansion, 0, (int)Ni);
                    } else {
                        this.newRange = range.moveToStart((int)(newTopVis - (long)topVisibleOffset), true);
                        this.newTopExpansion = this.rootExpansion.getChildExpansionByOffset(this.newRange.getStartOffset() + topVisibleOffset, false);
                    }
                }
            }
        }

        private void synchWithExpansion(Tree tr, TreeItem item, Expansion newExp, ExpansionRange range, Expansion oldExp, ExpansionRange oldRange) {
            int oldIndex;
            TreeItem[] items;
            int oldSize;
            TreeItem w;
            Expansion[] oldExpansions;
            int newStart = range.getStartIndex(newExp);
            int oldStart = oldExp != null ? oldRange.getStartIndex(oldExp) : -1;
            int newSize = range.getDirectChildCount(newExp);
            boolean isForce = !newExp.equals(oldExp) || this.isForceExpansion(newExp);
            boolean newAsOld = newStart == oldStart && !isForce;
            Expansion[] newExpansions = range.getDirectChildren(newExp, true);
            Expansion[] expansionArray = oldExpansions = oldExp != null ? oldRange.getDirectChildren(oldExp, true) : new Expansion[]{};
            if (item != null) {
                w = item;
                oldSize = item.getItemCount();
                if (newSize != oldSize) {
                    item.setItemCount(newSize);
                }
                item.setExpanded(true);
                if (newAsOld && newExpansions.length == 0 && oldExpansions.length == 0) {
                    return;
                }
                items = item.getItems();
            } else {
                w = tr;
                oldSize = tr.getItemCount();
                if (newSize != oldSize) {
                    tr.setItemCount(newSize);
                }
                if (newAsOld && newExpansions.length == 0 && oldExpansions.length == 0) {
                    return;
                }
                items = tr.getItems();
            }
            int newCursor = 0;
            int newIndex = newExpansions.length != 0 ? newExpansions[0].getIndex() : -1;
            int oldCursor = 0;
            int n = oldIndex = oldExpansions.length != 0 ? oldExpansions[0].getIndex() : -1;
            if (newAsOld) {
                int i = 0;
                while (i < items.length) {
                    TreeItem child;
                    Expansion newChildExp = null;
                    Expansion oldChildExp = null;
                    if (newStart + i == newIndex) {
                        newChildExp = newExpansions[newCursor++];
                        int n2 = newIndex = newExpansions.length > newCursor ? newExpansions[newCursor].getIndex() : -1;
                    }
                    if (oldStart >= 0 && oldStart + i == oldIndex) {
                        oldChildExp = oldExpansions[oldCursor++];
                        int n3 = oldIndex = oldExpansions.length > oldCursor ? oldExpansions[oldCursor].getIndex() : -1;
                    }
                    if (newChildExp != null) {
                        child = items[i];
                        if (child.getData() != null) {
                            this.synchWithExpansion(null, child, newChildExp, range, oldChildExp, oldRange);
                        } else {
                            FragmentedTreeViewer.this.replace((Widget)w, i, newChildExp.getData());
                            this.synchWithExpansion(null, child, newChildExp, range, oldChildExp, oldRange);
                        }
                        this.removeItemToClear(child);
                        if (newIndex == -1 && oldIndex == -1) {
                            break;
                        }
                    } else if (oldChildExp != null) {
                        child = items[i];
                        child.setText(" ");
                        child.setExpanded(false);
                        child.setItemCount(0);
                        if (newIndex == -1 && oldIndex == -1) break;
                        if (item != null) {
                            item.clear(i, true);
                        } else {
                            tr.clear(i, true);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < items.length) {
                    TreeItem child = items[i];
                    Expansion newChildExp = null;
                    Expansion oldChildExp = null;
                    if (newStart + i == newIndex) {
                        newChildExp = newExpansions[newCursor++];
                        int n4 = newIndex = newExpansions.length > newCursor ? newExpansions[newCursor].getIndex() : -1;
                    }
                    if (oldStart >= 0 && oldStart + i == oldIndex) {
                        oldChildExp = oldExpansions[oldCursor++];
                        int n5 = oldIndex = oldExpansions.length > oldCursor ? oldExpansions[oldCursor].getIndex() : -1;
                    }
                    if (child.getData() != null) {
                        FragmentedTreeViewer.this.disassociate((Item)child);
                        if (newChildExp != null) {
                            if (item != null) {
                                item.clear(i, true);
                            } else {
                                tr.clear(i, true);
                            }
                            FragmentedTreeViewer.this.replace((Widget)w, i, newChildExp.getData());
                            this.synchWithExpansion(null, child, newChildExp, range, oldChildExp, oldRange);
                        } else {
                            child.setExpanded(false);
                            child.setItemCount(0);
                            if (item != null) {
                                item.clear(i, true);
                            } else {
                                tr.clear(i, true);
                            }
                        }
                    } else if (newChildExp != null) {
                        FragmentedTreeViewer.this.replace((Widget)w, i, newChildExp.getData());
                        this.synchWithExpansion(null, child, newChildExp, range, oldChildExp, oldRange);
                    } else if (oldChildExp != null || isForce) {
                        child.setText(" ");
                        child.setExpanded(false);
                        child.setItemCount(0);
                        if (item != null) {
                            item.clear(i, true);
                        } else {
                            tr.clear(i, true);
                        }
                    }
                    this.removeItemToClear(child);
                    ++i;
                }
            }
        }
    }

    private class RootExpansionMaterializationContext
    extends BaseExpansionMaterializationContext {
        RootExpansionMaterializationContext(Object element) {
            super(element);
        }

        public void replace(Object parent, int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        protected Object getParent() {
            throw new UnsupportedOperationException();
        }

        public Expansion getMaterializedExpansion() {
            return this.getMaterializedRootExpansion();
        }

        public RootExpansion getMaterializedRootExpansion() {
            Object element = this.getElement();
            int childCount = this.getChildCount();
            return new RootExpansion(element, childCount);
        }

        public Object getElement() {
            return this.element;
        }
    }

    private class SimpleMaterializationContext
    extends BaseMaterializationContext {
        private int elementIndex;
        private Object parent;

        public SimpleMaterializationContext(Object parent, int elementIndex) {
            this(parent, elementIndex, null);
        }

        public SimpleMaterializationContext(Object parent, int elementIndex, Object element) {
            super(element);
            Assert.isTrue((parent != null && (elementIndex >= 0 || element != null) ? 1 : 0) != 0);
            this.parent = parent;
            this.elementIndex = elementIndex;
        }

        public int getIndex() {
            if (this.elementIndex == -1) {
                this.elementIndex = -2;
                ILazyFragmentTreeContentWithIndexProvider provider = (ILazyFragmentTreeContentWithIndexProvider)FragmentedTreeViewer.this.getContentProvider();
                this.elementIndex = provider.indexOf(this.getParent(), this.getElement());
                if (this.elementIndex == -1) {
                    this.elementIndex = -2;
                }
            }
            return this.elementIndex;
        }

        protected Object getParent() {
            return this.parent;
        }
    }

    private class TreeInfo {
        private Expansion topExpansion;
        private Expansion bottomExpansion;
        private int numVisibleExpansions = -1;
        private int maxItemForwardMove = -1;
        private int maxItemBackwardMove = -1;
        private TreeItem topItem;

        public TreeItem getTopItem() {
            if (this.topItem == null) {
                this.topItem = FragmentedTreeViewer.this.getTree().getTopItem();
            }
            return this.topItem;
        }

        public Expansion getTopVisibleExpansion() {
            TreeItem topItem;
            if (this.topExpansion == null && (topItem = this.getTopItem()) != null) {
                this.topExpansion = FragmentedTreeViewer.this.getExpansion(topItem);
            }
            return this.topExpansion;
        }

        public int getNumVisibleItems() {
            if (this.numVisibleExpansions == -1) {
                this.numVisibleExpansions = FragmentedTreeViewer.this.getNumVisibleItems();
            }
            return this.numVisibleExpansions;
        }

        public Expansion getVisibleExpansion(boolean bottom) {
            return bottom ? this.getBottomVisibleExpansion() : this.getTopVisibleExpansion();
        }

        public Expansion getBottomVisibleExpansion() {
            if (this.bottomExpansion == null) {
                Expansion topExpansion = this.getTopVisibleExpansion();
                if (topExpansion == null) {
                    Tree tree = FragmentedTreeViewer.this.getTree();
                    Assert.isTrue((tree.getItemCount() == 0 ? 1 : 0) != 0);
                    return null;
                }
                this.bottomExpansion = FragmentedTreeViewer.this.getBottomVisibleExpansion(topExpansion, this.getNumVisibleItems());
            }
            return this.bottomExpansion;
        }

        public boolean isVisible(Expansion exp) {
            int expIndex = exp.getRootIndex();
            return this.getTopVisibleExpansion().getRootIndex() <= expIndex && this.getBottomVisibleExpansion().getRootIndex() >= expIndex;
        }
    }
}

