/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractNumberColumnLabel
extends ColumnLabelAdapter {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        String attributeId = this.getContextAttribute(element, info);
        if (attributeId == null) {
            return "";
        }
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)attributeId, (int)1);
        if (!info.isDeltaColumn) {
            if (info.showPercentage) {
                return TString.formatAsPercentage((double)(this.getValue(element, info).doubleValue() / info.max));
            }
            return formatter.getDisplayStringFromElement((Object)this.getValue(element, info), element, 1);
        }
        if (element instanceof TRCPackage || element instanceof TRCClass || element instanceof TRCMethod || element instanceof MethodCallDetails) {
            return formatter.getDisplayStringFromElement((Object)this.getDelta(element, info), element, 1);
        }
        return "";
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        if (!info.isDeltaColumn) {
            double d;
            Number delta = this.getDelta(element, info);
            double d2 = d = delta != null ? delta.doubleValue() : 0.0;
            if (d < 0.0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (d > 0.0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            String attributeId = this.getContextAttribute(element, info);
            if (attributeId == null) {
                return null;
            }
            EObject eObj = ContextUpdaterHelper.getEObject(element);
            IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)attributeId, (int)1);
            return this.createImage(formatter.getDisplayImageByElement((Object)this.getValue(element, info), element, 1));
        }
        return null;
    }

    protected abstract Number getValue(Object var1, ColumnDisplayInfo var2);

    protected abstract Number getDelta(Object var1, ColumnDisplayInfo var2);

    protected abstract String getContextAttribute(Object var1, ColumnDisplayInfo var2);

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        if (!info.isDeltaColumn) {
            Number num = this.getValue(element, info);
            if (num == null) {
                return new Double(0.0);
            }
            return new Double(num.doubleValue());
        }
        Number num = this.getDelta(element, info);
        if (num == null) {
            return new Double(0.0);
        }
        return new Double(num.doubleValue());
    }
}

