/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;

public class ActiveSizeColumnLabel
extends AbstractNumberColumnLabel {
    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot();
            return new Integer(ps.getTotalSize() - ps.getCollectedSize());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot();
            return new Integer(cs.getTotalSize() - cs.getCollectedSize());
        }
        if (element instanceof TRCFullTraceObject) {
            int size = 0;
            size = ((TRCFullTraceObject)element).getCollectTime() != 0.0 ? 0 : ((TRCFullTraceObject)element).getSize();
            return new Integer(size);
        }
        if (element instanceof TRCObject) {
            return new Integer(((TRCObject)element).getSize());
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            TRCPackage p = (TRCPackage)element;
            p.computeDelta((IDelta)delta, 9);
            p.computeDelta((IDelta)delta, 11);
            return new Integer(delta.getTotalSize() - delta.getCollectedSize());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            TRCClass c = (TRCClass)element;
            c.computeDelta((IDelta)delta, 16);
            c.computeDelta((IDelta)delta, 18);
            return new Integer(delta.getTotalSize() - delta.getCollectedSize());
        }
        return null;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.active.size";
        }
        if (eObj instanceof TRCClass) {
            return "class.active.size";
        }
        if (eObj instanceof TRCObject) {
            return "object.active.size";
        }
        return null;
    }
}

